<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	
<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-public="-//W3C//DTD HTML 4.0 Transitional//EN" />
		
<!-- Etiquetas embebidas en los documentos -->

<!-- Listas -->

<xsl:template match='DOCUMENTO//UL'><ul><xsl:apply-templates/></ul></xsl:template>
<xsl:template match='DOCUMENTO//DL'><dl><xsl:apply-templates/></dl></xsl:template>
<xsl:template match='DOCUMENTO//LI'><li><xsl:apply-templates/></li></xsl:template>
<xsl:template match='DOCUMENTO//DT'><dt><xsl:apply-templates/></dt></xsl:template>
<xsl:template match='DOCUMENTO//DD'><dd><xsl:apply-templates/></dd></xsl:template>

<xsl:template match='DOCUMENTO//OL'>
	<xsl:element name='ol'>
		<xsl:attribute name='type'><xsl:value-of select='@type'/></xsl:attribute>
		<xsl:attribute name='start'><xsl:value-of select='@start'/></xsl:attribute>
		<xsl:apply-templates/>
	</xsl:element>
</xsl:template>


<!-- tablas -->

<xsl:template match='DOCUMENTO//TABLE'>
	<xsl:element name='table'>
		<xsl:if test='@border'>
			<xsl:attribute name='border'>1 solid black</xsl:attribute>
			<xsl:attribute name='style'>border-collapse:collapse;</xsl:attribute>
		</xsl:if>
		<xsl:attribute name='width'><xsl:value-of select='@width'/></xsl:attribute>
		<xsl:attribute name='align'><xsl:value-of select='@align'/></xsl:attribute>
		<xsl:attribute name='cellpadding'>3</xsl:attribute>
		<xsl:apply-templates/>
	</xsl:element>
	<br clear="all"/>
</xsl:template>

<xsl:template match='DOCUMENTO//TR'><tr><xsl:apply-templates/></tr></xsl:template>

<xsl:template match='DOCUMENTO//TH'>
	<xsl:element name='th'>
		<xsl:attribute name='rowspan'><xsl:value-of select='@rowspan'/></xsl:attribute>
		<xsl:attribute name='colspan'><xsl:value-of select='@colspan'/></xsl:attribute>
		<xsl:attribute name='valign'><xsl:value-of select='@valign'/></xsl:attribute>
		<xsl:attribute name='align'><xsl:value-of select='@align'/></xsl:attribute>
		<xsl:attribute name='width'><xsl:value-of select='@width'/></xsl:attribute>
		<xsl:attribute name='height'><xsl:value-of select='@height'/></xsl:attribute>
		<xsl:attribute name='bgcolor'><xsl:value-of select='@bgcolor'/></xsl:attribute>
		<xsl:apply-templates/>
	</xsl:element>
</xsl:template>

<xsl:template match='DOCUMENTO//TD'>
	<xsl:element name='td'>
		<xsl:attribute name='rowspan'><xsl:value-of select='@rowspan'/></xsl:attribute>
		<xsl:attribute name='colspan'><xsl:value-of select='@colspan'/></xsl:attribute>
		<xsl:attribute name='valign'><xsl:value-of select='@valign'/></xsl:attribute>
		<xsl:attribute name='align'><xsl:value-of select='@align'/></xsl:attribute>
		<xsl:attribute name='width'><xsl:value-of select='@width'/></xsl:attribute>
		<xsl:attribute name='height'><xsl:value-of select='@height'/></xsl:attribute>
		<xsl:attribute name='bgcolor'><xsl:value-of select='@bgcolor'/></xsl:attribute>
		<xsl:apply-templates/>
	</xsl:element>
</xsl:template>


<!-- Vínculos -->

<xsl:template match="DOCUMENTO//LINK_DOC_ANAME">
	<xsl:element name='a'>
		<xsl:attribute name='name'><xsl:value-of select='@name'/></xsl:attribute>
		<xsl:apply-templates />
	</xsl:element>
</xsl:template>

<xsl:template match="DOCUMENTO//LINK_DOC_VINC">
	<xsl:element name='a'>
		<xsl:attribute name='href'>#<xsl:value-of select='@href'/></xsl:attribute>
		<xsl:apply-templates />
	</xsl:element>
</xsl:template>

<xsl:template match="DOCUMENTO//LINK_DOC_HREF">
	<a href="#">
		<xsl:attribute name='onclick'>linkDoc('<xsl:value-of select='/*//DOCUMENTO/@DBName'/>','<xsl:value-of select='/*//DOCUMENTO/@Qry'/>','<xsl:value-of select='/*//DOCUMENTO/@PgQry'/>','<xsl:value-of select='/*//DOCUMENTO/@NumDoc'/>','<xsl:value-of select='substring(@id,2)'/>')</xsl:attribute>
		<xsl:attribute name='name'><xsl:value-of select='@href'/></xsl:attribute>
		<xsl:apply-templates/>
	</a>
</xsl:template>

<xsl:template match="DOCUMENTO//LINK_DOC_CONS">
	<xsl:element name='a'>
		<xsl:attribute name='href'>knqry?bd=<xsl:value-of select='/*//DOCUMENTO/@DBName'/>&#38;q=<xsl:value-of select='@href'/></xsl:attribute>
		<xsl:apply-templates />
	</xsl:element>
</xsl:template>

<xsl:template match="DOCUMENTO//LINK_FILE"></xsl:template>

<xsl:template match="DOCUMENTO//LINK_URL">
	<xsl:element name="a">
		<xsl:attribute name="href"><xsl:value-of select="@href"/></xsl:attribute>
		<xsl:attribute name="target">_blank</xsl:attribute>
		<xsl:apply-templates />
	</xsl:element>
</xsl:template>


<!-- Marcas de página-->
<xsl:template match="DOCUMENTO//NPAGE"><xsl:apply-templates /></xsl:template>


<!-- Archivos -->

<xsl:template match="DOCUMENTO//EMBED_OLE">
<!-- No soportado -->
</xsl:template>

<xsl:template match="DOCUMENTO//TARGET_OLE_SRV">
	<xsl:element name='img'>
		<xsl:attribute name='src'>knobj?bd=<xsl:value-of select='@srv'/>&#38;t=1&#38;n=<xsl:value-of select='@src'/>&#38;id=<xsl:value-of select='substring(@id,2)'/></xsl:attribute>
		<xsl:attribute name='align'>left</xsl:attribute>
	</xsl:element>
	<xsl:element name='a'>
		<xsl:attribute name='href'>knobj?bd=<xsl:value-of select='@srv'/>&#38;t=1&#38;n=<xsl:value-of select='@src'/>&#38;id=<xsl:value-of select='substring(@id,2)'/></xsl:attribute>
		<xsl:value-of select='@alt'/>
	</xsl:element>
</xsl:template>

<!-- Objetos en colecciones -->
<xsl:template match='DOCUMENTO//TARGET_MEDIA_SRV[@type="GIF" or @type="JPG"]'>
	<xsl:element name='img'>
		<xsl:attribute name='src'>knobj?bd=<xsl:value-of select='@srv'/>&#38;t=1&#38;obj=<xsl:value-of select='@src'/>&#38;id=<xsl:value-of select='substring(@id,2)'/></xsl:attribute>
		<xsl:attribute name='title'><xsl:value-of select='@alt'/></xsl:attribute>
	</xsl:element>
	<br clear='all'/>
</xsl:template>
<xsl:template match='DOCUMENTO//TARGET_MEDIA_SRV[@type!="GIF" and @type!="JPG"]'>
	<xsl:element name='a'>
		<xsl:attribute name='href'>knobj?bd=<xsl:value-of select='@srv'/>&#38;t=1&#38;obj=<xsl:value-of select='@src'/>&#38;id=<xsl:value-of select='substring(@id,2)'/></xsl:attribute>
		<xsl:value-of select='@alt'/>
	</xsl:element>
	<br clear='all'/>
</xsl:template>

<!-- Objetos enlazados -->
<xsl:template match='DOCUMENTO//TARGET_MEDIA_LNK'>
	<xsl:if test='(@type) and (@type="GIF" or @type="JPG" or @type="PNG" or @type="BMP")'>
			<xsl:element name='img'>
				<xsl:attribute name='src'>knobj?bd=<xsl:value-of select='//DOCUMENTO/@DBName'/>&#38;t=0&#38;obj=<xsl:value-of select='@src'/>&#38;id=<xsl:value-of select='substring(@id,2)'/></xsl:attribute>
			</xsl:element>
	</xsl:if>
	<xsl:if test='(@type) and (@type="MP3" or @type="WAV" or @type="WMA")'>
		<xsl:element name='a'>
			<xsl:attribute name='href'>knobj?bd=<xsl:value-of select="//DOCUMENTO/@DBName"/>&amp;t=0&amp;obj=<xsl:value-of select="@src"/>&amp;id=<xsl:value-of select="substring(@id,2)"/></xsl:attribute>
			<xsl:element name='img'>
				<xsl:attribute name='src'>image/AUDIO.gif</xsl:attribute>
				<xsl:attribute name='border'>0</xsl:attribute>
			</xsl:element>
			&#160;<xsl:value-of select='@src'/>
		</xsl:element>
		&#160;
	</xsl:if>
	<xsl:if test='(@type) and (@type="AVI")'>
		<xsl:element name='a'>
			<xsl:attribute name='href'>knobj?bd=<xsl:value-of select="//DOCUMENTO/@DBName"/>&amp;t=0&amp;obj=<xsl:value-of select="@src"/>&amp;id=<xsl:value-of select="substring(@id,2)"/></xsl:attribute>
			<xsl:element name='img'>
				<xsl:attribute name='src'>image/VIDEO.gif</xsl:attribute>
				<xsl:attribute name='border'>0</xsl:attribute>
			</xsl:element>
			&#160;<xsl:value-of select='@src'/>
		</xsl:element>
		&#160;
	</xsl:if>
	<xsl:if test='(@type) and (@type!="GIF" and @type!="JPG" and @type!="PNG" and @type!="BMP" and @type!="MP3" and @type!="WAV" and @type!="WMA" and @type!="AVI")'>
		<a class="medialink" target="_blank">
			<xsl:attribute name='href'>knobj?bd=<xsl:value-of select="//DOCUMENTO/@DBName"/>&amp;t=0&amp;obj=<xsl:value-of select="@src"/>&amp;id=<xsl:value-of select="substring(@id,2)"/></xsl:attribute>
			<xsl:attribute name='style'>text-decoration:none</xsl:attribute>
			<xsl:element name='img'>				
				<xsl:attribute name='src'>image/<xsl:value-of select="translate(@type, $uppercase, $smallcase)" />.png</xsl:attribute>
				<xsl:attribute name='border'>0</xsl:attribute>
				<xsl:attribute name='title'><xsl:value-of select='@src'/></xsl:attribute>
				<xsl:attribute name='alt'><xsl:value-of select='@src'/></xsl:attribute>
			</xsl:element>
			<xsl:value-of select='@src'/>
		</a>
		&#160;
	</xsl:if>
	<xsl:if test='not (@type)'>
		<xsl:element name='a'>
			<xsl:attribute name='href'>knobj?bd=<xsl:value-of select="//DOCUMENTO/@DBName"/>&amp;t=0&amp;obj=<xsl:value-of select="@src"/>&amp;id=<xsl:value-of select="substring(@id,2)"/></xsl:attribute>
			&#160;<xsl:value-of select='@src'/>
		</xsl:element>
		&#160;
	</xsl:if>
</xsl:template>

<!-- Objetos embebidos -->
<xsl:template match='DOCUMENTO//EMBED_MEDIA'>
	<!-- No soportado -->
</xsl:template>


<xsl:template match="DOCUMENTO//TARGET_OLE_LNK">
	<xsl:element name='a'>
		<xsl:attribute name='href'>knobj?bd=<xsl:value-of select='//DOCUMENTO/@DBName'/>&#38;t=0&#38;n=<xsl:value-of select='@src'/>&#38;id=<xsl:value-of select='substring(@id,2)'/></xsl:attribute>
		<xsl:value-of select='@alt'/>
	</xsl:element>
</xsl:template>


<!-- Estilos (los definidos en la BBDD) -->

	<xsl:template match='B'><b><xsl:apply-templates/></b></xsl:template>
	<xsl:template match='b'><b><xsl:apply-templates/></b></xsl:template>
	<xsl:template match='NEGRITA'><b><xsl:apply-templates/></b></xsl:template>
	<xsl:template match='Negrita'><b><xsl:apply-templates/></b></xsl:template>
	<xsl:template match='negrita'><b><xsl:apply-templates/></b></xsl:template>
	<xsl:template match='KnoStyle1024'><b><xsl:apply-templates/></b></xsl:template>
						 
	<xsl:template match='I'><i><xsl:apply-templates/></i></xsl:template>
	<xsl:template match='i'><i><xsl:apply-templates/></i></xsl:template>
	<xsl:template match='ITALICA'><i><xsl:apply-templates/></i></xsl:template>
	<xsl:template match='Italica'><i><xsl:apply-templates/></i></xsl:template>
	<xsl:template match='italica'><i><xsl:apply-templates/></i></xsl:template>
	<xsl:template match='KnoStyle1025'><i><xsl:apply-templates/></i></xsl:template>

	<xsl:template match='CURSIVA'><i><xsl:apply-templates/></i></xsl:template>
	<xsl:template match='Cursiva'><i><xsl:apply-templates/></i></xsl:template>
	<xsl:template match='cursiva'><i><xsl:apply-templates/></i></xsl:template>
	<xsl:template match='Style1025'><i><xsl:apply-templates/></i></xsl:template>
	
	<xsl:template match='U'><u><xsl:apply-templates/></u></xsl:template>
	<xsl:template match='u'><u><xsl:apply-templates/></u></xsl:template>
	<xsl:template match='Style1026'><u><xsl:apply-templates/></u></xsl:template>
	
	<xsl:template match='SUBRAYADO'><u><xsl:apply-templates/></u></xsl:template>
	<xsl:template match='Subrayado'><u><xsl:apply-templates/></u></xsl:template>
	<xsl:template match='subrayado'><u><xsl:apply-templates/></u></xsl:template>
	<xsl:template match='KnoStyle1026'><u><xsl:apply-templates/></u></xsl:template>
	
	<xsl:template match='SUP'><sup><xsl:apply-templates/></sup></xsl:template>
	<xsl:template match='Sup'><sup><xsl:apply-templates/></sup></xsl:template>
	<xsl:template match='sup'><sup><xsl:apply-templates/></sup></xsl:template>
	
	<xsl:template match='SUPERINDICE'><sup><xsl:apply-templates/></sup></xsl:template>
	<xsl:template match='Superindice'><sup><xsl:apply-templates/></sup></xsl:template>
	<xsl:template match='superindice'><sup><xsl:apply-templates/></sup></xsl:template>
	<xsl:template match='SUPERÍNDICE'><sup><xsl:apply-templates/></sup></xsl:template>
	<xsl:template match='Superíndice'><sup><xsl:apply-templates/></sup></xsl:template>
	<xsl:template match='superíndice'><sup><xsl:apply-templates/></sup></xsl:template>
	
	<xsl:template match='SUB'><sub><xsl:apply-templates/></sub></xsl:template>
	<xsl:template match='Sub'><sub><xsl:apply-templates/></sub></xsl:template>
	<xsl:template match='sub'><sub><xsl:apply-templates/></sub></xsl:template>
	<xsl:template match='SUBINDICE'><sub><xsl:apply-templates/></sub></xsl:template>
	<xsl:template match='Subindice'><sub><xsl:apply-templates/></sub></xsl:template>
	<xsl:template match='subindice'><sub><xsl:apply-templates/></sub></xsl:template>
	
	<xsl:template match='SUBÍNDICE'><sub><xsl:apply-templates/></sub></xsl:template>
	<xsl:template match='Subíndice'><sub><xsl:apply-templates/></sub></xsl:template>
	<xsl:template match='subíndice'><sub><xsl:apply-templates/></sub></xsl:template>

	<xsl:template match='Indice'><b><xsl:apply-templates/></b></xsl:template>

	<xsl:template match='BRK'><BR/></xsl:template>

	<xsl:template match='span'>
		<xsl:choose>
			<xsl:when test="@class">
				<xsl:choose>
					<xsl:when test="@class = 'indice'">
						<b><xsl:apply-templates/></b>
					</xsl:when>
					<xsl:otherwise>
						<xsl:element name="span">
							<xsl:attribute name="class"><xsl:value-of select="@class"/></xsl:attribute>
							<xsl:apply-templates/>
						</xsl:element>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match='div'>
		<xsl:choose>
			<xsl:when test="@class">
				<xsl:element name="div">
					<xsl:attribute name="class"><xsl:value-of select="@class"/></xsl:attribute>
					<xsl:apply-templates/>
				</xsl:element>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


<!-- Parrafo -->

<xsl:template match='DOCUMENTO//P'>
	<xsl:choose>
		<xsl:when test="@class"> 		
			<xsl:element name="p">
				<xsl:choose>
					<xsl:when test="@class = 'KnoStyle1027'">
						<xsl:attribute name='style'>text-align: left;<xsl:value-of select='@class'/></xsl:attribute>
					</xsl:when>
					<xsl:when test="@class = 'KnoStyle1028'">
						<xsl:attribute name='style'>text-align: right;<xsl:value-of select='@class'/></xsl:attribute>
					</xsl:when>
					<xsl:when test="@class = 'KnoStyle1029'">
						<xsl:attribute name='style'>text-align: justify;<xsl:value-of select='@class'/></xsl:attribute>
					</xsl:when>
					<xsl:when test="@class = 'KnoStyle1030'">
						<xsl:attribute name='style'>text-align: center;<xsl:value-of select='@class'/></xsl:attribute>
					</xsl:when>	
					<xsl:otherwise>
						<xsl:attribute name='class'><xsl:value-of select='@class'/></xsl:attribute>
					</xsl:otherwise>				
				</xsl:choose>				
				<xsl:apply-templates/>
			</xsl:element>
		</xsl:when>
		<xsl:otherwise>
			<xsl:apply-templates/><br/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<!-- Máscaras -->
<xsl:template match='MASK'>
	<!-- No soportado -->
</xsl:template>

<xsl:variable name="smallcase" select="'abcdefghijklmnopqrstuvwxyz'" />
<xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'" />

</xsl:stylesheet>