/*
 * Decompiled with CFR 0.152.
 */
package micronet.utils.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlUtils {
    private static DocumentBuilder m_docBuilder;
    private static TransformerFactory m_transFactory;

    static {
        m_transFactory = TransformerFactory.newInstance();
    }

    public Templates createTemplate(String fichero) throws TransformerConfigurationException, MalformedURLException, URISyntaxException {
        URL url = new URL("file:///" + fichero);
        StreamSource s = new StreamSource(url.toString());
        return m_transFactory.newTemplates(s);
    }

    public void xml2html(Document xml, Templates xsl, Writer out) throws TransformerConfigurationException, TransformerException {
        if (xml == null) {
            throw new TransformerException("jnapp [XmlUtils::xml2html]: No hay documento que transformar\n");
        }
        if (out == null) {
            throw new TransformerException("jnapp [XmlUtils::xml2html]: No se especific\u00ef\u00bf\u00bd la salida\n");
        }
        Transformer transformer = null;
        transformer = xsl != null ? xsl.newTransformer() : m_transFactory.newTransformer();
        transformer.transform(new DOMSource(xml), new StreamResult(out));
    }

    public static String xml2Str(Document xml) throws TransformerConfigurationException, TransformerException {
        return XmlUtils.xml2Str(xml, "ISO-8859-1");
    }

    public static String xml2Str(Document xml, String encoding) throws TransformerConfigurationException, TransformerException {
        if (xml == null) {
            throw new TransformerException("jnapp [XmlUtils::xml2html]: No hay documento que transformar\n");
        }
        Transformer transformer = m_transFactory.newTransformer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        transformer.setOutputProperty("encoding", encoding);
        transformer.transform(new DOMSource(xml), new StreamResult(baos));
        return baos.toString();
    }

    public Document createDoc(String sXml) throws IOException, SAXException {
        return m_docBuilder.parse(new ByteArrayInputStream(sXml.getBytes()));
    }

    public static String formatea(String sXml) {
        String sXmlOk = "";
        int cont = 0;
        while (cont < sXml.length()) {
            char c = sXml.charAt(cont);
            sXmlOk = c != '\n' && (c < ' ' || c > 'z') ? String.valueOf(sXmlOk) + "&#" + c + ";" : String.valueOf(sXmlOk) + sXml.charAt(cont);
            ++cont;
        }
        return sXmlOk;
    }

    public static byte[] formatea(byte[] b) {
        String sXmlOk = "";
        int x = 0;
        while (x < b.length) {
            sXmlOk = b[x] != 10 && b[x] != 13 && (b[x] < 32 || b[x] > 122) ? String.valueOf(sXmlOk) + "&#" + b[x] + ";" : String.valueOf(sXmlOk) + (char)b[x];
            ++x;
        }
        return sXmlOk.getBytes();
    }

    public static Document crearDocumentoVacio(String tag, String session, boolean bCookieSesion) {
        DocumentBuilder docbuilder = null;
        try {
            docbuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = docbuilder.newDocument();
            if (doc != null) {
                Element e_base = doc.createElement(tag);
                e_base.setAttribute("Session", session);
                e_base.setAttribute("CookieSession", bCookieSesion ? "1" : "0");
                doc.appendChild(e_base);
            }
            return doc;
        }
        catch (Exception Ex) {
            return null;
        }
    }

    public static Document crearDocumento(String xml, String encoding) throws Exception {
        try {
            return XmlUtils.createDocument(new ByteArrayInputStream(xml.getBytes(encoding)));
        }
        catch (UnsupportedEncodingException e) {
            return XmlUtils.createDocument(new ByteArrayInputStream(xml.getBytes()));
        }
        catch (Exception ex) {
            throw ex;
        }
    }

    public static Document crearDocumento(byte[] xml) throws Exception {
        return XmlUtils.createDocument(new ByteArrayInputStream(xml));
    }

    public static Document crearDocumento(String xml) throws Exception {
        return XmlUtils.createDocument(new ByteArrayInputStream(xml.getBytes()));
    }

    public static Document createDocument(InputStream xml) throws Exception {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder docBuilder = dbf.newDocumentBuilder();
            return docBuilder.parse(xml);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            throw ex;
        }
    }

    public static Document createDocumentError(InputStream xml) throws Exception {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder docBuilder = dbf.newDocumentBuilder();
            return docBuilder.parse(xml);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            throw ex;
        }
    }

    public static boolean insertarElemento(Document doc, Element e) {
        try {
            doc.getDocumentElement().appendChild(doc.importNode(e, true));
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static Templates crearPlantilla(String fichero) throws TransformerConfigurationException, MalformedURLException {
        URL url = new URL("file:///" + fichero);
        StreamSource s = new StreamSource(url.toString());
        TransformerFactory xslFactory = TransformerFactory.newInstance();
        return m_transFactory.newTemplates(s);
    }

    public static Templates crearPlantilla(InputStream file) throws TransformerConfigurationException {
        TransformerFactory xslFactory = TransformerFactory.newInstance();
        return xslFactory.newTemplates(new StreamSource(file));
    }

    public static void transforma(Document xml, Templates xsl, Writer out) throws TransformerConfigurationException, TransformerException {
        XmlUtils.transforma(xml, xsl, out, null, "UTF-8");
    }

    public static void transforma(Document xml, Templates xsl, Writer out, String charset) throws TransformerConfigurationException, TransformerException {
        XmlUtils.transforma(xml, xsl, out, null, charset);
    }

    public static void transforma(Document xml, Templates xsl, Writer out, Map parameters) throws TransformerConfigurationException, TransformerException {
        XmlUtils.transforma(xml, xsl, out, parameters, "UTF-8");
    }

    public static void transforma(Node node, Templates xsl, Writer out, Map parameters) throws TransformerConfigurationException, TransformerException {
        XmlUtils.transforma(node, xsl, out, parameters, "UTF-8");
    }

    public static void transforma(Document xml, Templates xsl, Writer out, Map parameters, String charset) throws TransformerConfigurationException, TransformerException {
        if (xml == null) {
            throw new TransformerException("jnapp [XmlUtils::xml2html]: No hay documento que transformar\n");
        }
        if (out == null) {
            throw new TransformerException("jnapp [XmlUtils::xml2html]: No se especific\u00ef\u00bf\u00bd la salida\n");
        }
        Transformer transformer = null;
        if (xsl != null) {
            transformer = xsl.newTransformer();
        } else {
            TransformerFactory xslFactory = TransformerFactory.newInstance();
            transformer = xslFactory.newTransformer();
        }
        if (parameters != null) {
            Set set = parameters.keySet();
            for (String key : set) {
                String value = (String)parameters.get(key);
                transformer.setParameter(key, value);
            }
        }
        transformer.setOutputProperty("encoding", charset);
        transformer.transform(new DOMSource(xml), new StreamResult(out));
    }

    public static void transforma(Node node, Templates xsl, Writer out, Map parameters, String charset) throws TransformerConfigurationException, TransformerException {
        if (node == null) {
            throw new TransformerException("jnapp [XmlUtils::xml2html]: No hay nodo que transformar\n");
        }
        if (out == null) {
            throw new TransformerException("jnapp [XmlUtils::xml2html]: No se especific\u00ef\u00bf\u00bd la salida\n");
        }
        Transformer transformer = null;
        if (xsl != null) {
            transformer = xsl.newTransformer();
        } else {
            TransformerFactory xslFactory = TransformerFactory.newInstance();
            transformer = xslFactory.newTransformer();
        }
        if (parameters != null) {
            Set set = parameters.keySet();
            for (String key : set) {
                String value = (String)parameters.get(key);
                transformer.setParameter(key, value);
            }
        }
        transformer.setOutputProperty("encoding", charset);
        transformer.transform(new DOMSource(node), new StreamResult(out));
    }

    public static String getNodeContentByName(Node node, String nodeName) {
        Node nodeContent = XmlUtils.getNodeByName(node, nodeName);
        if (nodeContent != null) {
            return nodeContent.getTextContent();
        }
        return null;
    }

    public static Node getNodeByName(Node node, String nodeName) {
        return XmlUtils.getNodeByName((Element)node, nodeName);
    }

    public static Node getNodeByName(Element elem, String nodeName) {
        NodeList nodes = elem.getElementsByTagName(nodeName);
        if (nodes.getLength() > 0) {
            return nodes.item(0);
        }
        return null;
    }

    public static Node getNodeByName(Document dom, String nodeName) {
        return XmlUtils.getNodeByName(dom, nodeName, null, null);
    }

    public static Node getNodeByName(Document dom, String nodeName, String attributeName, String attributeValue) {
        Node node = null;
        NodeList nodes = dom.getElementsByTagName(nodeName);
        if (attributeName == null || attributeName.length() == 0) {
            if (nodes.getLength() > 0) {
                return nodes.item(0);
            }
            return null;
        }
        Boolean bFound = Boolean.FALSE;
        int i = 0;
        while (i < nodes.getLength() && !bFound.booleanValue()) {
            node = nodes.item(i);
            NamedNodeMap attributes = node.getAttributes();
            int j = 0;
            while (j < attributes.getLength()) {
                Node attribute = attributes.item(j);
                if (attribute.getNodeName().compareToIgnoreCase(attributeName) == 0 && attribute.getNodeValue().compareToIgnoreCase(attributeValue) == 0) {
                    bFound = Boolean.TRUE;
                    break;
                }
                ++j;
            }
            ++i;
        }
        if (!bFound.booleanValue()) {
            return null;
        }
        return node;
    }

    public static String getStringFromDocument(Document doc) {
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String stripNonValidXMLCharacters(String in) {
        StringBuffer out = new StringBuffer();
        if (in == null || "".equals(in)) {
            return "";
        }
        int i = 0;
        while (i < in.length()) {
            char current = in.charAt(i);
            if (current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd' || current >= '\u10000' && current <= '\u10ffff') {
                out.append(current);
            }
            ++i;
        }
        return out.toString();
    }

    public static String printDOM(Node doc) {
        String output = "";
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(doc), new StreamResult(writer));
            output = writer.getBuffer().toString().replaceAll("\n|\r", "");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return output;
    }

    public static String extractText(Node node) {
        String string = "";
        if (node == null) {
            return string;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                string = String.valueOf(string) + XmlUtils.extractText(((Document)node).getDocumentElement());
                break;
            }
            case 1: {
                string = String.valueOf(string) + " ";
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                int i = 0;
                while (i < len) {
                    string = String.valueOf(string) + XmlUtils.extractText(children.item(i));
                    ++i;
                }
                break;
            }
            case 5: {
                string = String.valueOf(string) + "&";
                string = String.valueOf(string) + node.getNodeName().trim();
                string = String.valueOf(string) + ";";
                break;
            }
            case 4: {
                string = String.valueOf(string) + " ";
                break;
            }
            case 3: {
                string = String.valueOf(string) + node.getNodeValue();
                break;
            }
            case 7: {
                string = String.valueOf(string) + " ";
            }
        }
        return string;
    }
}

