/*
 * Decompiled with CFR 0.152.
 */
package es.knosys.tools;

import es.knosys.tools.KnoRemote;
import java.awt.Color;
import java.io.IOException;
import java.nio.ByteBuffer;

public class KnoUtil {
    private static final char NULL_CHAR = '\u0000';
    private static final int TAM_BYTE = 1;
    private static final int TAM_WORD = 2;
    private static final int TAM_DWORD = 4;
    private static final int COLOR_SIZE = 4;

    public static String readString(KnoRemote remote, int size) {
        byte[] array = new byte[size];
        remote.in.read(array);
        return KnoUtil.cleanString(new String(array));
    }

    public static byte[] readBytes(KnoRemote remote, int size) {
        byte[] array = new byte[size];
        remote.in.read(array);
        return array;
    }

    public static void writeString(KnoRemote remote, String string, int size) throws IOException {
        byte[] array = new byte[size - string.length()];
        remote.out.write(string.getBytes());
        remote.out.write(array);
    }

    public static Color readColor(KnoRemote remote) {
        byte[] color = KnoUtil.readBytes(remote, 4);
        return KnoUtil.byteArray2Color(color);
    }

    public static final String ByteBuffer2String(ByteBuffer bytes, int size) {
        byte[] result = new byte[size];
        bytes.get(result);
        return KnoUtil.cleanString(new String(result));
    }

    public static final byte[] ByteBuffer2ByteArray(ByteBuffer bytes, int size) {
        byte[] result = new byte[size];
        bytes.get(result);
        return result;
    }

    public static final short ByteBuffer2Word(ByteBuffer bytes) {
        byte[] result = new byte[2];
        bytes.get(result);
        return KnoUtil.uShort2Int(result);
    }

    public static final int ByteBuffer2DWord(ByteBuffer bytes) {
        byte[] result = new byte[4];
        bytes.get(result);
        return KnoUtil.uIntToInt(result);
    }

    public static final Color ByteBuffer2Color(ByteBuffer bytes) {
        byte[] color = new byte[4];
        bytes.get(color);
        return KnoUtil.byteArray2Color(color);
    }

    public static final void putString(ByteBuffer bytes, String string, int size) {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.put(string.getBytes());
        bytes.put(buffer.array());
    }

    private static String cleanString(String string) {
        int index = string.indexOf(0);
        if (index >= 0) {
            return string.substring(0, string.indexOf(0));
        }
        return string;
    }

    public static final byte ByteBuffer2Byte(ByteBuffer bytes) {
        byte[] result = new byte[1];
        bytes.get(result);
        return (byte)KnoUtil.uByte2Int(result);
    }

    public static final char ByteBuffer2Char(ByteBuffer bytes) {
        return (char)KnoUtil.ByteBuffer2Byte(bytes);
    }

    public static final String color2Hex(Color color) {
        String hex = String.valueOf(String.format("%02X", color.getRed())) + String.format("%02X", color.getGreen()) + String.format("%02X", color.getBlue());
        return "#" + hex;
    }

    public static final Color hex2Color(String color) {
        int r = Integer.parseInt(color.substring(1, 3), 16);
        int g = Integer.parseInt(color.substring(3, 5), 16);
        int b = Integer.parseInt(color.substring(5, 7), 16);
        return new Color(r, g, b);
    }

    public static final int colorToInt(Color color) {
        return color.getRed() + (color.getGreen() << 8) + (color.getBlue() << 16);
    }

    private static final int uByte2Int(byte[] b) {
        int i = 0;
        return i |= b[0] & 0xFF;
    }

    private static final short uShort2Int(byte[] b) {
        short i = 0;
        i = (short)(i | b[1] & 0xFF);
        i = (short)(i << 8);
        i = (short)(i | b[0] & 0xFF);
        return i;
    }

    private static final int uIntToInt(byte[] b) {
        int l = 0;
        l |= b[3] & 0xFF;
        l <<= 8;
        l |= b[2] & 0xFF;
        l <<= 8;
        l |= b[1] & 0xFF;
        l <<= 8;
        return l |= b[0] & 0xFF;
    }

    private static final Color byteArray2Color(byte[] color) {
        int a = color[3] & 0xFF;
        int b = color[2] & 0xFF;
        int g = color[1] & 0xFF;
        int r = color[0] & 0xFF;
        return new Color(r, g, b, a);
    }
}

