/*
 * Decompiled with CFR 0.152.
 */
package es.knosys.tools;

import es.knosys.tools.ExceptionKnoDataBase;
import es.knosys.tools.ExceptionKnoQuery;
import es.knosys.tools.ExceptionKnoRemote;
import es.knosys.tools.ExceptionKnoThesaurus;
import es.knosys.tools.KnoRemote;
import java.io.IOException;
import java.util.Vector;

public class KnoThesaurus {
    private char handle = (char)65535;
    private KnoRemote remote = null;
    private static int lastError = 0;

    private KnoThesaurus() {
    }

    protected char getHandle() {
        return this.handle;
    }

    protected KnoRemote getRemote() {
        return this.remote;
    }

    protected static int getLastError() {
        return lastError;
    }

    protected static KnoThesaurus openThesaurus(KnoRemote rem) throws ExceptionKnoThesaurus {
        KnoThesaurus thesaurus = null;
        if (rem == null) {
            throw new ExceptionKnoThesaurus("Unspecified server openThesaurus.");
        }
        try {
            try {
                String sThesaurusName = "MAP.TES";
                int nCreate = 0;
                int nReadOnly = 1;
                thesaurus = new KnoThesaurus();
                if (thesaurus.abreTesauro(rem, sThesaurusName, nCreate, nReadOnly) != 0 || thesaurus.getHandle() == '\uffff') {
                    thesaurus = null;
                }
            }
            catch (Exception e) {
                thesaurus = null;
                lastError = 50;
                throw new ExceptionKnoThesaurus("Unavailable thesaurus openThesaurus: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        return thesaurus;
    }

    protected static KnoThesaurus openThesaurus(KnoRemote rem, String alias) throws ExceptionKnoThesaurus {
        KnoThesaurus thesaurus = null;
        if (rem == null) {
            throw new ExceptionKnoThesaurus("Unspecified server openThesaurus.");
        }
        try {
            try {
                String sThesaurusName = String.valueOf(alias) + ".TES";
                int nCreate = 0;
                int nReadOnly = 1;
                thesaurus = new KnoThesaurus();
                if (thesaurus.abreTesauro(rem, sThesaurusName, nCreate, nReadOnly) != 0 || thesaurus.getHandle() == '\uffff') {
                    thesaurus = null;
                }
            }
            catch (Exception e) {
                thesaurus = null;
                lastError = 50;
                throw new ExceptionKnoThesaurus("Unavailable thesaurus openThesaurus: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        return thesaurus;
    }

    private int abreTesauro(KnoRemote rem, String sThesaurusName, int nCreate, int nReadOnly) throws ExceptionKnoThesaurus {
        if (rem == null) {
            throw new ExceptionKnoThesaurus("Unspecified server abreThesaurus.");
        }
        if (sThesaurusName == null || sThesaurusName.compareTo("") == 0) {
            throw new ExceptionKnoThesaurus("Unspecified thesaurus name.");
        }
        this.remote = rem;
        try {
            try {
                int orden = 1200;
                int count = 0;
                this.remote.out.writeChar(orden);
                count = sThesaurusName.length();
                this.remote.out.writeInt(count);
                if (count > 0) {
                    this.remote.out.writeBytes(sThesaurusName);
                }
                this.remote.out.writeInt(nCreate);
                this.remote.out.writeInt(nReadOnly);
                this.remote.out.writeShort(10);
                this.remote.out.flush();
                lastError = this.remote.in.readChar();
                this.handle = lastError == 0 ? this.remote.in.readChar() : (char)65535;
            }
            catch (Exception e) {
                if (lastError == 0) {
                    lastError = 50;
                }
                throw new ExceptionKnoQuery("Unavailable thesaurus abreTesauro: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        return lastError;
    }

    protected Vector getTotalTerms() throws ExceptionKnoThesaurus {
        Vector<String> terms = null;
        Vector pos = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoThesaurus("Unavailable server (1) getTotalTerms.");
        }
        try {
            try {
                int orden = 1225;
                int count = 0;
                remote.out.writeChar(orden);
                remote.out.writeChar(this.getHandle());
                remote.out.flush();
                lastError = remote.in.readChar();
                if (lastError == 0) {
                    long numTerms = remote.in.readLong();
                    terms = new Vector<String>((int)numTerms);
                    pos = new Vector((int)numTerms);
                    int n = 0;
                    while ((long)n < numTerms) {
                        count = remote.in.readInt();
                        if (count > 0) {
                            long position = remote.in.readLong();
                            byte[] term = new byte[count];
                            remote.in.read(term);
                            terms.addElement(new String(term));
                        }
                        ++n;
                    }
                }
            }
            catch (IOException e) {
                if (terms != null) {
                    terms.removeAllElements();
                }
                terms = null;
                lastError = 2;
                throw new ExceptionKnoDataBase("Unavailable server (2) getTotalTerms: " + e.getMessage());
            }
            catch (Exception e) {
                if (terms != null) {
                    terms.removeAllElements();
                }
                terms = null;
                lastError = 8;
                throw new ExceptionKnoDataBase("Unavailable thesaurus: getTotalTerms: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        return terms;
    }

    protected Vector getTermsFilteredByWord(String sWord) throws ExceptionKnoThesaurus {
        Vector<String> terms = null;
        Vector pos = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoThesaurus("Unavailable server (1) getTermsFilteredByWord.");
        }
        try {
            try {
                int orden = 1226;
                int count = 0;
                remote.out.writeChar(orden);
                remote.out.writeChar(this.getHandle());
                count = sWord.length();
                remote.out.writeInt(count);
                if (count > 0) {
                    remote.out.writeBytes(sWord);
                }
                remote.out.flush();
                lastError = remote.in.readChar();
                if (lastError == 0) {
                    long numTerms = remote.in.readLong();
                    terms = new Vector<String>((int)numTerms);
                    pos = new Vector((int)numTerms);
                    int n = 0;
                    while ((long)n < numTerms) {
                        count = remote.in.readInt();
                        if (count > 0) {
                            long position = remote.in.readLong();
                            byte[] term = new byte[count];
                            remote.in.read(term);
                            terms.addElement(new String(term));
                        }
                        ++n;
                    }
                }
            }
            catch (IOException e) {
                if (terms != null) {
                    terms.removeAllElements();
                }
                terms = null;
                lastError = 2;
                throw new ExceptionKnoDataBase("Unavailable server (2) getTermsFilteredByWord: " + e.getMessage());
            }
            catch (Exception e) {
                if (terms != null) {
                    terms.removeAllElements();
                }
                terms = null;
                lastError = 8;
                throw new ExceptionKnoDataBase("Unavailable thesaurus: getTermsFilteredByWord: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        return terms;
    }

    protected byte[] getXMLAlphabeticalTerms(String word, char page, char terms, String alias) throws ExceptionKnoThesaurus {
        byte[] thesXML = null;
        try {
            try {
                KnoRemote remote = this.getRemote();
                if (remote == null) {
                    throw new ExceptionKnoThesaurus("Unavailable server (1) getXMLAlphabeticalTerms.");
                }
                int orden = 1227;
                remote.out.writeChar(orden);
                remote.out.writeChar(this.getHandle());
                int count = word.length();
                remote.out.writeInt(count);
                if (count > 0) {
                    remote.out.writeBytes(word);
                }
                remote.out.writeChar(page);
                remote.out.writeChar(terms);
                if (alias.compareTo("") != 0 && alias != null) {
                    count = alias.length();
                    remote.out.writeInt(count);
                    if (count > 0) {
                        remote.out.writeBytes(alias);
                    }
                } else {
                    remote.out.writeInt(0);
                }
                remote.out.flush();
                lastError = remote.in.readChar();
                if (lastError == 0) {
                    int nCount = remote.in.readInt();
                    int nXMLLength = remote.in.readInt();
                    thesXML = new byte[nXMLLength];
                    remote.in.readFully(thesXML, 0, nXMLLength);
                }
            }
            catch (IOException e) {
                lastError = 2;
                throw new ExceptionKnoRemote("Unavailable server (2) getXMLAlphabeticalTerms.");
            }
            catch (Exception Ex) {
                lastError = 50;
                throw new ExceptionKnoThesaurus("Unavailable thesaurus: getXMLAlphabeticalTerms.");
            }
        }
        catch (Throwable throwable) {}
        return thesXML;
    }

    protected byte[] getXMLHierarchicalTerms(String term, String alias) throws ExceptionKnoThesaurus {
        byte[] thesXML = null;
        try {
            try {
                KnoRemote remote = this.getRemote();
                if (remote == null) {
                    throw new ExceptionKnoThesaurus("Unavailable server (1) getXMLHierarchicalTerms.");
                }
                int orden = 1228;
                remote.out.writeChar(orden);
                remote.out.writeChar(this.getHandle());
                int count = term.length();
                remote.out.writeInt(count);
                if (count > 0) {
                    remote.out.writeBytes(term);
                }
                if (alias.compareTo("") != 0 && alias != null) {
                    count = alias.length();
                    remote.out.writeInt(count);
                    if (count > 0) {
                        remote.out.writeBytes(alias);
                    }
                } else {
                    remote.out.writeInt(0);
                }
                remote.out.flush();
                lastError = remote.in.readChar();
                if (lastError == 0) {
                    int nXMLLength = remote.in.readInt();
                    thesXML = new byte[nXMLLength];
                    remote.in.readFully(thesXML, 0, nXMLLength);
                }
            }
            catch (IOException e) {
                lastError = 2;
                throw new ExceptionKnoRemote("Unavailable server (2) getXMLHierarchicalTerms.");
            }
            catch (Exception Ex) {
                lastError = 50;
                throw new ExceptionKnoThesaurus("Unavailable thesaurus: getXMLHierarchicalTerms.");
            }
        }
        catch (Throwable throwable) {}
        return thesXML;
    }

    protected byte[] getXMLNarrowTerms(String term, String alias) throws ExceptionKnoThesaurus {
        byte[] thesXML = null;
        try {
            try {
                KnoRemote remote = this.getRemote();
                if (remote == null) {
                    throw new ExceptionKnoThesaurus("Unavailable server (1) getXMLNarrowTerms.");
                }
                int orden = 1229;
                remote.out.writeChar(orden);
                remote.out.writeChar(this.getHandle());
                int count = term.length();
                remote.out.writeInt(count);
                if (count > 0) {
                    remote.out.writeBytes(term);
                }
                if (alias.compareTo("") != 0 && alias != null) {
                    count = alias.length();
                    remote.out.writeInt(count);
                    if (count > 0) {
                        remote.out.writeBytes(alias);
                    }
                } else {
                    remote.out.writeInt(0);
                }
                remote.out.flush();
                lastError = remote.in.readChar();
                if (lastError == 0) {
                    int nXMLLength = remote.in.readInt();
                    thesXML = new byte[nXMLLength];
                    remote.in.readFully(thesXML, 0, nXMLLength);
                }
            }
            catch (IOException e) {
                lastError = 2;
                throw new ExceptionKnoRemote("Unavailable server (2) getXMLNarrowTerms.");
            }
            catch (Exception Ex) {
                lastError = 50;
                throw new ExceptionKnoThesaurus("Unavailable thesaurus: getXMLNarrowTerms.");
            }
        }
        catch (Throwable throwable) {}
        return thesXML;
    }

    protected byte[] getXMLFullHierarchicalTerms(String term, boolean full, String alias) throws ExceptionKnoThesaurus {
        byte[] thesXML = null;
        try {
            try {
                KnoRemote remote = this.getRemote();
                if (remote == null) {
                    throw new ExceptionKnoThesaurus("Unavailable server (1) getXMLHierarchicalTerms.");
                }
                int orden = 1230;
                remote.out.writeChar(orden);
                remote.out.writeChar(this.getHandle());
                int count = term.length();
                remote.out.writeInt(count);
                if (count > 0) {
                    remote.out.writeBytes(term);
                }
                remote.out.writeByte(full ? 1 : 0);
                if (alias.compareTo("") != 0 && alias != null) {
                    count = alias.length();
                    remote.out.writeInt(count);
                    if (count > 0) {
                        remote.out.writeBytes(alias);
                    }
                } else {
                    remote.out.writeInt(0);
                }
                remote.out.flush();
                lastError = remote.in.readChar();
                if (lastError == 0) {
                    int nXMLLength = remote.in.readInt();
                    thesXML = new byte[nXMLLength];
                    remote.in.readFully(thesXML, 0, nXMLLength);
                }
            }
            catch (IOException e) {
                lastError = 2;
                throw new ExceptionKnoRemote("Unavailable server (2) getXMLHierarchicalTerms.");
            }
            catch (Exception Ex) {
                lastError = 50;
                throw new ExceptionKnoThesaurus("Unavailable thesaurus: getXMLHierarchicalTerms.");
            }
        }
        catch (Throwable throwable) {}
        return thesXML;
    }

    protected byte[] getXMLDevelopmentTerms(String term, String alias) throws ExceptionKnoThesaurus {
        byte[] thesXML = null;
        try {
            try {
                KnoRemote remote = this.getRemote();
                if (remote == null) {
                    throw new ExceptionKnoThesaurus("Unavailable server (1) getXMLNarrowTerms.");
                }
                int orden = 1231;
                remote.out.writeChar(orden);
                remote.out.writeChar(this.getHandle());
                int count = term.length();
                remote.out.writeInt(count);
                if (count > 0) {
                    remote.out.writeBytes(term);
                }
                if (alias.compareTo("") != 0 && alias != null) {
                    count = alias.length();
                    remote.out.writeInt(count);
                    if (count > 0) {
                        remote.out.writeBytes(alias);
                    }
                } else {
                    remote.out.writeInt(0);
                }
                remote.out.flush();
                lastError = remote.in.readChar();
                if (lastError == 0) {
                    int nXMLLength = remote.in.readInt();
                    thesXML = new byte[nXMLLength];
                    remote.in.readFully(thesXML, 0, nXMLLength);
                }
            }
            catch (IOException e) {
                lastError = 2;
                throw new ExceptionKnoRemote("Unavailable server (2) getXMLDevelopmentTerms.");
            }
            catch (Exception Ex) {
                lastError = 50;
                throw new ExceptionKnoThesaurus("Unavailable thesaurus: getXMLDevelopmentTerms.");
            }
        }
        catch (Throwable throwable) {}
        return thesXML;
    }

    protected byte[] getXMLFullTopTerms(String alias) throws ExceptionKnoThesaurus {
        byte[] thesXML = null;
        try {
            try {
                KnoRemote remote = this.getRemote();
                if (remote == null) {
                    throw new ExceptionKnoThesaurus("Unavailable server (1) getXMLFullTopTerms.");
                }
                int orden = 1232;
                remote.out.writeChar(orden);
                remote.out.writeChar(this.getHandle());
                if (alias.compareTo("") != 0 && alias != null) {
                    int count = alias.length();
                    remote.out.writeInt(count);
                    if (count > 0) {
                        remote.out.writeBytes(alias);
                    }
                } else {
                    remote.out.writeInt(0);
                }
                remote.out.flush();
                lastError = remote.in.readChar();
                if (lastError == 0) {
                    int nXMLLength = remote.in.readInt();
                    thesXML = new byte[nXMLLength];
                    remote.in.readFully(thesXML, 0, nXMLLength);
                    if (thesXML.length < nXMLLength) {
                        thesXML = null;
                        lastError = 50;
                    }
                }
            }
            catch (IOException e) {
                lastError = 2;
                throw new ExceptionKnoRemote("Unavailable server (2) getXMLFullTopTerms.");
            }
            catch (Exception Ex) {
                lastError = 50;
                throw new ExceptionKnoThesaurus("Unavailable thesaurus: getXMLFullTopTerms.");
            }
        }
        catch (Throwable throwable) {}
        return thesXML;
    }

    protected void closeThesaurus() throws ExceptionKnoThesaurus {
        if (this.remote == null) {
            throw new ExceptionKnoThesaurus("Unavailable server (1) closeThesaurus.");
        }
        if (this.handle == '\uffffffff') {
            throw new ExceptionKnoThesaurus("Unavailable thesaurus (1) closeThesaurus.");
        }
        try {
            int orden = 1201;
            this.remote.out.writeChar(orden);
            this.remote.out.writeChar(this.handle);
            this.remote.out.flush();
            lastError = this.remote.in.readChar();
        }
        catch (IOException e) {
            lastError = 2;
            throw new ExceptionKnoThesaurus("Unavailable server (2) closeThesaurus: " + e.getMessage());
        }
        catch (Exception e) {
            lastError = 50;
            throw new ExceptionKnoThesaurus("Unavailable database (2) closeThesaurus: " + e.getMessage());
        }
    }
}

