/*
 * Decompiled with CFR 0.152.
 */
package es.knosys.tools;

import es.knosys.tools.ExceptionKnoRemote;
import es.knosys.tools.KnoInputStream;
import es.knosys.tools.KnoOutputStream;
import es.knosys.tools.KnoSessionInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.net.Socket;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class KnoRemote {
    protected KnoOutputStream out = null;
    protected KnoInputStream in = null;
    private static final Lock _mutex = new ReentrantLock(true);
    public static final int TIMERCONECTION = 20000;
    private Socket socket = null;
    private String userName = "SYSADM";
    private String password = "";
    private Integer daysLeft = 0;
    private static final String NETVERSION = "KNOCLI INT 2000 1.0";
    private static final String NETOBJVERSION = "KNOCLI OBJ 2000 1.0";
    private static final String CLOUDVERSION = "KNOCLI CLOUD 2000 1.0";
    private static final String SRVVERSION = "ENT";
    private static final String SRVVERSION_2 = "SMB";
    private static final String SRVVERSION_3 = "SMBONE";
    private static final String SRVVERSION_4 = "ONE";
    private static final String NOLICENCE = "KNOSRV 2000 1.0: NO LICENSES";
    private static final String NOUSER = "KNOSRV 2000 1.0: NO USER EXIST";
    private static final String NOENABLED = "KNOSRV 2000 1.0: NO USER ENABLED";
    private static final String USERINUSE = "KNOSRV 2000 1.0: USER IN USE";
    private static final String NOPASSWORD = "KNOSRV 2000 1.0: MAL PASSWORD";
    private static final String EXPIREDPASSWORD = "KNOSRV 2000 1.0: PASSWORD CADUCADA";
    private static final String INIPASSWORD = "KNOSRV 2000 1.0: PASSWORD REINICIA";
    private static final String FEWDAYSLICENSE = "KNOSRV BLUE 1.0: A FEW DAYS REMAIN LICENSE";
    private static final String MAIN_TASK = "MAIN_TASK";
    private static int lastError = 0;
    private static String cuid = null;

    private KnoRemote() {
    }

    protected void closeConexion() throws ExceptionKnoRemote {
        try {
            int orden = 1;
            if (this.out != null) {
                this.out.writeChar(orden);
            }
        }
        catch (Exception e) {
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server close remote write:" + e.getMessage());
        }
        try {
            if (this.out != null) {
                this.out.flush();
            }
        }
        catch (Exception e) {
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server close remote flush:" + e.getMessage());
        }
        try {
            if (this.in != null) {
                lastError = this.in.readChar();
            }
        }
        catch (Exception e) {
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server close remote read:" + e.getMessage());
        }
        try {
            try {
                if (this.out != null) {
                    this.out.flush();
                    this.out.close();
                }
                if (this.in != null) {
                    this.in.close();
                }
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (Exception e) {
                lastError = 2;
                throw new ExceptionKnoRemote("Unavailable server close remote socket:" + e.getMessage());
            }
        }
        finally {
            this.out = null;
            this.in = null;
            this.socket = null;
        }
    }

    protected int initSession() throws ExceptionKnoRemote {
        return this.initSession(0);
    }

    protected int initSession(int type) throws ExceptionKnoRemote {
        try {
            int orden = 4;
            this.out.writeChar(orden);
            this.out.flush();
            lastError = this.in.readChar();
            if (lastError != 0) {
                switch (lastError) {
                    case 32771: {
                        lastError = 3;
                        break;
                    }
                    case 32772: {
                        lastError = 4;
                        break;
                    }
                    case 32773: {
                        lastError = 5;
                        break;
                    }
                    case 32774: {
                        lastError = 6;
                        break;
                    }
                    case 32983: {
                        lastError = 25;
                        break;
                    }
                    case 33059: {
                        lastError = 3;
                        break;
                    }
                    default: {
                        lastError = 2;
                        break;
                    }
                }
            } else if (type == 2) {
                int count = this.in.readInt();
                byte[] buid = new byte[count];
                this.in.read(buid);
                cuid = new String(buid);
            }
        }
        catch (Exception e) {
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server close remote socket: " + e.getMessage());
        }
        if (lastError != 0) {
            this.out = null;
            this.in = null;
            this.socket = null;
        }
        return lastError;
    }

    protected int initSession(int type, String hostClient) throws ExceptionKnoRemote {
        try {
            int orden = 10;
            this.out.writeChar(orden);
            this.sendString(hostClient);
            this.out.flush();
            lastError = this.in.readChar();
            if (lastError != 0) {
                switch (lastError) {
                    case 32771: {
                        lastError = 3;
                        break;
                    }
                    case 32772: {
                        lastError = 4;
                        break;
                    }
                    case 32773: {
                        lastError = 5;
                        break;
                    }
                    case 32774: {
                        lastError = 6;
                        break;
                    }
                    case 32983: {
                        lastError = 25;
                        break;
                    }
                    case 33059: {
                        lastError = 3;
                        break;
                    }
                    default: {
                        lastError = 2;
                        break;
                    }
                }
            } else if (type == 2) {
                int count = this.in.readInt();
                byte[] buid = new byte[count];
                this.in.read(buid);
                cuid = new String(buid);
            }
        }
        catch (Exception e) {
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server close remote socket: " + e.getMessage());
        }
        if (lastError != 0) {
            this.out = null;
            this.in = null;
            this.socket = null;
        }
        return lastError;
    }

    protected int endSession() throws ExceptionKnoRemote {
        try {
            int orden = 5;
            this.out.writeChar(orden);
            this.out.flush();
            lastError = this.in.readChar();
        }
        catch (Exception e) {
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server close remote socket: " + e.getMessage());
        }
        if (lastError != 0) {
            this.out = null;
            this.in = null;
            this.socket = null;
        }
        return lastError;
    }

    protected int endSession(String hostClient) throws ExceptionKnoRemote {
        try {
            int orden = 11;
            this.out.writeChar(orden);
            this.sendString(hostClient);
            this.out.flush();
            lastError = this.in.readChar();
        }
        catch (Exception e) {
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server close remote socket: " + e.getMessage());
        }
        if (lastError != 0) {
            this.out = null;
            this.in = null;
            this.socket = null;
        }
        return lastError;
    }

    protected KnoSessionInfo checkServerVersion(KnoSessionInfo knoSessionInfo) throws ExceptionKnoRemote {
        try {
            int orden = 7;
            this.out.writeChar(orden);
            this.out.flush();
            lastError = this.in.readChar();
            if (lastError != 0) {
                lastError = 3;
            } else {
                knoSessionInfo.setVersion(this.in.readInt());
                knoSessionInfo.setLicense(this.in.readInt());
                knoSessionInfo.setWeb(this.in.readInt());
                int timestamp = this.in.readInt();
                if (timestamp > 0) {
                    knoSessionInfo.setDate(new Date((long)timestamp * 1000L));
                }
            }
        }
        catch (Exception e) {
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server close remote socket: " + e.getMessage());
        }
        if (lastError != 0) {
            this.out = null;
            this.in = null;
            this.socket = null;
        }
        return knoSessionInfo;
    }

    private int conecta(String dirIP, int puerto, String user, String pass, String netver, String uid, int iTimer) throws ExceptionKnoRemote {
        block32: {
            if (dirIP == null || dirIP.compareTo("") == 0) {
                throw new ExceptionKnoRemote("Empty IP Address.");
            }
            if (puerto == 0) {
                throw new ExceptionKnoRemote("Bad number port.");
            }
            if (user == null || user.compareTo("") == 0) {
                throw new ExceptionKnoRemote("Empty user name.");
            }
            try {
                if (iTimer == 0) {
                    iTimer = 20000;
                }
                if (iTimer == 0 || _mutex.tryLock(iTimer, TimeUnit.MILLISECONDS)) {
                    this.socket = new Socket(dirIP, puerto);
                    BufferedOutputStream buffOut = new BufferedOutputStream(this.socket.getOutputStream(), 4096);
                    this.out = new KnoOutputStream(buffOut);
                    BufferedInputStream buffIn = new BufferedInputStream(this.socket.getInputStream(), 4096);
                    this.in = new KnoInputStream(buffIn);
                    if (iTimer > 0) {
                        _mutex.unlock();
                    }
                } else {
                    System.out.println("Error MUTEX TIMEOUT. iTimer: " + iTimer);
                    return -1;
                }
                try {
                    this.sendString(netver);
                    this.sendString(user);
                    this.sendString(MAIN_TASK);
                    this.sendString(pass);
                    if (netver.compareTo(CLOUDVERSION) == 0) {
                        this.sendString(uid);
                    }
                    this.out.flush();
                    int count = this.in.readInt();
                    byte[] srvVersion = new byte[count];
                    this.in.read(srvVersion);
                    String srvVer = new String(srvVersion);
                    if (srvVer.startsWith(SRVVERSION) || srvVer.startsWith(SRVVERSION_2) || srvVer.startsWith(SRVVERSION_3) || srvVer.startsWith(SRVVERSION_4)) {
                        this.userName = user;
                        this.password = pass;
                        lastError = 0;
                        break block32;
                    }
                    if (srvVer.compareTo(FEWDAYSLICENSE) == 0) {
                        this.daysLeft = this.in.readInt();
                        if (this.daysLeft >= 0) {
                            this.userName = user;
                            this.password = pass;
                            lastError = 0;
                        } else {
                            this.out.close();
                            this.in.close();
                            this.socket.close();
                            if (this.daysLeft == -1) {
                                lastError = 61;
                                throw new ExceptionKnoRemote("Expired license.");
                            }
                            if (this.daysLeft == -2) {
                                lastError = 62;
                                throw new ExceptionKnoRemote("License not valid.");
                            }
                        }
                        break block32;
                    }
                    if (srvVer.compareTo(NOLICENCE) == 0) {
                        lastError = 3;
                        this.out.close();
                        this.in.close();
                        this.socket.close();
                        long millis = System.currentTimeMillis();
                        Date date = new Date(millis);
                        System.out.println(date + ". Error de conexi\u00f3n. Not enough licences.");
                        throw new ExceptionKnoRemote("Not enough licences.");
                    }
                    if (srvVer.compareTo(NOUSER) == 0) {
                        lastError = 4;
                        this.out.close();
                        this.in.close();
                        this.socket.close();
                        long millis = System.currentTimeMillis();
                        Date date = new Date(millis);
                        System.out.println(date + ". Error de conexi\u00f3n. Not valid user identification.");
                        throw new ExceptionKnoRemote("Not valid user identification.");
                    }
                    if (srvVer.compareTo(NOENABLED) == 0) {
                        lastError = 24;
                        this.out.close();
                        this.in.close();
                        this.socket.close();
                        long millis = System.currentTimeMillis();
                        Date date = new Date(millis);
                        System.out.println(date + ". Error de conexi\u00f3n. User not enabled.");
                        throw new ExceptionKnoRemote("User not enabled.");
                    }
                    if (srvVer.compareTo(USERINUSE) == 0) {
                        lastError = 25;
                        this.out.close();
                        this.in.close();
                        this.socket.close();
                        long millis = System.currentTimeMillis();
                        Date date = new Date(millis);
                        System.out.println(date + ". Error de conexi\u00f3n. User in use.");
                        throw new ExceptionKnoRemote("Not valid user identification.");
                    }
                    if (srvVer.compareTo(NOPASSWORD) == 0) {
                        lastError = 5;
                        this.out.close();
                        this.in.close();
                        this.socket.close();
                        long millis = System.currentTimeMillis();
                        Date date = new Date(millis);
                        System.out.println(date + ". Error de conexi\u00f3n. Invalid password.");
                        throw new ExceptionKnoRemote("Not valid user identification.");
                    }
                    if (srvVer.compareTo(EXPIREDPASSWORD) == 0) {
                        lastError = 6;
                        this.out.close();
                        this.in.close();
                        this.socket.close();
                        long millis = System.currentTimeMillis();
                        Date date = new Date(millis);
                        System.out.println(date + ". Error de conexi\u00f3n. Invalid password.");
                        throw new ExceptionKnoRemote("Expired password.");
                    }
                    if (srvVer.compareTo(INIPASSWORD) == 0) {
                        lastError = 1;
                        this.out.close();
                        this.in.close();
                        this.socket.close();
                        long millis = System.currentTimeMillis();
                        Date date = new Date(millis);
                        System.out.println(date + ". Error de conexi\u00f3n. Unidentified error.");
                        throw new ExceptionKnoRemote("Unidentified error.");
                    }
                    lastError = 2;
                    this.out.close();
                    this.in.close();
                    this.socket.close();
                    long millis = System.currentTimeMillis();
                    Date date = new Date(millis);
                    System.out.println(date + ". Error de conexi\u00f3n. Unavailable server conecta: " + srvVer);
                    throw new ExceptionKnoRemote("Unavailable server conecta.");
                }
                catch (InterruptedException e) {
                    if (lastError == 0) {
                        lastError = -1;
                    }
                    System.out.println("Error de conexi\u00f3n. Interruptedexception: " + e.getMessage());
                    this.out = null;
                    this.in = null;
                    this.socket = null;
                    return -1;
                }
                catch (Exception e) {
                    if (lastError == 0) {
                        lastError = -1;
                    }
                    System.out.println("Error de conexi\u00f3n. Server exception: " + e.getMessage());
                    this.out = null;
                    this.in = null;
                    this.socket = null;
                }
            }
            finally {
                if (lastError != 0) {
                    this.out = null;
                    this.in = null;
                    this.socket = null;
                }
            }
        }
        return lastError;
    }

    public void sendString(String text) {
        try {
            int count = text.length();
            this.out.writeInt(count);
            if (count > 0) {
                this.out.writeBytes(text);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void desconecta() throws ExceptionKnoRemote {
        try {
            try {
                this.socket.shutdownInput();
                this.socket.shutdownOutput();
                this.out.close();
                this.in.close();
                this.socket.close();
            }
            catch (Exception e) {
                lastError = 2;
                throw new ExceptionKnoRemote("Unavailable server close remote socket:" + e.getMessage());
            }
        }
        finally {
            this.out = null;
            this.in = null;
            this.socket = null;
        }
    }

    protected static int getLastError() {
        return lastError;
    }

    protected static String getCUID() {
        return cuid;
    }

    protected String getPassword() {
        return this.password;
    }

    protected String getUserName() {
        return this.userName;
    }

    protected Integer getDaysLeft() {
        return this.daysLeft;
    }

    protected static KnoRemote openConexion(String dirIP, int puerto, String user, String pass) throws ExceptionKnoRemote {
        return KnoRemote.openConexion(dirIP, puerto, user, pass, 0);
    }

    protected static KnoRemote openConexion(String dirIP, int puerto, String user, String pass, int TypeConection) throws ExceptionKnoRemote {
        return KnoRemote.openConexion(dirIP, puerto, user, pass, null, TypeConection, 0);
    }

    protected static KnoRemote openConexion(String dirIP, int puerto, String user, String pass, String uid) throws ExceptionKnoRemote {
        if (uid == null) {
            return KnoRemote.openConexion(dirIP, puerto, user, pass, 0);
        }
        return KnoRemote.openConexion(dirIP, puerto, user, pass, uid, 2, 0);
    }

    protected static KnoRemote openConexion(String dirIP, int puerto, String user, String pass, String uid, int iTimer) throws ExceptionKnoRemote {
        if (uid == null) {
            return KnoRemote.openConexion(dirIP, puerto, user, pass, uid, 0, iTimer);
        }
        return KnoRemote.openConexion(dirIP, puerto, user, pass, uid, 2, iTimer);
    }

    protected static KnoRemote openConexion(String dirIP, int puerto, String user, String pass, String uid, int TypeConection, int iTimer) throws ExceptionKnoRemote {
        KnoRemote conexion = new KnoRemote();
        int error = 2;
        long fin = System.currentTimeMillis() + 15000L;
        try {
            do {
                if (TypeConection == 1) {
                    error = conexion.conecta(dirIP, puerto, user, pass, NETOBJVERSION, uid, iTimer);
                } else if (TypeConection == 0) {
                    error = conexion.conecta(dirIP, puerto, user, pass, NETVERSION, uid, iTimer);
                } else if (TypeConection == 2) {
                    error = conexion.conecta(dirIP, puerto, user, pass, CLOUDVERSION, uid, iTimer);
                }
                if (error == 0) continue;
                System.out.println("Error de conexi\u00f3n. TIMEOUT. error: " + error);
                break;
            } while (error == 3 || error == 25 || error == -1);
            if (error != 0) {
                if (conexion != null) {
                    conexion.closeConexion();
                }
                conexion = null;
                long millis = System.currentTimeMillis();
                Date date = new Date(millis);
                System.out.println(date + "Error de conexi\u00f3n. C\u00f3digo:" + error);
            }
        }
        catch (Exception e) {
            System.out.println("Error de conexi\u00f3n. Exception:" + error);
            throw new ExceptionKnoRemote("Error de conexi\u00f3n. Exception :" + error);
        }
        return conexion;
    }

    public class KnoTypeRemote {
        public static final int NETCONECTION = 0;
        public static final int NETCONECTIONOBJ = 1;
        public static final int CLOUDCONNECTION = 2;
    }
}

