/*
 * Decompiled with CFR 0.152.
 */
package es.knosys.tools;

import es.knosys.tools.ExceptionKnoQuery;
import es.knosys.tools.KnoFormat;
import es.knosys.tools.KnoRemote;
import java.io.IOException;
import java.util.Vector;
import java.util.concurrent.Semaphore;

public class KnoQuery {
    private static final int PENDING_QRYCALC = 0;
    private static final int CALCULED_QRYCALC = 1;
    private static final int PENDING_QRYOBJCALC = 2;
    private KnoFormat format = null;
    private String consulta = "";
    private int numDocs = 0;
    private char handle = (char)65535;
    private static int lastError = 0;
    static Semaphore allowedPermits = new Semaphore(3);

    private KnoQuery() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int executeQuery() throws ExceptionKnoQuery {
        KnoRemote remote = this.format.getRemote();
        if (remote == null) {
            throw new ExceptionKnoQuery("Unavailable server (1) executeQuery.");
        }
        try {
            try {
                int orden = 456;
                allowedPermits.acquire();
                remote.out.writeChar(orden);
                remote.out.writeChar(this.getHandle());
                remote.out.writeByte(1);
                remote.out.flush();
                this.numDocs = 0;
                lastError = remote.in.readChar();
                if (lastError != 0) return lastError;
                int qryStat = remote.in.readInt();
                if (qryStat == 1) {
                    this.numDocs = remote.in.readInt();
                    return lastError;
                }
                while (true) {
                    if (lastError != 0 || qryStat != 0) {
                        if (qryStat != 1) break;
                        this.numDocs = this.getDocs();
                        return lastError;
                    }
                    Thread.sleep(1500L);
                    qryStat = this.getQueryStat();
                }
                lastError = 13;
                return lastError;
            }
            catch (IOException e) {
                lastError = 2;
                throw new ExceptionKnoQuery("Unavailable server (2) EXECUTEQUERY: " + e.getMessage());
            }
            catch (Exception e) {
                lastError = 13;
                throw new ExceptionKnoQuery("Unavailable query (2) EXECUTEQUERY: " + e.getMessage());
            }
        }
        finally {
            allowedPermits.release();
        }
    }

    protected int getDocs() throws ExceptionKnoQuery {
        KnoRemote remote = this.format.getRemote();
        if (remote == null) {
            throw new ExceptionKnoQuery("Unavailable server (1) executeQuery.");
        }
        try {
            try {
                int orden = 475;
                remote.out.writeChar(orden);
                remote.out.writeChar(this.getHandle());
                remote.out.flush();
                this.numDocs = 0;
                lastError = remote.in.readChar();
                if (lastError == 0) {
                    this.numDocs = remote.in.readInt();
                }
            }
            catch (IOException e) {
                lastError = 2;
                throw new ExceptionKnoQuery("Unavailable server  getSize: " + e.getMessage());
            }
            catch (Exception e) {
                lastError = 13;
                throw new ExceptionKnoQuery("Unavailable query  getSize: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        return this.numDocs;
    }

    protected int getQueryStat() throws ExceptionKnoQuery {
        KnoRemote remote = this.format.getRemote();
        int qryStat = 0;
        if (remote == null) {
            throw new ExceptionKnoQuery("Unavailable server (1) executeQuery.");
        }
        try {
            try {
                int orden = 461;
                remote.out.writeChar(orden);
                remote.out.writeChar(this.getHandle());
                remote.out.flush();
                lastError = remote.in.readChar();
                if (lastError == 0) {
                    qryStat = remote.in.readInt();
                }
            }
            catch (IOException e) {
                lastError = 2;
                throw new ExceptionKnoQuery("Unavailable server getQueryStat: " + e.getMessage());
            }
            catch (Exception e) {
                lastError = 13;
                throw new ExceptionKnoQuery("Unavailable query getQueryStat: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        return qryStat;
    }

    protected int getObjQueryStat() throws ExceptionKnoQuery {
        KnoRemote remote = this.format.getRemote();
        int qryStat = 0;
        if (remote == null) {
            throw new ExceptionKnoQuery("Unavailable server (1) executeQuery.");
        }
        try {
            try {
                int orden = 496;
                remote.out.writeChar(orden);
                remote.out.writeChar(this.getHandle());
                remote.out.flush();
                lastError = remote.in.readChar();
                if (lastError == 0) {
                    qryStat = remote.in.readInt();
                }
            }
            catch (IOException e) {
                lastError = 2;
                throw new ExceptionKnoQuery("Unavailable server  getSize: " + e.getMessage());
            }
            catch (Exception e) {
                lastError = 13;
                throw new ExceptionKnoQuery("Unavailable query  getSize: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        return qryStat;
    }

    protected void freeQuery() throws ExceptionKnoQuery {
        KnoRemote remote = this.format.getRemote();
        if (remote == null) {
            throw new ExceptionKnoQuery("Unavailable server (1) freeQuery.");
        }
        if (this.handle == '\uffff') {
            throw new ExceptionKnoQuery("Unavailable query (1) freeQuery.");
        }
        try {
            int orden = 460;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.handle);
            remote.out.flush();
            lastError = remote.in.readChar();
        }
        catch (IOException e) {
            lastError = 2;
            throw new ExceptionKnoQuery("Unavailable server (2) freeQuery: " + e.getMessage());
        }
        catch (Exception e) {
            lastError = 13;
            throw new ExceptionKnoQuery("Unavailable query (2) freeQuery: " + e.getMessage());
        }
    }

    protected char getHandle() {
        return this.handle;
    }

    protected KnoFormat getFormat() {
        return this.format;
    }

    protected static int getLastError() {
        return lastError;
    }

    protected int getNumDocs() {
        return this.numDocs;
    }

    protected Vector getNumDocsQueryList() throws ExceptionKnoQuery {
        Vector<Integer> docsList = null;
        KnoRemote remote = this.format.getRemote();
        if (remote == null) {
            throw new ExceptionKnoQuery("Unavailable server (1) getListDocsQuery.");
        }
        try {
            try {
                int numDocs;
                int orden = 472;
                boolean count = false;
                remote.out.writeChar(orden);
                remote.out.writeChar(this.getHandle());
                remote.out.flush();
                lastError = remote.in.readChar();
                if (lastError == 0 && (numDocs = remote.in.readInt()) > 0) {
                    docsList = new Vector<Integer>(numDocs);
                    int n = 0;
                    while (n < numDocs) {
                        int doc = remote.in.readInt();
                        docsList.addElement(new Integer(doc));
                        ++n;
                    }
                }
            }
            catch (IOException e) {
                docsList = null;
                if (lastError == 0) {
                    lastError = 2;
                }
                throw new ExceptionKnoQuery("Unavailable server (2) getListDocsQuery: " + e.getMessage());
            }
            catch (Exception e) {
                docsList = null;
                if (lastError == 0) {
                    lastError = 13;
                }
                throw new ExceptionKnoQuery("Unavailable query (2) getListDocsQuery: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        return docsList;
    }

    private int iniciaConsulta(KnoFormat fmt, String cons) throws ExceptionKnoQuery {
        return this.iniciaConsulta(fmt, cons, 2);
    }

    private int iniciaConsulta(KnoFormat fmt, String cons, int domain) throws ExceptionKnoQuery {
        if (fmt == null) {
            throw new ExceptionKnoQuery("Unspecified format iniciaConsulta.");
        }
        if (cons == null || cons.compareTo("") == 0) {
            throw new ExceptionKnoQuery("Unspecified query iniciaConsulta.");
        }
        this.format = fmt;
        this.consulta = cons;
        KnoRemote remote = this.format.getRemote();
        if (remote == null) {
            throw new ExceptionKnoQuery("Unavailable server (1) iniciaConsulta.");
        }
        try {
            try {
                int orden = 450;
                int count = 0;
                remote.out.writeChar(orden);
                remote.out.writeChar(this.format.getHandle());
                count = this.consulta.length();
                remote.out.writeInt(count);
                if (count > 0) {
                    remote.out.writeBytes(this.consulta);
                }
                remote.out.writeInt(domain);
                remote.out.flush();
                lastError = remote.in.readChar();
                this.handle = lastError == 0 ? remote.in.readChar() : (char)65535;
            }
            catch (IOException e) {
                if (lastError == 0) {
                    lastError = 2;
                }
                throw new ExceptionKnoQuery("Unavailable server (2) iniciaConsulta: " + e.getMessage());
            }
            catch (Exception e) {
                if (lastError == 0) {
                    lastError = 13;
                }
                throw new ExceptionKnoQuery("Unavailable query iniciaConsulta: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        return lastError;
    }

    private int iniciaConsulta(KnoFormat fmt, String cons, int domain, int status) throws ExceptionKnoQuery {
        if (fmt == null) {
            throw new ExceptionKnoQuery("Unspecified format iniciaConsulta (3).");
        }
        if (cons == null || cons.compareTo("") == 0) {
            throw new ExceptionKnoQuery("Unspecified query iniciaConsulta (3).");
        }
        this.format = fmt;
        this.consulta = cons;
        KnoRemote remote = this.format.getRemote();
        if (remote == null) {
            throw new ExceptionKnoQuery("Unavailable server iniciaConsulta (3).");
        }
        try {
            try {
                int orden = 487;
                int count = 0;
                remote.out.writeChar(orden);
                remote.out.writeChar(this.format.getHandle());
                count = this.consulta.length();
                remote.out.writeInt(count);
                if (count > 0) {
                    remote.out.writeBytes(this.consulta);
                }
                remote.out.writeInt(domain);
                remote.out.writeInt(status);
                remote.out.flush();
                lastError = remote.in.readChar();
                this.handle = lastError == 0 ? remote.in.readChar() : (char)65535;
            }
            catch (IOException e) {
                if (lastError == 0) {
                    lastError = 2;
                }
                throw new ExceptionKnoQuery("Unavailable server iniciaConsulta (3): " + e.getMessage());
            }
            catch (Exception e) {
                if (lastError == 0) {
                    lastError = 13;
                }
                throw new ExceptionKnoQuery("Unavailable query iniciaConsulta (3): " + e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        return lastError;
    }

    private int iniciaConsulta(KnoQuery qryOrg, Vector cmpOrd, String dbname, String user, String pass) throws ExceptionKnoQuery {
        if (qryOrg == null) {
            throw new ExceptionKnoQuery("Unspecified original query iniciaConsulta.");
        }
        if (cmpOrd == null) {
            throw new ExceptionKnoQuery("Unspecified cmpOrd iniciaConsulta.");
        }
        this.format = qryOrg.getFormat();
        if (this.format == null) {
            throw new ExceptionKnoQuery("Unavailable format (1) iniciaConsulta.");
        }
        KnoRemote remote = this.format.getRemote();
        if (remote == null) {
            throw new ExceptionKnoQuery("Unavailable server (1) iniciaConsulta.");
        }
        try {
            try {
                int orden = 479;
                int count = 0;
                remote.out.writeChar(orden);
                remote.out.writeChar(qryOrg.getHandle());
                remote.out.writeInt(2);
                count = dbname.length();
                remote.out.writeInt(count);
                if (count > 0) {
                    remote.out.writeBytes(dbname);
                }
                count = user.length();
                remote.out.writeInt(count);
                if (count > 0) {
                    remote.out.writeBytes(user);
                }
                count = pass.length();
                remote.out.writeInt(count);
                if (count > 0) {
                    remote.out.writeBytes(pass);
                }
                int size = cmpOrd.size();
                remote.out.writeInt(size);
                int i = 0;
                while (i < size) {
                    String field = (String)cmpOrd.elementAt(i);
                    int direction = 0;
                    count = field.length();
                    if (count > 0) {
                        int nPos = field.indexOf("|");
                        if (nPos != -1) {
                            direction = new Integer(field.substring(nPos + 1));
                            field = field.substring(0, nPos);
                        }
                        count = field.length();
                        remote.out.writeInt(count);
                        if (count > 0) {
                            remote.out.writeBytes(field);
                        }
                    } else {
                        remote.out.writeInt(count);
                    }
                    remote.out.writeByte(direction);
                    ++i;
                }
                remote.out.flush();
                lastError = remote.in.readChar();
                this.handle = lastError == 0 ? remote.in.readChar() : (char)65535;
            }
            catch (IOException e) {
                if (lastError == 0) {
                    lastError = 2;
                }
                throw new ExceptionKnoQuery("Unavailable server (2) iniciaConsulta: " + e.getMessage());
            }
            catch (Exception e) {
                if (lastError == 0) {
                    lastError = 13;
                }
                throw new ExceptionKnoQuery("Unavailable query iniciaConsulta: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        return lastError;
    }

    protected static KnoQuery prepareQuery(KnoFormat fmt, String cons) throws ExceptionKnoQuery {
        return KnoQuery.prepareQuery(fmt, cons, 2);
    }

    protected static KnoQuery prepareQuery(KnoFormat fmt, String cons, int domain) throws ExceptionKnoQuery {
        KnoQuery query = null;
        if (fmt == null) {
            throw new ExceptionKnoQuery("Unspecified format prepareQuery.");
        }
        if (cons == null || cons.compareTo("") == 0) {
            throw new ExceptionKnoQuery("Unspecified query prepareQuery.");
        }
        try {
            try {
                query = new KnoQuery();
                if (query.iniciaConsulta(fmt, cons, domain) != 0 || query.getHandle() == '\uffff') {
                    query = null;
                }
            }
            catch (Exception e) {
                query = null;
                lastError = 13;
                throw new ExceptionKnoQuery("Unavailable query prepareQuery: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        return query;
    }

    protected static KnoQuery prepareQuery(KnoFormat fmt, String cons, int domain, int status) throws ExceptionKnoQuery {
        KnoQuery query = null;
        if (fmt == null) {
            throw new ExceptionKnoQuery("Unspecified format prepareQuery (3).");
        }
        if (cons == null || cons.compareTo("") == 0) {
            throw new ExceptionKnoQuery("Unspecified query prepareQuery (3).");
        }
        try {
            try {
                query = new KnoQuery();
                if (query.iniciaConsulta(fmt, cons, domain, status) != 0 || query.getHandle() == '\uffff') {
                    query = null;
                }
            }
            catch (Exception e) {
                query = null;
                lastError = 13;
                throw new ExceptionKnoQuery("Unavailable query prepareQuery (3): " + e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        return query;
    }

    protected static KnoQuery prepareQuery(KnoQuery qryOrg, Vector cmpOrd, String dbname, String user, String pass) throws ExceptionKnoQuery {
        KnoQuery query = null;
        if (qryOrg == null) {
            throw new ExceptionKnoQuery("Unspecified original query prepareQuery.");
        }
        if (cmpOrd == null) {
            throw new ExceptionKnoQuery("Unspecified cmpOrd prepareQuery.");
        }
        try {
            try {
                query = new KnoQuery();
                if (query.iniciaConsulta(qryOrg, cmpOrd, dbname, user, pass) != 0 || query.getHandle() == '\uffff') {
                    query = null;
                }
            }
            catch (Exception e) {
                query = null;
                lastError = 13;
                throw new ExceptionKnoQuery("Unavailable query prepareQuery: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        return query;
    }

    protected Vector<String> getNameObjs() throws ExceptionKnoQuery {
        Vector<String> objNameList = null;
        KnoRemote remote = this.format.getRemote();
        if (remote == null) {
            throw new ExceptionKnoQuery("Unavailable server (1) getNameObjs.");
        }
        try {
            try {
                int numObjs;
                int orden = 492;
                remote.out.writeChar(orden);
                remote.out.writeChar(this.getHandle());
                remote.out.flush();
                lastError = remote.in.readChar();
                if (lastError == 0 && (numObjs = remote.in.readInt()) > 0) {
                    objNameList = new Vector<String>(numObjs);
                    byte[] objName = null;
                    int len = 0;
                    int n = 0;
                    while (n < numObjs) {
                        len = remote.in.readInt();
                        if (len > 0) {
                            objName = new byte[len];
                            remote.in.read(objName);
                            objNameList.addElement(new String(objName));
                        }
                        ++n;
                    }
                }
            }
            catch (IOException e) {
                objNameList = null;
                if (lastError == 0) {
                    lastError = 2;
                }
                throw new ExceptionKnoQuery("Unavailable server (2) getNameObjs: " + e.getMessage());
            }
            catch (Exception e) {
                objNameList = null;
                if (lastError == 0) {
                    lastError = 13;
                }
                throw new ExceptionKnoQuery("Unavailable query (2) getNameObjs: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        return objNameList;
    }

    protected Vector<Integer> getOcursObj(String objName) throws ExceptionKnoQuery {
        Vector<Integer> docsList = null;
        if (objName == null || objName.length() == 0) {
            return null;
        }
        KnoRemote remote = this.format.getRemote();
        if (remote == null) {
            throw new ExceptionKnoQuery("Unavailable server (1) getOcursObj.");
        }
        try {
            try {
                int numDocs;
                int orden = 493;
                remote.out.writeChar(orden);
                remote.out.writeChar(this.getHandle());
                int len = objName.length();
                remote.out.writeInt(len);
                remote.out.writeBytes(objName);
                remote.out.flush();
                lastError = remote.in.readChar();
                if (lastError == 0 && (numDocs = remote.in.readInt()) > 0) {
                    docsList = new Vector<Integer>(numDocs);
                    int n = 0;
                    while (n < numDocs) {
                        int numDoc = remote.in.readInt();
                        docsList.addElement(new Integer(numDoc));
                        ++n;
                    }
                }
            }
            catch (IOException e) {
                docsList = null;
                if (lastError == 0) {
                    lastError = 2;
                }
                throw new ExceptionKnoQuery("Unavailable server (2) getOcursObj: " + e.getMessage());
            }
            catch (Exception e) {
                docsList = null;
                if (lastError == 0) {
                    lastError = 13;
                }
                throw new ExceptionKnoQuery("Unavailable query (2) getOcursObj: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        return docsList;
    }

    protected Vector<KnoObjOcur> getOcurObjs() throws ExceptionKnoQuery {
        Vector<KnoObjOcur> objList = null;
        KnoObjOcur objOcurs = null;
        byte[] objName = null;
        int len = 0;
        KnoRemote remote = this.format.getRemote();
        if (remote == null) {
            throw new ExceptionKnoQuery("Unavailable server (1) getOcurObjs.");
        }
        try {
            try {
                int numObjs;
                int orden = 494;
                remote.out.writeChar(orden);
                remote.out.writeChar(this.getHandle());
                remote.out.flush();
                lastError = remote.in.readChar();
                if (lastError == 0 && (numObjs = remote.in.readInt()) > 0) {
                    objList = new Vector<KnoObjOcur>(numObjs);
                    int i = 0;
                    while (i < numObjs) {
                        len = remote.in.readInt();
                        if (len > 0) {
                            objName = new byte[len];
                            remote.in.read(objName);
                            int numDocs = remote.in.readInt();
                            if (numDocs > 0) {
                                objOcurs = new KnoObjOcur();
                                objOcurs.objName = new String(objName);
                                objOcurs.docsList = new Vector(numDocs);
                                int j = 0;
                                while (j < numDocs) {
                                    int numDoc = remote.in.readInt();
                                    objOcurs.docsList.addElement(new Integer(numDoc));
                                    ++j;
                                }
                                objList.addElement(objOcurs);
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (IOException e) {
                objList = null;
                if (lastError == 0) {
                    lastError = 2;
                }
                throw new ExceptionKnoQuery("Unavailable server (2) getOcurObjs: " + e.getMessage());
            }
            catch (Exception e) {
                objList = null;
                if (lastError == 0) {
                    lastError = 13;
                }
                throw new ExceptionKnoQuery("Unavailable query (2) getOcurObjs: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        return objList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int executeObjsQuery() throws ExceptionKnoQuery {
        int numObjs = 0;
        KnoRemote remote = this.format.getRemote();
        if (remote == null) {
            throw new ExceptionKnoQuery("Unavailable server (1) executeObjsQuery.");
        }
        try {
            try {
                int orden = 498;
                allowedPermits.acquire();
                remote.out.writeChar(orden);
                remote.out.writeChar(this.getHandle());
                remote.out.writeByte(1);
                remote.out.flush();
                lastError = remote.in.readChar();
                if (lastError != 0) return numObjs;
                int qryStat = remote.in.readInt();
                if (qryStat == 1) {
                    numObjs = remote.in.readInt();
                    return numObjs;
                }
                while (true) {
                    if (qryStat != 0) {
                        if (qryStat != 1) return numObjs;
                        numObjs = this.getObjsQuery();
                        return numObjs;
                    }
                    long current = System.currentTimeMillis();
                    while (current + 1500L > System.currentTimeMillis()) {
                    }
                    qryStat = this.getObjQueryStat();
                }
            }
            catch (IOException e) {
                lastError = 2;
                throw new ExceptionKnoQuery("Unavailable server (2) executeObjsQuery: " + e.getMessage());
            }
            catch (Exception e) {
                lastError = 13;
                throw new ExceptionKnoQuery("Unavailable query (2) executeObjsQuery: " + e.getMessage());
            }
        }
        finally {
            allowedPermits.release();
        }
    }

    protected int getObjsQuery() throws ExceptionKnoQuery {
        int numObjs = 0;
        KnoRemote remote = this.format.getRemote();
        if (remote == null) {
            throw new ExceptionKnoQuery("Unavailable server (1) getObjNameByOcur.");
        }
        try {
            try {
                int orden = 495;
                remote.out.writeChar(orden);
                remote.out.writeChar(this.getHandle());
                remote.out.flush();
                lastError = remote.in.readChar();
                if (lastError == 0) {
                    numObjs = remote.in.readInt();
                }
            }
            catch (IOException e) {
                numObjs = 0;
                if (lastError == 0) {
                    lastError = 2;
                }
                throw new ExceptionKnoQuery("Unavailable server (2) getObjNameByOcur: " + e.getMessage());
            }
            catch (Exception e) {
                numObjs = 0;
                if (lastError == 0) {
                    lastError = 13;
                }
                throw new ExceptionKnoQuery("Unavailable query (2) getObjNameByOcur: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        return numObjs;
    }

    protected String getObjNameByOcur(int ocur) throws ExceptionKnoQuery {
        String objName = null;
        KnoRemote remote = this.format.getRemote();
        if (remote == null) {
            throw new ExceptionKnoQuery("Unavailable server (1) getObjNameByOcur.");
        }
        try {
            try {
                int len;
                int orden = 499;
                remote.out.writeChar(orden);
                remote.out.writeChar(this.getHandle());
                remote.out.writeInt(ocur);
                remote.out.flush();
                lastError = remote.in.readChar();
                if (lastError == 0 && (len = remote.in.readInt()) > 0) {
                    byte[] name = new byte[len];
                    remote.in.read(name);
                    objName = new String(name);
                }
            }
            catch (IOException e) {
                objName = null;
                if (lastError == 0) {
                    lastError = 2;
                }
                throw new ExceptionKnoQuery("Unavailable server (2) getObjNameByOcur: " + e.getMessage());
            }
            catch (Exception e) {
                objName = null;
                if (lastError == 0) {
                    lastError = 13;
                }
                throw new ExceptionKnoQuery("Unavailable query (2) getObjNameByOcur: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        return objName;
    }

    public class KnoObjOcur {
        private String objName;
        private Vector<Integer> docsList;
    }
}

