/*
 * Decompiled with CFR 0.152.
 */
package es.knosys.tools;

import es.knosys.tools.ExceptionKnoQryVw;
import es.knosys.tools.ExceptionKnoRemote;
import es.knosys.tools.KnoFormat;
import es.knosys.tools.KnoQuery;
import es.knosys.tools.KnoRemote;
import java.io.IOException;
import java.util.Vector;

public class KnoQryVw {
    private KnoQuery query = null;
    private KnoFormat format = null;
    private char handle = (char)65535;
    private static int lastError = 0;

    private KnoQryVw() {
    }

    protected static KnoQryVw createQryVw(KnoQuery qry, KnoFormat fmt) throws ExceptionKnoQryVw {
        if (qry == null) {
            throw new ExceptionKnoQryVw("Error en query.");
        }
        if (fmt == null) {
            throw new ExceptionKnoQryVw("Error en formato.");
        }
        KnoQryVw qryVw = null;
        try {
            qryVw = new KnoQryVw();
            if (qryVw.creaVistaConsulta(qry, fmt) != 0 || qryVw.getHandle() == '\uffff') {
                qryVw = null;
            }
        }
        catch (Exception e) {
            throw new ExceptionKnoQryVw("Unavailable qryvw createQryVw: " + e.getMessage());
        }
        return qryVw;
    }

    private int creaVistaConsulta(KnoQuery qry, KnoFormat fmt) throws ExceptionKnoQryVw {
        this.query = qry;
        this.format = fmt;
        try {
            try {
                KnoRemote remote = this.format.getRemote();
                int orden = 551;
                remote.out.writeChar(orden);
                remote.out.writeChar(this.query.getHandle());
                remote.out.writeChar(this.format.getHandle());
                remote.out.writeChar(100);
                remote.out.flush();
                lastError = remote.in.readChar();
                this.handle = lastError == 0 ? remote.in.readChar() : (char)65535;
            }
            catch (IOException e) {
                lastError = 2;
                throw new ExceptionKnoRemote("Unavailable server creaVistaConsulta: " + e.getMessage());
            }
            catch (Exception e) {
                lastError = 14;
                throw new ExceptionKnoQryVw("Unavailable qryvw creaVistaConsulta: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        return lastError;
    }

    protected void freeQryVw() throws ExceptionKnoQryVw, ExceptionKnoRemote {
        KnoRemote remote = this.format.getRemote();
        if (remote == null) {
            throw new ExceptionKnoRemote("No hay conexi\u00ef\u00bf\u00bdn.");
        }
        if (this.handle == '\uffff') {
            throw new ExceptionKnoQryVw("No hay recurso QryVw.");
        }
        try {
            int orden = 553;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.handle);
            remote.out.flush();
            lastError = remote.in.readChar();
        }
        catch (IOException e) {
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server freeQryVw: " + e.getMessage());
        }
        catch (Exception e) {
            lastError = 14;
            throw new ExceptionKnoQryVw("Unavailable qryvw freeQryVw: " + e.getMessage());
        }
    }

    protected char getHandle() {
        return this.handle;
    }

    protected static int getLastError() {
        return lastError;
    }

    protected Vector getNumDocsQueryList() throws ExceptionKnoQryVw {
        Vector<Integer> docsList = null;
        KnoRemote remote = this.format.getRemote();
        if (remote == null) {
            throw new ExceptionKnoQryVw("Unavailable server (1) getListDocsQuery.");
        }
        try {
            try {
                int numDocs;
                int orden = 572;
                remote.out.writeChar(orden);
                remote.out.writeChar(this.getHandle());
                remote.out.flush();
                lastError = remote.in.readChar();
                if (lastError == 0 && (numDocs = remote.in.readInt()) > 0) {
                    docsList = new Vector<Integer>(numDocs);
                    int n = 0;
                    while (n < numDocs) {
                        int doc = remote.in.readInt();
                        docsList.addElement(new Integer(doc));
                        ++n;
                    }
                }
            }
            catch (IOException e) {
                docsList = null;
                if (lastError == 0) {
                    lastError = 2;
                }
                throw new ExceptionKnoQryVw("Unavailable server (2) getListDocsQuery: " + e.getMessage());
            }
            catch (Exception e) {
                docsList = null;
                if (lastError == 0) {
                    lastError = 14;
                }
                throw new ExceptionKnoQryVw("Unavailable qryvw (2) getListDocsQuery: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        return docsList;
    }

    protected byte[] readDocsXML(char page, char lines, boolean bHead) {
        return this.readDocsXML(page, lines, bHead, false, false);
    }

    protected byte[] readDocsXML(char page, char lines, boolean bHead, boolean bCamposVacios, boolean bShowMarks) {
        byte[] linesXML = null;
        try {
            try {
                KnoRemote remote = this.format.getRemote();
                int orden = 565;
                remote.out.writeChar(orden);
                remote.out.writeChar(this.getHandle());
                remote.out.writeChar(page);
                remote.out.writeChar(lines);
                remote.out.writeByte(bHead ? 1 : 0);
                remote.out.writeByte(bCamposVacios ? 1 : 0);
                remote.out.writeByte(bShowMarks ? 1 : 0);
                remote.out.flush();
                lastError = remote.in.readChar();
                if (lastError == 0) {
                    int count = remote.in.readInt();
                    linesXML = new byte[count];
                    remote.in.readFully(linesXML, 0, count);
                }
            }
            catch (IOException e) {
                linesXML = null;
                lastError = 2;
                throw new ExceptionKnoQryVw("Unavailable server readDocsXML: " + e.getMessage());
            }
            catch (Exception e) {
                linesXML = null;
                lastError = 14;
                throw new ExceptionKnoQryVw("Unavailable qryvw readDocsXML: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        return linesXML;
    }

    protected byte[] readDocsXML4(char page, char lines, boolean bHead, boolean bCamposVacios, boolean bShowMarks) {
        byte[] linesXML = null;
        try {
            try {
                KnoRemote remote = this.format.getRemote();
                int orden = 573;
                remote.out.writeChar(orden);
                remote.out.writeChar(this.getHandle());
                remote.out.writeChar(page);
                remote.out.writeChar(lines);
                remote.out.writeByte(bHead ? 1 : 0);
                remote.out.writeByte(bCamposVacios ? 1 : 0);
                remote.out.writeByte(bShowMarks ? 1 : 0);
                remote.out.flush();
                lastError = remote.in.readChar();
                if (lastError == 0) {
                    int count = remote.in.readInt();
                    linesXML = new byte[count];
                    remote.in.readFully(linesXML, 0, count);
                }
            }
            catch (IOException e) {
                linesXML = null;
                lastError = 2;
                throw new ExceptionKnoQryVw("Unavailable server readDocsXML: " + e.getMessage());
            }
            catch (Exception e) {
                linesXML = null;
                lastError = 14;
                throw new ExceptionKnoQryVw("Unavailable qryvw readDocsXML: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        return linesXML;
    }

    protected byte[] readDocsXML(int firstLine, char lines, boolean bHead, boolean bCamposVacios) {
        byte[] linesXML = null;
        try {
            try {
                KnoRemote remote = this.format.getRemote();
                int orden = 571;
                remote.out.writeChar(orden);
                remote.out.writeChar(this.getHandle());
                remote.out.writeInt(firstLine);
                remote.out.writeChar(lines);
                remote.out.writeByte(bHead ? 1 : 0);
                remote.out.writeByte(bCamposVacios ? 1 : 0);
                remote.out.writeByte(0);
                remote.out.flush();
                lastError = remote.in.readChar();
                if (lastError == 0) {
                    int count = remote.in.readInt();
                    linesXML = new byte[count];
                    remote.in.readFully(linesXML, 0, count);
                }
            }
            catch (IOException e) {
                linesXML = null;
                lastError = 2;
                throw new ExceptionKnoQryVw("Unavailable server readDocsXML: " + e.getMessage());
            }
            catch (Exception e) {
                linesXML = null;
                lastError = 14;
                throw new ExceptionKnoQryVw("Unavailable qryvw readDocsXML: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        return linesXML;
    }

    protected byte[] readLinesXML(char page, char lines) {
        byte[] linesXML = null;
        try {
            try {
                KnoRemote remote = this.format.getRemote();
                int orden = 558;
                remote.out.writeChar(orden);
                remote.out.writeChar(this.getHandle());
                remote.out.writeChar(page);
                remote.out.writeChar(lines);
                remote.out.flush();
                lastError = remote.in.readChar();
                if (lastError == 0) {
                    int count = remote.in.readInt();
                    linesXML = new byte[count];
                    remote.in.readFully(linesXML, 0, count);
                }
            }
            catch (IOException e) {
                linesXML = null;
                lastError = 2;
                throw new ExceptionKnoQryVw("Unavailable server readLinesXML: " + e.getMessage());
            }
            catch (Exception e) {
                linesXML = null;
                lastError = 14;
                throw new ExceptionKnoQryVw("Unavailable qryvw readLinesXML: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        return linesXML;
    }
}

