/*
 * Decompiled with CFR 0.152.
 */
package es.knosys.tools;

import com.jcraft.jzlib.Deflater;
import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class KnoOutputStream
implements DataOutput {
    private int MAX_BLOCK = 1600;
    private int SIZE_COMPRESS = 1024;
    protected DataOutputStream out = null;

    public KnoOutputStream(BufferedOutputStream buffOut) {
        this.out = new DataOutputStream(buffOut);
    }

    @Override
    public void writeBytes(String text) {
        try {
            int textLength = text.length();
            if (textLength > this.SIZE_COMPRESS) {
                Deflater deflater = new Deflater(1);
                deflater.setInput(text.getBytes());
                while (deflater.next_in_index < textLength) {
                    int availIn;
                    byte[] output = new byte[this.MAX_BLOCK];
                    deflater.setOutput(output);
                    deflater.avail_in = availIn = Math.min(this.MAX_BLOCK, textLength - deflater.next_in_index);
                    deflater.next_out_index = 0;
                    int remaining = textLength - deflater.next_in_index;
                    if (remaining > this.MAX_BLOCK) {
                        deflater.deflate(3);
                    } else {
                        deflater.deflate(4);
                    }
                    byte[] sendArray = Arrays.copyOfRange(output, 0, deflater.next_out_index);
                    this.out.writeChar(sendArray.length);
                    this.out.write(sendArray);
                }
                deflater.end();
            } else {
                this.out.write(text.getBytes());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.out.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.out.writeByte(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.out.writeChar(v);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.out.writeChars(s);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.out.writeDouble(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.out.writeFloat(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.out.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.out.writeLong(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.out.writeShort(v);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        this.out.writeUTF(str);
    }
}

