/*
 * Decompiled with CFR 0.152.
 */
package es.knosys.tools;

import es.knosys.tools.ExceptionKnoLegTermsVw;
import es.knosys.tools.ExceptionKnoQryVw;
import es.knosys.tools.ExceptionKnoRemote;
import es.knosys.tools.KnoDataBase;
import es.knosys.tools.KnoRemote;
import java.io.IOException;
import java.util.Vector;

public class KnoLegTermsVw {
    private KnoDataBase dataBase = null;
    private String cmpName = "";
    private String query = "";
    private char handle = (char)65535;
    private static int lastError = 0;

    private KnoLegTermsVw() {
    }

    private int abreTerminosAdmitidos(KnoDataBase db, String cmp, String qry) throws ExceptionKnoLegTermsVw {
        this.dataBase = db;
        this.cmpName = cmp;
        this.query = qry;
        try {
            try {
                KnoRemote remote = this.dataBase.getRemote();
                int orden = 801;
                int count = 0;
                remote.out.writeChar(orden);
                remote.out.writeChar(this.dataBase.getHandle());
                count = this.cmpName.length();
                remote.out.writeInt(count);
                if (count > 0) {
                    remote.out.writeBytes(this.cmpName);
                }
                count = 0;
                if (this.query != null) {
                    count = this.query.length();
                }
                remote.out.writeInt(count);
                if (count > 0) {
                    remote.out.writeBytes(this.query);
                }
                remote.out.writeChar(256);
                remote.out.writeInt(0);
                remote.out.flush();
                lastError = remote.in.readChar();
                this.handle = lastError == 0 ? remote.in.readChar() : (char)65535;
            }
            catch (IOException e) {
                lastError = 2;
                throw new ExceptionKnoRemote();
            }
            catch (Exception Ex) {
                lastError = 15;
                throw new ExceptionKnoQryVw();
            }
        }
        catch (Throwable throwable) {}
        return lastError;
    }

    protected void closeLegTermsVw() throws ExceptionKnoLegTermsVw, ExceptionKnoRemote {
        KnoRemote remote = this.dataBase.getRemote();
        if (remote == null) {
            throw new ExceptionKnoRemote("No hay conexi\u00ef\u00bf\u00bdn.");
        }
        if (this.handle == '\uffff') {
            throw new ExceptionKnoLegTermsVw("No hay recurso LegTermsVw.");
        }
        try {
            int orden = 802;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.handle);
            remote.out.flush();
            lastError = remote.in.readChar();
        }
        catch (IOException e) {
            lastError = 2;
            throw new ExceptionKnoRemote();
        }
        catch (Exception Ex) {
            lastError = 15;
            throw new ExceptionKnoLegTermsVw();
        }
    }

    protected char getHandle() {
        return this.handle;
    }

    protected static int getLastError() {
        return lastError;
    }

    protected Vector getLegalTermsList() {
        Vector<String> legalTerms = null;
        try {
            try {
                KnoRemote remote = this.dataBase.getRemote();
                int orden = 807;
                int count = 0;
                remote.out.writeChar(orden);
                remote.out.writeChar(this.getHandle());
                remote.out.flush();
                lastError = remote.in.readChar();
                if (lastError == 0) {
                    int numTerms = remote.in.readInt();
                    legalTerms = new Vector<String>(numTerms);
                    int n = 0;
                    while (n < numTerms) {
                        count = remote.in.readInt();
                        if (count > 0) {
                            byte[] term = new byte[count];
                            remote.in.read(term);
                            legalTerms.addElement(new String(term, "ISO-8859-1"));
                        }
                        ++n;
                    }
                }
            }
            catch (IOException e) {
                lastError = 2;
                throw new ExceptionKnoRemote();
            }
            catch (Exception Ex) {
                lastError = 15;
                throw new ExceptionKnoLegTermsVw();
            }
        }
        catch (Throwable throwable) {}
        return legalTerms;
    }

    protected byte[] getLegalTermsXML(char page, char terms) {
        byte[] termsXML = null;
        try {
            try {
                KnoRemote remote = this.dataBase.getRemote();
                int orden = 808;
                remote.out.writeChar(orden);
                remote.out.writeChar(this.getHandle());
                remote.out.writeChar(page);
                remote.out.writeChar(terms);
                remote.out.flush();
                lastError = remote.in.readChar();
                if (lastError == 0) {
                    int count = remote.in.readInt();
                    termsXML = new byte[count];
                    remote.in.readFully(termsXML, 0, count);
                }
            }
            catch (IOException e) {
                lastError = 2;
                throw new ExceptionKnoRemote();
            }
            catch (Exception Ex) {
                lastError = 15;
                throw new ExceptionKnoLegTermsVw();
            }
        }
        catch (Throwable throwable) {}
        return termsXML;
    }

    protected byte[] getTotalLegalTerm(int documento) {
        byte[] term = null;
        try {
            try {
                KnoRemote remote = this.dataBase.getRemote();
                int orden = 812;
                remote.out.writeChar(orden);
                remote.out.writeChar(this.getHandle());
                remote.out.writeInt(documento);
                remote.out.flush();
                lastError = remote.in.readChar();
                if (lastError == 0) {
                    int count = remote.in.readInt();
                    term = new byte[count];
                    remote.in.readFully(term, 0, count);
                }
            }
            catch (IOException e) {
                lastError = 2;
                throw new ExceptionKnoRemote();
            }
            catch (Exception Ex) {
                lastError = 15;
                throw new ExceptionKnoLegTermsVw();
            }
        }
        catch (Throwable throwable) {}
        return term;
    }

    protected static KnoLegTermsVw openLegTermsVw(KnoDataBase db, String cmp, String term) throws ExceptionKnoLegTermsVw {
        if (db == null) {
            throw new ExceptionKnoLegTermsVw("Error en dataBase.");
        }
        if (cmp == "") {
            throw new ExceptionKnoLegTermsVw("Error en cmpName.");
        }
        KnoLegTermsVw legTermsVw = null;
        try {
            try {
                legTermsVw = new KnoLegTermsVw();
                if (legTermsVw.abreTerminosAdmitidos(db, cmp, term) != 0 || legTermsVw.getHandle() == '\uffff') {
                    legTermsVw = null;
                }
            }
            catch (Exception e) {
                throw new ExceptionKnoLegTermsVw();
            }
        }
        catch (Throwable throwable) {}
        return legTermsVw;
    }
}

