/*
 * Decompiled with CFR 0.152.
 */
package es.knosys.tools;

import com.jcraft.jzlib.Inflater;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;

public class KnoInputStream
implements DataInput {
    private int MAX_BLOCK = 32768;
    private int SIZE_COMPRESS = 1024;
    protected DataInputStream in;

    public KnoInputStream(BufferedInputStream buffIn) {
        this.in = new DataInputStream(buffIn);
    }

    public void close() throws IOException {
        this.in.close();
    }

    public int read(byte[] b) {
        return this.read(b, true);
    }

    public int read(byte[] byteBuffer, boolean compress) {
        if (byteBuffer.length == 0) {
            return 0;
        }
        try {
            Inflater inflater;
            if (byteBuffer.length > this.SIZE_COMPRESS && compress) {
                inflater = new Inflater();
                inflater.setOutput(byteBuffer);
                inflater.init();
                while (inflater.avail_out > 0) {
                    this.waitForData();
                    int lenBuffer = this.in.readChar();
                    byte[] srvBuffer = new byte[lenBuffer];
                    int i = 0;
                    while (i < lenBuffer) {
                        this.waitForData();
                        srvBuffer[i] = this.in.readByte();
                        ++i;
                    }
                    if (inflater.avail_out > this.MAX_BLOCK) {
                        Thread.sleep(20L);
                    }
                    inflater.setInput(srvBuffer);
                    inflater.avail_in = lenBuffer;
                    inflater.next_in_index = 0;
                    inflater.inflate(0);
                }
            } else {
                return this.in.read(byteBuffer);
            }
            inflater.end();
            return byteBuffer.length;
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            return -1;
        }
    }

    private void waitForData() throws IOException {
        try {
            int i = 0;
            while (this.in.available() == 0) {
                Thread.sleep(10L);
                if (++i <= 6000) continue;
                throw new IOException("KnoInputStream - Error: waitForData ha esperado mas de 1 minuto!");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.waitForData();
        return this.in.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        this.waitForData();
        return this.in.readByte();
    }

    @Override
    public char readChar() throws IOException {
        this.waitForData();
        return this.in.readChar();
    }

    @Override
    public double readDouble() throws IOException {
        this.waitForData();
        return this.in.readDouble();
    }

    @Override
    public float readFloat() throws IOException {
        this.waitForData();
        return this.in.readFloat();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.read(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.read(b);
    }

    @Override
    public int readInt() throws IOException {
        this.waitForData();
        return this.in.readInt();
    }

    @Override
    public String readLine() throws IOException {
        this.waitForData();
        return this.in.readLine();
    }

    @Override
    public long readLong() throws IOException {
        this.waitForData();
        return this.in.readLong();
    }

    @Override
    public short readShort() throws IOException {
        this.waitForData();
        return this.in.readShort();
    }

    @Override
    public String readUTF() throws IOException {
        this.waitForData();
        return this.in.readUTF();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        this.waitForData();
        return this.in.readUnsignedByte();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        this.waitForData();
        return this.in.readUnsignedShort();
    }

    @Override
    public int skipBytes(int arg0) throws IOException {
        this.waitForData();
        return this.in.skipBytes(arg0);
    }
}

