/*
 * Decompiled with CFR 0.152.
 */
package es.knosys.tools;

import es.knosys.tools.ExceptionKnoDataBase;
import es.knosys.tools.ExceptionKnoFormat;
import es.knosys.tools.ExceptionKnoRemote;
import es.knosys.tools.KnoDBField;
import es.knosys.tools.KnoDBFormat;
import es.knosys.tools.KnoDBStyle;
import es.knosys.tools.KnoDBTag;
import es.knosys.tools.KnoDataBase;
import es.knosys.tools.KnoFieldInfo;
import es.knosys.tools.KnoRemote;
import es.knosys.tools.KnoUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Vector;

public class KnoFormat {
    private static final int TAM_FORMAT = 16;
    private static final int TAM_FNTNAME = 128;
    private static final int TAM_INT = 4;
    private static final int TAM_FIELD = 172;
    private static final int TAM_TAG = 172;
    private static final int TAM_FIELD_ORDER = 7;
    private static final int TAM_DESIGN_CONFIG = 280;
    private static final int FMT_DOC = 1;
    private KnoDataBase dataBase = null;
    private String nomFormat = "USE_COMPLETE_DB_FORMAT";
    private int typeFormat = 0;
    private char handle = (char)65535;
    private static int lastError = 0;

    private KnoFormat() {
    }

    private int abreFormato(KnoDataBase db, String nomFormato, int tipoFormato) throws ExceptionKnoFormat {
        if (db == null || db.getHandle() == '\uffff') {
            throw new ExceptionKnoFormat("Unspecified database abreFormato.");
        }
        if (nomFormato == null || nomFormato.compareTo("") == 0) {
            throw new ExceptionKnoFormat("Invalid format name abreFormato.");
        }
        this.dataBase = db;
        this.nomFormat = nomFormato;
        this.typeFormat = tipoFormato;
        KnoRemote remote = this.dataBase.getRemote();
        if (remote == null) {
            throw new ExceptionKnoFormat("Unavailable server (1) abreFormato.");
        }
        try {
            int orden = 410;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.dataBase.getHandle());
            int count = this.nomFormat.length();
            remote.out.writeInt(count);
            if (count > 0) {
                remote.out.writeBytes(this.nomFormat);
            }
            remote.out.writeInt(this.typeFormat);
            remote.out.flush();
            lastError = remote.in.readChar();
            this.handle = lastError == 0 ? remote.in.readChar() : (char)65535;
        }
        catch (IOException e) {
            this.dataBase = null;
            this.nomFormat = "";
            lastError = 2;
            throw new ExceptionKnoFormat("Unavailable server (2) abreFormato: " + e.getMessage());
        }
        catch (Exception Ex) {
            this.dataBase = null;
            this.nomFormat = "";
            lastError = 9;
            throw new ExceptionKnoFormat("Unavailable format (2) abreFormato: " + Ex.getMessage());
        }
        return lastError;
    }

    protected void closeFormat() throws ExceptionKnoFormat {
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoFormat("Unavailable server (1) closeFormat.");
        }
        if (this.handle == '\uffff') {
            throw new ExceptionKnoFormat("Unavailable format (1) closeFormat.");
        }
        try {
            int orden = 411;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.handle);
            remote.out.flush();
            lastError = remote.in.readChar();
        }
        catch (IOException e) {
            lastError = 2;
            throw new ExceptionKnoFormat("Unavailable server (2) closeFormat: " + e.getMessage());
        }
        catch (Exception Ex) {
            lastError = 9;
            throw new ExceptionKnoFormat("Unavailable format (2) closeFormat: " + Ex.getMessage());
        }
    }

    protected KnoDataBase getDataBase() {
        return this.dataBase;
    }

    protected short[] getFormatFields() throws ExceptionKnoFormat {
        char numFields = '\u0000';
        short[] sa = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoFormat("Unavailable server (1) getFormatFields.");
        }
        try {
            int orden = 417;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.handle);
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0) {
                numFields = remote.in.readChar();
                sa = new short[numFields];
                char i = '\u0000';
                while (i < numFields) {
                    sa[i] = (short)remote.in.readChar();
                    i = (char)(i + '\u0001');
                }
            }
        }
        catch (IOException e) {
            sa = null;
            lastError = 2;
            throw new ExceptionKnoFormat("Unavailable server (2) getFormatFields: " + e.getMessage());
        }
        catch (Exception e) {
            sa = null;
            lastError = 9;
            throw new ExceptionKnoFormat("Unavailable format (2) getFormatFields: " + e.getMessage());
        }
        return sa;
    }

    protected Vector getFormatFieldsList(String fmtName) throws ExceptionKnoFormat {
        Vector<KnoFieldInfo> fields = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoFormat("Unavailable server (1) getFormatFieldsList.");
        }
        try {
            int orden = 421;
            int count = 0;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.getHandle());
            count = fmtName.length();
            remote.out.writeInt(count);
            if (count > 0) {
                remote.out.writeBytes(fmtName);
            }
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0) {
                int numCmps = remote.in.readInt();
                fields = new Vector<KnoFieldInfo>(numCmps);
                int n = 0;
                while (n < numCmps) {
                    KnoFieldInfo fieldInfo = new KnoFieldInfo();
                    fieldInfo.type = 0;
                    fieldInfo.hasDescriptors = false;
                    count = remote.in.readInt();
                    if (count > 0) {
                        byte[] field = new byte[count];
                        remote.in.read(field);
                        fieldInfo.fieldName = new String(field);
                    } else {
                        fieldInfo.fieldName = "";
                    }
                    count = remote.in.readInt();
                    if (count > 0) {
                        byte[] tag = new byte[count];
                        remote.in.read(tag);
                        fieldInfo.fieldTag = new String(tag);
                    } else {
                        fieldInfo.fieldTag = "";
                    }
                    count = remote.in.readInt();
                    if (count > 0) {
                        byte[] description = new byte[count];
                        remote.in.read(description);
                        fieldInfo.fieldDescription = new String(description, "ISO-8859-1");
                    } else {
                        fieldInfo.fieldDescription = "";
                    }
                    fieldInfo.type = remote.in.readInt();
                    fieldInfo.admTerms = remote.in.readByte();
                    fieldInfo.hashcode = remote.in.readByte();
                    fieldInfo.hasDescriptors = false;
                    fields.addElement(fieldInfo);
                    ++n;
                }
            }
        }
        catch (IOException e) {
            if (fields != null) {
                fields.removeAllElements();
            }
            fields = null;
            lastError = 2;
            throw new ExceptionKnoFormat("Unavailable server (2) getFormatFieldsList: " + e.getMessage());
        }
        catch (Exception e) {
            if (fields != null) {
                fields.removeAllElements();
            }
            fields = null;
            lastError = 9;
            throw new ExceptionKnoFormat("Unavailable format (2) getFormatFieldsList: " + e.getMessage());
        }
        return fields;
    }

    protected KnoDBFormat getFormat(String fmtName) throws ExceptionKnoFormat {
        KnoDBFormat format = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoFormat("Unavailable server (1) getFormat.");
        }
        try {
            remote.out.writeChar(414);
            remote.out.writeChar(this.getHandle());
            remote.out.flush();
            lastError = remote.in.readInt();
            if (lastError == 0) {
                byte[] array;
                KnoDBStyle style;
                ByteBuffer bytes;
                byte[] array2;
                format = new KnoDBFormat();
                short size = remote.in.readShort();
                format.setName(new String(KnoUtil.readString(remote, size)));
                format.setMode(remote.in.readInt());
                format.setNumFields(remote.in.readShort());
                int i = 0;
                while (i < format.getNumFields()) {
                    array2 = KnoUtil.readBytes(remote, 172);
                    bytes = ByteBuffer.wrap(array2);
                    KnoDBField field = new KnoDBField();
                    field.setHashCode(KnoUtil.ByteBuffer2Byte(bytes));
                    field.setUseIn(KnoUtil.ByteBuffer2Byte(bytes));
                    style = this.readKnoDBStyle(bytes);
                    field.setStyle(style);
                    format.addField(field);
                    ++i;
                }
                format.setNumTags(remote.in.readShort());
                i = 0;
                while (i < format.getNumTags()) {
                    array2 = KnoUtil.readBytes(remote, 172);
                    bytes = ByteBuffer.wrap(array2);
                    KnoDBTag tag = new KnoDBTag();
                    tag.setHashCode(KnoUtil.ByteBuffer2Word(bytes));
                    style = this.readKnoDBStyle(bytes);
                    tag.setStyle(style);
                    format.addTag(tag);
                    ++i;
                }
                KnoDBFormat.ListConfig listConfig = format.getListConfig();
                listConfig.setNumDoc(remote.in.readUnsignedByte());
                listConfig.setDocSize(remote.in.readUnsignedByte());
                listConfig.setCDate(remote.in.readUnsignedByte());
                listConfig.setMDate(remote.in.readUnsignedByte());
                listConfig.setWorkflow(remote.in.readUnsignedByte());
                listConfig.setStatus(remote.in.readUnsignedByte());
                listConfig.setNumOrdFields(remote.in.readShort());
                int i2 = 0;
                while (i2 < listConfig.getNumOrdFields()) {
                    array = KnoUtil.readBytes(remote, 7);
                    ByteBuffer bytes2 = ByteBuffer.wrap(array);
                    KnoDBFormat.FieldOrder fieldOrder = format.new KnoDBFormat.FieldOrder();
                    fieldOrder.setHashCode(KnoUtil.ByteBuffer2Word(bytes2));
                    fieldOrder.setNumChars(KnoUtil.ByteBuffer2DWord(bytes2));
                    fieldOrder.setDirection(KnoUtil.ByteBuffer2Byte(bytes2));
                    format.getListConfig().addFieldOrder(fieldOrder);
                    ++i2;
                }
                listConfig.setNumColWidth(remote.in.readShort());
                if (listConfig.getNumColWidth() > 0) {
                    byte[] array3 = KnoUtil.readBytes(remote, listConfig.getNumColWidth() * 4);
                    bytes = ByteBuffer.wrap(array3);
                    int i3 = 0;
                    while (i3 < listConfig.getNumColWidth()) {
                        format.getListConfig().addColWidth(KnoUtil.ByteBuffer2DWord(bytes));
                        ++i3;
                    }
                }
                KnoDBFormat.DesignConfig designConfig = format.getDesignConfig();
                format.setMode(remote.in.readInt());
                array = KnoUtil.readBytes(remote, 280);
                ByteBuffer bytes3 = ByteBuffer.wrap(array);
                designConfig.setFontName(KnoUtil.ByteBuffer2String(bytes3, 129));
                designConfig.setSize(KnoUtil.ByteBuffer2Word(bytes3));
                designConfig.setAttrib(KnoUtil.ByteBuffer2Word(bytes3));
                designConfig.setBackColor(KnoUtil.ByteBuffer2Color(bytes3));
                designConfig.setForeColor(KnoUtil.ByteBuffer2Color(bytes3));
                designConfig.setAlign(KnoUtil.ByteBuffer2Byte(bytes3));
                designConfig.setBackColorBack(KnoUtil.ByteBuffer2Color(bytes3));
                designConfig.setAdjustPict(remote.in.readInt());
                designConfig.setPictWidth(remote.in.readInt());
                designConfig.setPictHeight(remote.in.readInt());
            }
        }
        catch (IOException e) {
            lastError = 2;
            throw new ExceptionKnoFormat("Unavailable server (2) getFormat: " + e.getMessage());
        }
        catch (Exception e) {
            lastError = 9;
            throw new ExceptionKnoFormat("Unavailable format (2) getFormat: " + e.getMessage());
        }
        return format;
    }

    protected void updateFormat(KnoDBFormat format) throws ExceptionKnoRemote, ExceptionKnoDataBase {
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) updateFormat.");
        }
        try {
            remote.out.writeChar(412);
            remote.out.writeChar(this.getHandle());
            KnoFormat.sendFormat(remote, format);
            remote.out.flush();
            lastError = remote.in.readChar();
        }
        catch (IOException e) {
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server (2) updateFormat: " + e.getMessage());
        }
        catch (Exception e) {
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database updateFormat: " + e.getMessage());
        }
    }

    protected static void sendFormat(KnoRemote remote, KnoDBFormat format) throws Exception {
        ByteBuffer bytes;
        remote.sendString(format.getName());
        remote.out.writeInt(1);
        remote.out.writeChar(format.getNumFields());
        int i = 0;
        while (i < format.getNumFields()) {
            KnoDBField field = format.getFields().get(i);
            bytes = ByteBuffer.allocate(172);
            bytes.order(ByteOrder.LITTLE_ENDIAN);
            bytes.put(field.getHashCode());
            bytes.put((byte)field.getUseIn());
            KnoFormat.writeKnoDBStyle(bytes, field.getStyle());
            remote.out.writeBytes(new String(bytes.array()));
            ++i;
        }
        remote.out.writeChar(format.getNumTags());
        i = 0;
        while (i < format.getNumTags()) {
            KnoDBTag tag = format.getTags().get(i);
            bytes = ByteBuffer.allocate(172);
            bytes.order(ByteOrder.LITTLE_ENDIAN);
            bytes.putShort((short)tag.getHashCode());
            KnoFormat.writeKnoDBStyle(bytes, tag.getStyle());
            remote.out.writeBytes(new String(bytes.array()));
            ++i;
        }
        KnoDBFormat.ListConfig listConfig = format.getListConfig();
        remote.out.write(listConfig.getNumDoc());
        remote.out.write(listConfig.getDocSize());
        remote.out.write(listConfig.getCDate());
        remote.out.write(listConfig.getMDate());
        remote.out.write(listConfig.getWorkflow());
        remote.out.write(listConfig.getStatus());
        remote.out.writeShort(listConfig.getNumOrdFields());
        if (listConfig.getNumOrdFields() > 0) {
            int i2 = 0;
            while (i2 < listConfig.getNumOrdFields()) {
                KnoDBFormat.FieldOrder fieldOrder = listConfig.getOrdFieldsList().get(i2);
                ByteBuffer bytes2 = ByteBuffer.allocate(7);
                bytes2.order(ByteOrder.LITTLE_ENDIAN);
                bytes2.putShort((short)fieldOrder.getHashCode());
                bytes2.putInt(fieldOrder.getNumChars());
                bytes2.put((byte)fieldOrder.getDirection());
                remote.out.writeBytes(new String(bytes2.array()));
                ++i2;
            }
        }
        remote.out.writeShort(listConfig.getNumColWidth());
        if (listConfig.getNumColWidth() > 0) {
            ByteBuffer bytes3 = ByteBuffer.allocate(listConfig.getNumColWidth() * 4);
            bytes3.order(ByteOrder.LITTLE_ENDIAN);
            int i3 = 0;
            while (i3 < listConfig.getNumColWidth()) {
                bytes3.putInt(listConfig.getColWidthList().get(i3));
                ++i3;
            }
            remote.out.writeBytes(new String(bytes3.array()));
        }
        KnoDBFormat.DesignConfig designConfig = format.getDesignConfig();
        remote.out.writeInt(designConfig.getMode());
        ByteBuffer bytes4 = ByteBuffer.allocate(280);
        bytes4.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer string = ByteBuffer.allocate(129);
        string.put(designConfig.getFontName().getBytes());
        bytes4.put(string.array());
        bytes4.putShort((short)designConfig.getSize());
        bytes4.putShort((short)designConfig.getAttrib());
        bytes4.putInt(KnoUtil.colorToInt(designConfig.getBackColor()));
        bytes4.putInt(KnoUtil.colorToInt(designConfig.getForeColor()));
        bytes4.put((byte)designConfig.getAlign());
        bytes4.putInt(KnoUtil.colorToInt(designConfig.getBackColorBack()));
        remote.out.writeBytes(new String(bytes4.array()));
        remote.out.writeInt(designConfig.getAdjustPict());
        remote.out.writeInt(designConfig.getPictWidth());
        remote.out.writeInt(designConfig.getPictHeight());
    }

    private static void writeKnoDBStyle(ByteBuffer bytes, KnoDBStyle style) throws Exception {
        bytes.putInt(style.getIndented());
        bytes.putInt(style.getRightMrg());
        bytes.putInt(style.getLeftMrg());
        bytes.putInt(style.getSpaceBefore());
        bytes.putInt(style.getSpaceBetween());
        bytes.putInt(style.getSpaceAfter());
        bytes.put(style.getAlign());
        ByteBuffer string = ByteBuffer.allocate(129);
        string.put(style.getFontName().getBytes());
        bytes.put(string.array());
        bytes.putShort(style.getSize());
        bytes.putShort((short)style.getAttrib());
        bytes.putInt(KnoUtil.colorToInt(style.getBackColor()));
        bytes.putInt(KnoUtil.colorToInt(style.getForeColor()));
        bytes.putInt(style.getShading());
    }

    private KnoDBStyle readKnoDBStyle(ByteBuffer bytes) throws Exception {
        KnoDBStyle style = new KnoDBStyle();
        style.setIndented(KnoUtil.ByteBuffer2DWord(bytes));
        style.setRightMrg(KnoUtil.ByteBuffer2DWord(bytes));
        style.setLeftMrg(KnoUtil.ByteBuffer2DWord(bytes));
        style.setSpaceBefore(KnoUtil.ByteBuffer2DWord(bytes));
        style.setSpaceBetween(KnoUtil.ByteBuffer2DWord(bytes));
        style.setSpaceAfter(KnoUtil.ByteBuffer2DWord(bytes));
        style.setAlign(KnoUtil.ByteBuffer2Byte(bytes));
        style.setFontName(KnoUtil.ByteBuffer2String(bytes, 129));
        style.setSize(KnoUtil.ByteBuffer2Word(bytes));
        style.setAttrib(KnoUtil.ByteBuffer2Word(bytes));
        style.setBackColor(KnoUtil.ByteBuffer2Color(bytes));
        style.setForeColor(KnoUtil.ByteBuffer2Color(bytes));
        style.setShading(KnoUtil.ByteBuffer2DWord(bytes));
        return style;
    }

    protected byte[] getFormatStylesXSL() throws ExceptionKnoFormat {
        byte[] ba = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoFormat("Unavailable server (1) getFormatStylesXSL.");
        }
        try {
            int orden = 419;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.getHandle());
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0) {
                int nLen = remote.in.readInt();
                ba = new byte[nLen];
                remote.in.readFully(ba, 0, nLen);
                if (ba.length < nLen) {
                    ba = null;
                    lastError = 9;
                }
            }
        }
        catch (IOException e) {
            ba = null;
            if (lastError == 0) {
                lastError = 2;
            }
            throw new ExceptionKnoFormat("Unavailable server (2) getStylesXSL: " + e.getMessage());
        }
        catch (Exception e) {
            ba = null;
            if (lastError == 0) {
                lastError = 9;
            }
            throw new ExceptionKnoFormat("Unavailable format (2) getStylesXSL: " + e.getMessage());
        }
        return ba;
    }

    protected byte[] getFormatStylesCSS() throws ExceptionKnoFormat {
        byte[] ba = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoFormat("Unavailable server (1) getFormatStylesXSL.");
        }
        try {
            int orden = 420;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.getHandle());
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0) {
                int nLen = remote.in.readInt();
                ba = new byte[nLen];
                remote.in.readFully(ba, 0, nLen);
                if (ba.length < nLen) {
                    ba = null;
                    lastError = 9;
                }
            }
        }
        catch (IOException e) {
            ba = null;
            if (lastError == 0) {
                lastError = 2;
            }
            throw new ExceptionKnoFormat("Unavailable server (2) getStylesXSL: " + e.getMessage());
        }
        catch (Exception e) {
            ba = null;
            if (lastError == 0) {
                lastError = 9;
            }
            throw new ExceptionKnoFormat("Unavailable format (2) getStylesXSL: " + e.getMessage());
        }
        return ba;
    }

    protected char getHandle() {
        return this.handle;
    }

    protected static int getLastError() {
        return lastError;
    }

    protected KnoRemote getRemote() {
        return this.dataBase.getRemote();
    }

    protected static KnoFormat openFormat(KnoDataBase db, String nomFormato, int tipoFormato) throws ExceptionKnoFormat {
        KnoFormat format = null;
        if (db == null || db.getHandle() == '\uffff') {
            throw new ExceptionKnoFormat("Unspecified database openFormat.");
        }
        if (nomFormato == null || nomFormato.compareTo("") == 0) {
            throw new ExceptionKnoFormat("Invalid format name openFormat.");
        }
        try {
            format = new KnoFormat();
            if (format.abreFormato(db, nomFormato, tipoFormato) != 0 || format.getHandle() == '\uffff') {
                format = null;
            }
        }
        catch (Exception e) {
            format = null;
            lastError = 9;
            throw new ExceptionKnoFormat("Unavailable format openFormat: " + e.getMessage());
        }
        return format;
    }
}

