/*
 * Decompiled with CFR 0.152.
 */
package es.knosys.tools;

import es.knosys.tools.ExceptionKnoDocument;
import es.knosys.tools.KnoDataBase;
import es.knosys.tools.KnoRemote;
import java.io.IOException;

public class KnoDocument {
    private KnoDataBase dataBase = null;
    private int numDoc = -1;
    private char handle = (char)65535;
    private static int lastError = 0;

    private KnoDocument() {
    }

    protected void closeDocument() throws ExceptionKnoDocument {
        KnoRemote remote = this.getDataBase().getRemote();
        if (remote == null) {
            throw new ExceptionKnoDocument("Unavailable server (1) closeDocument.");
        }
        if (this.handle == '\uffff') {
            throw new ExceptionKnoDocument("Unavailable document (1) closeDocument.");
        }
        try {
            int orden = 428;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.handle);
            remote.out.flush();
            lastError = remote.in.readChar();
        }
        catch (IOException e) {
            lastError = 2;
            throw new ExceptionKnoDocument("Unavailable server (2) closeDocument: " + e.getMessage());
        }
        catch (Exception e) {
            lastError = 10;
            throw new ExceptionKnoDocument("Unavailable document (2) closeDocument: " + e.getMessage());
        }
    }

    protected KnoDataBase getDataBase() {
        return this.dataBase;
    }

    protected int lockDocument() throws ExceptionKnoDocument {
        if (this.dataBase == null || this.dataBase.getHandle() == '\uffff') {
            throw new ExceptionKnoDocument("Unspecified database obtenerDocumento.");
        }
        if (this.numDoc == -1) {
            throw new ExceptionKnoDocument("Invalid document number obtenerDocumento.");
        }
        KnoRemote remote = this.dataBase.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDocument("Unavailable server (1) obtenerDocumento.");
        }
        lastError = 0;
        try {
            int orden = 433;
            int count = 0;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.handle);
            count = remote.getUserName().length();
            remote.out.writeInt(count);
            if (count > 0) {
                remote.out.writeBytes(remote.getUserName());
            }
            remote.out.flush();
            lastError = remote.in.readChar();
        }
        catch (IOException e) {
            lastError = 2;
            throw new ExceptionKnoDocument("Unavailable server (2) obtenerDocumento: " + e.getMessage());
        }
        catch (Exception e) {
            lastError = 10;
            throw new ExceptionKnoDocument("Unavailable document obtenerDocumento: " + e.getMessage());
        }
        return lastError;
    }

    protected int unlockDocument() throws ExceptionKnoDocument {
        if (this.dataBase == null || this.dataBase.getHandle() == '\uffff') {
            throw new ExceptionKnoDocument("Unspecified database obtenerDocumento.");
        }
        if (this.numDoc == -1) {
            throw new ExceptionKnoDocument("Invalid document number obtenerDocumento.");
        }
        KnoRemote remote = this.dataBase.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDocument("Unavailable server (1) obtenerDocumento.");
        }
        lastError = 0;
        try {
            int orden = 434;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.handle);
            remote.out.flush();
        }
        catch (IOException e) {
            this.dataBase = null;
            this.numDoc = -1;
            lastError = 2;
            throw new ExceptionKnoDocument("Unavailable server (2) obtenerDocumento: " + e.getMessage());
        }
        catch (Exception e) {
            this.dataBase = null;
            this.numDoc = -1;
            lastError = 10;
            throw new ExceptionKnoDocument("Unavailable document obtenerDocumento: " + e.getMessage());
        }
        return lastError;
    }

    protected boolean islockDocument() throws ExceptionKnoDocument {
        int iIsLock = 0;
        if (this.dataBase == null || this.dataBase.getHandle() == '\uffff') {
            throw new ExceptionKnoDocument("Unspecified database obtenerDocumento.");
        }
        if (this.numDoc == -1) {
            throw new ExceptionKnoDocument("Invalid document number obtenerDocumento.");
        }
        KnoRemote remote = this.dataBase.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDocument("Unavailable server (1) obtenerDocumento.");
        }
        lastError = 0;
        try {
            int orden = 432;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.handle);
            remote.out.flush();
            iIsLock = remote.in.readInt();
        }
        catch (IOException e) {
            lastError = 2;
            throw new ExceptionKnoDocument("Unavailable server (2) obtenerDocumento: " + e.getMessage());
        }
        catch (Exception e) {
            lastError = 10;
            throw new ExceptionKnoDocument("Unavailable document obtenerDocumento: " + e.getMessage());
        }
        return iIsLock > 0;
    }

    protected static KnoDocument getDocument(KnoDataBase db, int numDocum) throws ExceptionKnoDocument {
        return KnoDocument.getDocument(db, numDocum, false, false);
    }

    protected static KnoDocument getDocument(KnoDataBase db, int numDocum, boolean physicalId) throws ExceptionKnoDocument {
        return KnoDocument.getDocument(db, numDocum, physicalId, false);
    }

    protected static KnoDocument getDocument(KnoDataBase db, int numDocum, boolean physicalId, boolean lock) throws ExceptionKnoDocument {
        KnoDocument document = null;
        if (db == null || db.getHandle() == '\uffff') {
            throw new ExceptionKnoDocument("Unspecified database getDocument.");
        }
        if (numDocum == -1) {
            throw new ExceptionKnoDocument("Invalid document number getDocument.");
        }
        try {
            document = new KnoDocument();
            if (document.obtenerDocumento(db, numDocum, physicalId, lock) != 0 || document.getHandle() == '\uffff') {
                document = null;
            }
        }
        catch (Exception e) {
            document = null;
            lastError = 10;
            throw new ExceptionKnoDocument("Unavailable document getDocument: " + e.getMessage());
        }
        return document;
    }

    protected char getHandle() {
        return this.handle;
    }

    protected static int getLastError() {
        return lastError;
    }

    protected KnoRemote getRemote() {
        return this.getDataBase().getRemote();
    }

    private int obtenerDocumento(KnoDataBase db, int numDocum, boolean physicalId) throws ExceptionKnoDocument {
        return this.obtenerDocumento(db, numDocum, physicalId, false);
    }

    private int obtenerDocumento(KnoDataBase db, int numDocum, boolean physicalId, boolean lock) throws ExceptionKnoDocument {
        if (db == null || db.getHandle() == '\uffff') {
            throw new ExceptionKnoDocument("Unspecified database obtenerDocumento.");
        }
        if (numDocum == -1) {
            throw new ExceptionKnoDocument("Invalid document number obtenerDocumento.");
        }
        this.dataBase = db;
        this.numDoc = numDocum;
        KnoRemote remote = this.dataBase.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDocument("Unavailable server (1) obtenerDocumento.");
        }
        try {
            int orden = 425;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.dataBase.getHandle());
            remote.out.writeInt(this.numDoc);
            remote.out.writeInt(lock ? 1 : 0);
            remote.out.writeInt(1);
            remote.out.writeInt(physicalId ? 0 : 1);
            remote.out.flush();
            lastError = remote.in.readChar();
            this.handle = lastError == 0 ? remote.in.readChar() : (char)65535;
        }
        catch (IOException e) {
            this.dataBase = null;
            this.numDoc = -1;
            lastError = 2;
            throw new ExceptionKnoDocument("Unavailable server (2) obtenerDocumento: " + e.getMessage());
        }
        catch (Exception e) {
            this.dataBase = null;
            this.numDoc = -1;
            lastError = 10;
            throw new ExceptionKnoDocument("Unavailable document obtenerDocumento: " + e.getMessage());
        }
        return lastError;
    }
}

