/*
 * Decompiled with CFR 0.152.
 */
package es.knosys.tools;

import es.knosys.tools.ExceptionKnoDocView;
import es.knosys.tools.KnoDataBase;
import es.knosys.tools.KnoDocument;
import es.knosys.tools.KnoFormat;
import es.knosys.tools.KnoRemote;
import java.io.IOException;

public class KnoDocView {
    private KnoDocument document = null;
    private KnoFormat format = null;
    private char handle = (char)65535;
    private static int lastError = 0;

    private KnoDocView() {
    }

    protected void closeDocView() throws ExceptionKnoDocView {
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDocView("Unavailable server (1) closeDocView.");
        }
        if (this.handle == '\uffff') {
            throw new ExceptionKnoDocView("Unavailable document view closeDocView.");
        }
        try {
            int orden = 501;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.handle);
            remote.out.flush();
            lastError = remote.in.readChar();
        }
        catch (IOException e) {
            lastError = 2;
            throw new ExceptionKnoDocView("Unavailable server (2) closeDocView: " + e.getMessage());
        }
        catch (Exception e) {
            lastError = 11;
            throw new ExceptionKnoDocView("Unavailable docview (2) closeDocView: " + e.getMessage());
        }
    }

    private int creaDocView(KnoDocument documento, KnoFormat formato) throws ExceptionKnoDocView {
        if (documento == null || documento.getHandle() == '\uffff') {
            throw new ExceptionKnoDocView("Unspecified document creaDocView.");
        }
        if (formato == null || formato.getHandle() == '\uffff') {
            throw new ExceptionKnoDocView("Unspecified format creaDocView.");
        }
        this.document = documento;
        this.format = formato;
        KnoDataBase dataBase = this.document.getDataBase();
        if (dataBase == null || dataBase.getHandle() == '\uffff') {
            throw new ExceptionKnoDocView("Unavailable database creaDocView.");
        }
        KnoRemote remote = dataBase.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDocView("Unavailable server (1) creaDocView.");
        }
        try {
            try {
                int orden = 500;
                remote.out.writeChar(orden);
                remote.out.writeChar(this.document.getHandle());
                remote.out.writeChar(this.format.getHandle());
                remote.out.writeInt(0);
                remote.out.flush();
                lastError = remote.in.readChar();
                this.handle = lastError == 0 ? remote.in.readChar() : (char)65535;
            }
            catch (IOException e) {
                this.document = null;
                this.format = null;
                lastError = 2;
                throw new ExceptionKnoDocView("Unavailable server (1) creaDocView: " + e.getMessage());
            }
            catch (Exception e) {
                this.document = null;
                this.format = null;
                lastError = 11;
                throw new ExceptionKnoDocView("Unavailable docwiew creaDocView: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        return lastError;
    }

    protected static KnoDocView createDocView(KnoDocument documento, KnoFormat formato) throws ExceptionKnoDocView {
        KnoDocView docView = null;
        if (documento == null || documento.getHandle() == '\uffff') {
            throw new ExceptionKnoDocView("Unspecified document createDocView.");
        }
        if (formato == null || formato.getHandle() == '\uffff') {
            throw new ExceptionKnoDocView("Unspecified format createDocView.");
        }
        try {
            try {
                docView = new KnoDocView();
                if (docView.creaDocView(documento, formato) != 0 || docView.getHandle() == '\uffff') {
                    docView = null;
                }
            }
            catch (Exception e) {
                docView = null;
                lastError = 11;
                throw new ExceptionKnoDocView("Unavailable docview createDocView: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        return docView;
    }

    protected KnoDocument getDocument() {
        return this.document;
    }

    protected char getHandle() {
        return this.handle;
    }

    protected static int getLastError() {
        return lastError;
    }

    protected int getNumParagraphs() throws ExceptionKnoDocView {
        int numPars = 0;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDocView("Unavailable server (1) getNumParagraphs.");
        }
        try {
            try {
                int orden = 503;
                boolean count = false;
                remote.out.writeChar(orden);
                remote.out.writeChar(this.getHandle());
                remote.out.flush();
                lastError = remote.in.readChar();
                if (lastError == 0) {
                    numPars = remote.in.readInt();
                }
            }
            catch (IOException e) {
                numPars = 0;
                lastError = 2;
                throw new ExceptionKnoDocView("Unavailable server (2) getNumParagraphs: " + e.getMessage());
            }
            catch (Exception e) {
                numPars = 0;
                lastError = 11;
                throw new ExceptionKnoDocView("Unavailable docview getNumParagraphs: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        return numPars;
    }

    protected KnoRemote getRemote() {
        return this.getDocument().getRemote();
    }
}

