/*
 * Decompiled with CFR 0.152.
 */
package es.knosys.tools;

import es.knosys.tools.ExceptionKnoCatalog;
import es.knosys.tools.ExceptionKnoDataBase;
import es.knosys.tools.ExceptionKnoQuery;
import es.knosys.tools.ExceptionKnoRemote;
import es.knosys.tools.KnoCatalog;
import es.knosys.tools.KnoDBField;
import es.knosys.tools.KnoDBFieldInfoAutomatic;
import es.knosys.tools.KnoDBFieldInfoDate;
import es.knosys.tools.KnoDBFieldInfoMask;
import es.knosys.tools.KnoDBFieldInfoNumber;
import es.knosys.tools.KnoDBFieldInfoText;
import es.knosys.tools.KnoDBFieldInfoURL;
import es.knosys.tools.KnoDBFormat;
import es.knosys.tools.KnoDBIndexing;
import es.knosys.tools.KnoDBInfo;
import es.knosys.tools.KnoDBLastDocFis;
import es.knosys.tools.KnoDBObject;
import es.knosys.tools.KnoDBStruct;
import es.knosys.tools.KnoDBStyle;
import es.knosys.tools.KnoDBTag;
import es.knosys.tools.KnoFieldError;
import es.knosys.tools.KnoFieldInfo;
import es.knosys.tools.KnoFormat;
import es.knosys.tools.KnoRemote;
import es.knosys.tools.KnoSupport;
import es.knosys.tools.KnoUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;

public class KnoDataBase {
    private static final int KNO_DBNORMAL = 0;
    private static final int KNO_DBLEGALTERMS = 1;
    private static final int KNO_DBOBJSERVER = 2;
    private static final int FMT_DOC = 1;
    private static final int TAM_VERSION = 10;
    private static final int TAM_BD_ID = 24;
    private static final int TAM_CLAVEDB = 16;
    private static final int TAM_NOMCMP = 18;
    private static final int TAM_NOMTAG = 18;
    private static final int TAM_DESC_GEN = 80;
    private static final int TAM_FNTNAME = 128;
    private static final int FIELD_TYPE_TEXT = 1;
    private static final int FIELD_TYPE_NUMBER = 2;
    private static final int FIELD_TYPE_DATE = 3;
    private static final int FIELD_TYPE_MASK = 4;
    private static final int FIELD_TYPE_AUTO = 5;
    private static final int FIELD_TYPE_URL = 6;
    private static final int TAM_TEXTDEFVAL = 64;
    private static final int TAM_LIST_SEP = 32;
    private static final int TAM_NUMDEFVAL = 24;
    private static final int TAM_MASK = 64;
    private static final int TAM_PREFIJO = 64;
    private static final int TAM_SUFIJO = 64;
    private static final int TAM_KEYTARGET = 260;
    private static final int TAM_TEXT_RESERVED = 31;
    private static final int TAM_NUM_RESERVED = 101;
    private static final int TAM_DATE_RESERVED = 3;
    private static final int TAM_MASK_RESERVED = 7;
    private static final int TAM_AUTO_RESERVED = 186;
    private static final int TAM_URL_RESERVED = 141;
    private static final int TAM_NUM_ROOT = 406;
    private static final int MAX_PATH = 260;
    private static final int TAM_TAG = 292;
    private static final int TAM_FIELD = 1075;
    private static final int TAM_OCCURRENCE = 8;
    public static final int FDL_OPENDB = 1;
    public static final int FDL_CLOSEDB = 2;
    public static final int FDL_QUERYCALC = 3;
    public static final int FDL_VIEWDOC = 4;
    public static final int FDL_ERR = 5;
    public static final int FDL_PROC = 6;
    public static final int FDL_NEWDOC = 7;
    public static final int FDL_MODIFDOC = 8;
    public static final int FDL_DELETEDOC = 9;
    public static final int FDL_UNDELETEDOC = 10;
    private static final int LEVEL_NONE = 0;
    private static final int LEVEL_ALL = 1;
    private static final int LEVEL_ERR = 2;
    private static final int LEVEL_WARNING = 4;
    private static final int LEVEL_PROC = 8;
    private static final int LEVEL_INF = 16;
    private KnoRemote remote = null;
    private String dbAlias = "";
    private int dbType = 0;
    private char handle = (char)65535;
    private static int lastError = 0;
    private static ResourceBundle MESSAGE = ResourceBundle.getBundle("es.knosys.tools.KnoMessages");

    private KnoDataBase() {
    }

    private int abreBase(KnoRemote rem, String alias) throws ExceptionKnoRemote, ExceptionKnoCatalog, ExceptionKnoDataBase {
        lastError = 0;
        if (rem == null) {
            throw new ExceptionKnoDataBase("Unspecified server abreBase.");
        }
        if (alias == null || alias.compareTo("") == 0) {
            throw new ExceptionKnoRemote("Unspecified database name abreBase.");
        }
        this.remote = rem;
        this.dbAlias = alias;
        KnoCatalog catalog = null;
        KnoDBInfo dbInfo = null;
        try {
            try {
                catalog = KnoCatalog.openCatalog(rem);
                if (catalog != null) {
                    dbInfo = catalog.getDBInfo(alias);
                    if (dbInfo == null) {
                        lastError = KnoCatalog.getLastError();
                    }
                    catalog.closeCatalog();
                    catalog = null;
                } else {
                    lastError = KnoCatalog.getLastError();
                }
            }
            catch (Exception e) {
                dbInfo = null;
                if (lastError == 0) {
                    lastError = 7;
                }
                throw new ExceptionKnoDataBase("Error de cat\u00ef\u00bf\u00bdlogo: " + lastError + ". " + e.getMessage());
            }
        }
        finally {
            try {
                if (catalog != null) {
                    catalog.closeCatalog();
                }
            }
            catch (Exception exception) {}
            if (lastError != 0) {
                this.handle = (char)65535;
                return lastError;
            }
        }
        int dbType = dbInfo.dbType;
        try {
            int count = 0;
            if (dbType == 0) {
                int orden = 250;
                this.remote.out.writeChar(orden);
                count = this.dbAlias.length();
                this.remote.out.writeInt(count);
                if (count > 0) {
                    this.remote.out.writeBytes(this.dbAlias);
                }
                count = this.remote.getUserName().length();
                this.remote.out.writeInt(count);
                if (count > 0) {
                    this.remote.out.writeBytes(this.remote.getUserName());
                }
                count = this.remote.getPassword().length();
                this.remote.out.writeInt(count);
                if (count > 0) {
                    this.remote.out.writeBytes(this.remote.getPassword());
                }
                this.remote.out.flush();
                lastError = this.remote.in.readChar();
                this.handle = lastError == 0 ? this.remote.in.readChar() : (char)65535;
            } else if (dbType == 2) {
                int orden = 327;
                this.remote.out.writeChar(orden);
                count = this.dbAlias.length();
                this.remote.out.writeInt(count);
                if (count > 0) {
                    this.remote.out.writeBytes(this.dbAlias);
                }
                count = this.remote.getUserName().length();
                this.remote.out.writeInt(count);
                if (count > 0) {
                    this.remote.out.writeBytes(this.remote.getUserName());
                }
                count = this.remote.getPassword().length();
                this.remote.out.writeInt(count);
                if (count > 0) {
                    this.remote.out.writeBytes(this.remote.getPassword());
                }
                this.remote.out.flush();
                lastError = this.remote.in.readChar();
                this.handle = lastError == 0 ? this.remote.in.readChar() : (char)65535;
            }
        }
        catch (IOException e) {
            this.remote = null;
            this.dbAlias = "";
            if (lastError == 0) {
                lastError = 2;
            }
            throw new ExceptionKnoDataBase("Unavailable server abreBase. Alias: " + alias + ". " + e.getMessage());
        }
        catch (Exception e) {
            this.remote = null;
            this.dbAlias = "";
            if (lastError == 0) {
                lastError = 8;
            }
            throw new ExceptionKnoDataBase("Unavailable database abreBase: " + e.getMessage());
        }
        return lastError;
    }

    protected void closeDataBase() throws ExceptionKnoDataBase {
        if (this.remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) closeDataBase.");
        }
        if (this.handle == '\uffffffff') {
            throw new ExceptionKnoDataBase("Unavailable database (1) closeDataBase.");
        }
        try {
            int orden = 252;
            this.remote.out.writeChar(orden);
            this.remote.out.writeChar(this.handle);
            this.remote.out.flush();
            lastError = this.remote.in.readChar();
        }
        catch (IOException e) {
            lastError = 2;
            throw new ExceptionKnoDataBase("Unavailable server (2) closeDataBase: " + e.getMessage());
        }
        catch (Exception e) {
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database (2) closeDataBase: " + e.getMessage());
        }
    }

    protected KnoDBStruct getDatabaseStruct(String name) throws ExceptionKnoDataBase {
        KnoDBStruct knoDBStruct = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getDatabaseStruct.");
        }
        try {
            remote.out.writeChar(253);
            remote.out.writeChar(this.getHandle());
            remote.out.writeInt(0);
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0) {
                knoDBStruct = new KnoDBStruct();
                knoDBStruct.setVersion(KnoUtil.readString(remote, 10));
                knoDBStruct.setDBId(KnoUtil.readString(remote, 24));
                knoDBStruct.setDBType(remote.in.readInt());
                knoDBStruct.setDBPass(KnoUtil.readBytes(remote, 16));
                knoDBStruct.setMaxDBDocs(remote.in.readInt());
                knoDBStruct.setIndexType(remote.in.readUnsignedByte());
                knoDBStruct.setIndexMode(remote.in.readUnsignedByte());
                knoDBStruct.setMinutes(remote.in.readInt());
                knoDBStruct.setNumDocs(remote.in.readInt());
                knoDBStruct.setProperties(remote.in.readShort());
                knoDBStruct.setNumTags(remote.in.readShort());
                int i = 0;
                while (i < knoDBStruct.getNumTags()) {
                    byte[] array = KnoUtil.readBytes(remote, 292);
                    ByteBuffer bytes = ByteBuffer.wrap(array);
                    KnoDBTag knoDBTag = new KnoDBTag();
                    knoDBTag.setHashCode(KnoUtil.ByteBuffer2Word(bytes));
                    knoDBTag.setFieldName(KnoUtil.ByteBuffer2String(bytes, 19));
                    knoDBTag.setTagName(KnoUtil.ByteBuffer2String(bytes, 19));
                    knoDBTag.setDescription(KnoUtil.ByteBuffer2String(bytes, 81));
                    knoDBTag.setTagType(KnoUtil.ByteBuffer2Byte(bytes));
                    KnoDBStyle knoDBStyle = new KnoDBStyle();
                    knoDBStyle.setIndented(KnoUtil.ByteBuffer2DWord(bytes));
                    knoDBStyle.setRightMrg(KnoUtil.ByteBuffer2DWord(bytes));
                    knoDBStyle.setLeftMrg(KnoUtil.ByteBuffer2DWord(bytes));
                    knoDBStyle.setSpaceBefore(KnoUtil.ByteBuffer2DWord(bytes));
                    knoDBStyle.setSpaceBetween(KnoUtil.ByteBuffer2DWord(bytes));
                    knoDBStyle.setSpaceAfter(KnoUtil.ByteBuffer2DWord(bytes));
                    knoDBStyle.setAlign(KnoUtil.ByteBuffer2Byte(bytes));
                    knoDBStyle.setFontName(KnoUtil.ByteBuffer2String(bytes, 129));
                    knoDBStyle.setSize(KnoUtil.ByteBuffer2Word(bytes));
                    knoDBStyle.setAttrib(KnoUtil.ByteBuffer2Word(bytes));
                    knoDBStyle.setBackColor(KnoUtil.ByteBuffer2Color(bytes));
                    knoDBStyle.setForeColor(KnoUtil.ByteBuffer2Color(bytes));
                    knoDBStyle.setShading(KnoUtil.ByteBuffer2DWord(bytes));
                    knoDBTag.setStyle(knoDBStyle);
                    knoDBStruct.addTag(knoDBTag);
                    ++i;
                }
                KnoDBField rootField = this.readKnoDBField();
                knoDBStruct.addField(rootField);
                int i2 = 1;
                while (i2 <= rootField.getChildNum()) {
                    knoDBStruct.addField(this.readKnoDBField());
                    ++i2;
                }
            }
        }
        catch (IOException e) {
            if (lastError == 0) {
                lastError = 2;
            }
            throw new ExceptionKnoDataBase("Unavailable server (2) getDatabaseStruct: " + e.getMessage());
        }
        catch (Exception e) {
            if (lastError == 0) {
                lastError = 8;
            }
            throw new ExceptionKnoDataBase("Unavailable database (2) getDatabaseStruct: " + e.getMessage());
        }
        return knoDBStruct;
    }

    protected void modifyStruct(KnoDBStruct dbStruct) throws ExceptionKnoDataBase {
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) modifyStruct.");
        }
        try {
            remote.out.writeChar(288);
            remote.out.writeChar(this.getHandle());
            remote.out.writeByte(1);
            remote.out.flush();
            KnoUtil.writeString(remote, dbStruct.getVersion(), 10);
            KnoUtil.writeString(remote, dbStruct.getDBId(), 24);
            remote.out.writeInt(dbStruct.getDBType());
            remote.out.write(dbStruct.getDBPass());
            remote.out.writeInt(dbStruct.getMaxDBDocs());
            remote.out.writeByte(dbStruct.getIndexType());
            remote.out.writeByte(dbStruct.getIndexMode());
            remote.out.writeInt(dbStruct.getMinutes());
            remote.out.writeInt(dbStruct.getNumDocs());
            remote.out.writeChar(dbStruct.getProperties());
            remote.out.writeChar(dbStruct.getNumTags());
            int i = 0;
            while (i < dbStruct.getNumTags()) {
                KnoDBTag knoDBTag = dbStruct.getTags().get(i);
                ByteBuffer bytes = ByteBuffer.allocate(292);
                bytes.order(ByteOrder.LITTLE_ENDIAN);
                bytes.putShort((short)knoDBTag.getHashCode());
                KnoUtil.putString(bytes, knoDBTag.getFieldName(), 19);
                KnoUtil.putString(bytes, knoDBTag.getTagName(), 19);
                KnoUtil.putString(bytes, knoDBTag.getDescription(), 81);
                bytes.put(knoDBTag.getTagType());
                KnoDBStyle knoDBStyle = knoDBTag.getStyle();
                bytes.putInt(knoDBStyle.getIndented());
                bytes.putInt(knoDBStyle.getRightMrg());
                bytes.putInt(knoDBStyle.getLeftMrg());
                bytes.putInt(knoDBStyle.getSpaceBefore());
                bytes.putInt(knoDBStyle.getSpaceBetween());
                bytes.putInt(knoDBStyle.getSpaceAfter());
                bytes.put(knoDBStyle.getAlign());
                KnoUtil.putString(bytes, knoDBStyle.getFontName(), 129);
                bytes.putShort(knoDBStyle.getSize());
                bytes.putShort((short)knoDBStyle.getAttrib());
                bytes.putInt(KnoUtil.colorToInt(knoDBStyle.getBackColor()));
                bytes.putInt(KnoUtil.colorToInt(knoDBStyle.getForeColor()));
                bytes.putInt(knoDBStyle.getShading());
                remote.out.writeBytes(new String(bytes.array()));
                ++i;
            }
            i = 0;
            while (i < dbStruct.getAllFields().size()) {
                KnoDBField knoDBField = dbStruct.getAllFields().get(i);
                this.writeKnoDBField(knoDBField);
                ++i;
            }
            remote.out.flush();
        }
        catch (IOException e) {
            if (lastError == 0) {
                lastError = 2;
            }
            throw new ExceptionKnoDataBase("Unavailable server (2) modifyStruct: " + e.getMessage());
        }
        catch (Exception e) {
            if (lastError == 0) {
                lastError = 8;
            }
            throw new ExceptionKnoDataBase("Unavailable database (2) modifyStruct: " + e.getMessage());
        }
    }

    private KnoDBField readKnoDBField() throws Exception {
        byte[] array = new byte[]{};
        ByteBuffer bytes = null;
        array = KnoUtil.readBytes(this.remote, 1075);
        bytes = ByteBuffer.wrap(array);
        KnoDBField knoDBField = new KnoDBField();
        knoDBField.setOrdNum(KnoUtil.ByteBuffer2Word(bytes));
        knoDBField.setHashCode(KnoUtil.ByteBuffer2Byte(bytes));
        knoDBField.setFieldKnoW(KnoUtil.ByteBuffer2String(bytes, 37));
        knoDBField.setFieldName(KnoUtil.ByteBuffer2String(bytes, 19));
        knoDBField.setTagName(KnoUtil.ByteBuffer2String(bytes, 19));
        knoDBField.setDescription(KnoUtil.ByteBuffer2String(bytes, 81));
        knoDBField.setFieldType(KnoUtil.ByteBuffer2Byte(bytes));
        knoDBField.setRequired(KnoUtil.ByteBuffer2DWord(bytes) != 0);
        KnoDBStyle knoDBStyle = new KnoDBStyle();
        knoDBStyle.setFontName(KnoUtil.ByteBuffer2String(bytes, 129));
        knoDBStyle.setSize(KnoUtil.ByteBuffer2Word(bytes));
        knoDBStyle.setAttrib(KnoUtil.ByteBuffer2Word(bytes));
        knoDBStyle.setBackColor(KnoUtil.ByteBuffer2Color(bytes));
        knoDBStyle.setForeColor(KnoUtil.ByteBuffer2Color(bytes));
        knoDBStyle.setShading(KnoUtil.ByteBuffer2DWord(bytes));
        knoDBStyle.setAlign(KnoUtil.ByteBuffer2Byte(bytes));
        knoDBStyle.setIndented(KnoUtil.ByteBuffer2DWord(bytes));
        knoDBStyle.setLeftMrg(KnoUtil.ByteBuffer2DWord(bytes));
        knoDBStyle.setRightMrg(KnoUtil.ByteBuffer2DWord(bytes));
        knoDBStyle.setSpaceBefore(KnoUtil.ByteBuffer2DWord(bytes));
        knoDBStyle.setSpaceBetween(KnoUtil.ByteBuffer2DWord(bytes));
        knoDBStyle.setSpaceAfter(KnoUtil.ByteBuffer2DWord(bytes));
        knoDBField.setStyle(knoDBStyle);
        KnoDBIndexing knoDBIndexing = new KnoDBIndexing();
        knoDBIndexing.setFlagsIdx(KnoUtil.ByteBuffer2Byte(bytes));
        knoDBIndexing.setSeparators(KnoUtil.ByteBuffer2ByteArray(bytes, 33));
        knoDBIndexing.setFilter(KnoUtil.ByteBuffer2DWord(bytes));
        knoDBIndexing.setSFilter(KnoUtil.ByteBuffer2ByteArray(bytes, 261));
        knoDBField.setIndexing(knoDBIndexing);
        switch (knoDBField.getFieldType()) {
            case 1: {
                KnoDBFieldInfoText infoText = new KnoDBFieldInfoText();
                infoText.setHasDefValue(KnoUtil.ByteBuffer2DWord(bytes) > 0);
                infoText.setDefValue(KnoUtil.ByteBuffer2String(bytes, 65));
                infoText.setHasAdmitidos(KnoUtil.ByteBuffer2DWord(bytes) > 0);
                infoText.setNumAdmitidos(KnoUtil.ByteBuffer2DWord(bytes));
                infoText.setSeparators(KnoUtil.ByteBuffer2String(bytes, 33));
                infoText.setHasTesauro(KnoUtil.ByteBuffer2DWord(bytes) > 0);
                infoText.setPathTesauro(KnoUtil.ByteBuffer2String(bytes, 261));
                KnoUtil.ByteBuffer2ByteArray(bytes, 31);
                knoDBField.setInfo(infoText);
                break;
            }
            case 2: {
                KnoDBFieldInfoNumber infoNumber = new KnoDBFieldInfoNumber();
                infoNumber.setIntegerDigits(KnoUtil.ByteBuffer2Word(bytes));
                infoNumber.setIntegerPadding(KnoUtil.ByteBuffer2Byte(bytes));
                infoNumber.setDecimalDigits(KnoUtil.ByteBuffer2Word(bytes));
                infoNumber.setDecimalPadding(KnoUtil.ByteBuffer2Byte(bytes));
                infoNumber.setPointThousand(KnoUtil.ByteBuffer2DWord(bytes) > 0);
                infoNumber.setNumberSign(KnoUtil.ByteBuffer2Byte(bytes));
                infoNumber.setHasDefValue(KnoUtil.ByteBuffer2DWord(bytes) > 0);
                infoNumber.setDefValue(KnoUtil.ByteBuffer2String(bytes, 25));
                infoNumber.setHasTesauro(KnoUtil.ByteBuffer2DWord(bytes) > 0);
                infoNumber.setPathTesauro(KnoUtil.ByteBuffer2String(bytes, 261));
                KnoUtil.ByteBuffer2ByteArray(bytes, 101);
                knoDBField.setInfo(infoNumber);
                break;
            }
            case 3: {
                KnoDBFieldInfoDate infoDate = new KnoDBFieldInfoDate();
                infoDate.setFormatView(KnoUtil.ByteBuffer2String(bytes, 65));
                infoDate.setHasDefValue(KnoUtil.ByteBuffer2DWord(bytes) > 0);
                infoDate.setDefType(KnoUtil.ByteBuffer2DWord(bytes));
                infoDate.setDefOther(KnoUtil.ByteBuffer2String(bytes, 65));
                infoDate.setHasTesauro(KnoUtil.ByteBuffer2DWord(bytes) > 0);
                infoDate.setPathTesauro(KnoUtil.ByteBuffer2String(bytes, 261));
                KnoUtil.ByteBuffer2ByteArray(bytes, 3);
                knoDBField.setInfo(infoDate);
                break;
            }
            case 4: {
                KnoDBFieldInfoMask infoMask = new KnoDBFieldInfoMask();
                infoMask.setMask(KnoUtil.ByteBuffer2String(bytes, 65));
                infoMask.setHasDefValue(KnoUtil.ByteBuffer2DWord(bytes) > 0);
                infoMask.setDefValue(KnoUtil.ByteBuffer2String(bytes, 65));
                infoMask.setHasTesauro(KnoUtil.ByteBuffer2DWord(bytes) > 0);
                infoMask.setPathTesauro(KnoUtil.ByteBuffer2String(bytes, 261));
                KnoUtil.ByteBuffer2ByteArray(bytes, 7);
                knoDBField.setInfo(infoMask);
                break;
            }
            case 5: {
                KnoDBFieldInfoAutomatic infoAuto = new KnoDBFieldInfoAutomatic();
                infoAuto.setPrefix(KnoUtil.ByteBuffer2String(bytes, 65));
                infoAuto.setSuffix(KnoUtil.ByteBuffer2String(bytes, 65));
                infoAuto.setAutoType(KnoUtil.ByteBuffer2DWord(bytes));
                infoAuto.setFormatView(KnoUtil.ByteBuffer2String(bytes, 65));
                infoAuto.setIntegerDigits(KnoUtil.ByteBuffer2Word(bytes));
                infoAuto.setIntegerPadding(KnoUtil.ByteBuffer2Char(bytes));
                infoAuto.setCounter(KnoUtil.ByteBuffer2DWord(bytes));
                infoAuto.setCounterInc(KnoUtil.ByteBuffer2Word(bytes));
                infoAuto.setAutoAsign(KnoUtil.ByteBuffer2DWord(bytes));
                infoAuto.setInfAsignedVal(KnoUtil.ByteBuffer2DWord(bytes) > 0);
                infoAuto.setActUpdates(KnoUtil.ByteBuffer2DWord(bytes) > 0);
                KnoUtil.ByteBuffer2ByteArray(bytes, 186);
                knoDBField.setInfo(infoAuto);
                break;
            }
            case 6: {
                KnoDBFieldInfoURL infoURL = new KnoDBFieldInfoURL();
                infoURL.setType(KnoUtil.ByteBuffer2DWord(bytes));
                infoURL.setUrl(KnoUtil.ByteBuffer2String(bytes, 261));
                KnoUtil.ByteBuffer2ByteArray(bytes, 141);
                knoDBField.setInfo(infoURL);
                break;
            }
            default: {
                KnoUtil.ByteBuffer2ByteArray(bytes, 406);
            }
        }
        knoDBField.setLastCode(KnoUtil.ByteBuffer2Byte(bytes));
        knoDBField.setReservedObj(KnoUtil.ByteBuffer2ByteArray(bytes, 21));
        knoDBField.setHTexto(KnoUtil.ByteBuffer2DWord(bytes));
        knoDBField.setDwTamCmp(KnoUtil.ByteBuffer2DWord(bytes));
        knoDBField.setChildNum(KnoUtil.ByteBuffer2Word(bytes));
        return knoDBField;
    }

    private void writeKnoDBField(KnoDBField knoDBField) throws Exception {
        ByteBuffer bytes = ByteBuffer.allocate(1075);
        bytes.order(ByteOrder.LITTLE_ENDIAN);
        bytes.putShort((short)knoDBField.getOrdNum());
        bytes.put(knoDBField.getHashCode());
        KnoUtil.putString(bytes, knoDBField.getFieldKnoW(), 37);
        KnoUtil.putString(bytes, knoDBField.getFieldName(), 19);
        KnoUtil.putString(bytes, knoDBField.getTagName(), 19);
        KnoUtil.putString(bytes, knoDBField.getDescription(), 81);
        bytes.put(knoDBField.getFieldType());
        bytes.putInt(knoDBField.getRequired() ? 1 : 0);
        KnoDBStyle knoDBStyle = knoDBField.getStyle();
        KnoUtil.putString(bytes, knoDBStyle.getFontName(), 129);
        bytes.putShort(knoDBStyle.getSize());
        bytes.putShort((short)knoDBStyle.getAttrib());
        bytes.putInt(KnoUtil.colorToInt(knoDBStyle.getBackColor()));
        bytes.putInt(KnoUtil.colorToInt(knoDBStyle.getForeColor()));
        bytes.putInt(knoDBStyle.getShading());
        bytes.put(knoDBStyle.getAlign());
        bytes.putInt(knoDBStyle.getIndented());
        bytes.putInt(knoDBStyle.getLeftMrg());
        bytes.putInt(knoDBStyle.getRightMrg());
        bytes.putInt(knoDBStyle.getSpaceBefore());
        bytes.putInt(knoDBStyle.getSpaceBetween());
        bytes.putInt(knoDBStyle.getSpaceAfter());
        KnoDBIndexing knoDBIndexing = knoDBField.getIndexing();
        bytes.put((byte)knoDBIndexing.getFlagsIdx());
        bytes.put(knoDBIndexing.getSeparators());
        bytes.putInt(knoDBIndexing.getFilter());
        bytes.put(knoDBIndexing.getSFilter());
        switch (knoDBField.getFieldType()) {
            case 1: {
                KnoDBFieldInfoText infoText = (KnoDBFieldInfoText)knoDBField.getInfo();
                bytes.putInt(infoText.getHasDefValue() ? 1 : 0);
                KnoUtil.putString(bytes, infoText.getDefValue(), 65);
                bytes.putInt(infoText.getHasAdmitidos() ? 1 : 0);
                bytes.putInt(infoText.getNumAdmitidos());
                KnoUtil.putString(bytes, infoText.getSeparators(), 33);
                bytes.putInt(infoText.getHasTesauro() ? 1 : 0);
                KnoUtil.putString(bytes, infoText.getPathTesauro(), 261);
                KnoUtil.putString(bytes, "", 31);
                break;
            }
            case 2: {
                KnoDBFieldInfoNumber infoNumber = (KnoDBFieldInfoNumber)knoDBField.getInfo();
                bytes.putShort(infoNumber.getIntegerDigits());
                bytes.put(infoNumber.getIntegerPadding());
                bytes.putShort(infoNumber.getDecimalDigits());
                bytes.put(infoNumber.getDecimalPadding());
                bytes.putInt(infoNumber.isPointThousand() ? 1 : 0);
                bytes.put(infoNumber.getNumberSign());
                bytes.putInt(infoNumber.getHasDefValue() ? 1 : 0);
                KnoUtil.putString(bytes, infoNumber.getDefValue(), 25);
                bytes.putInt(infoNumber.getHasTesauro() ? 1 : 0);
                KnoUtil.putString(bytes, infoNumber.getPathTesauro(), 261);
                KnoUtil.putString(bytes, "", 101);
                break;
            }
            case 3: {
                KnoDBFieldInfoDate infoDate = (KnoDBFieldInfoDate)knoDBField.getInfo();
                KnoUtil.putString(bytes, infoDate.getFormatView(), 65);
                bytes.putInt(infoDate.getHasDefValue() ? 1 : 0);
                bytes.putInt(infoDate.getDefType());
                KnoUtil.putString(bytes, infoDate.getDefOther(), 65);
                bytes.putInt(infoDate.getHasTesauro() ? 1 : 0);
                KnoUtil.putString(bytes, infoDate.getPathTesauro(), 261);
                KnoUtil.putString(bytes, "", 3);
                break;
            }
            case 4: {
                KnoDBFieldInfoMask infoMask = (KnoDBFieldInfoMask)knoDBField.getInfo();
                KnoUtil.putString(bytes, infoMask.getMask(), 65);
                bytes.putInt(infoMask.getHasDefValue() ? 1 : 0);
                KnoUtil.putString(bytes, infoMask.getDefValue(), 65);
                bytes.putInt(infoMask.getHasTesauro() ? 1 : 0);
                KnoUtil.putString(bytes, infoMask.getPathTesauro(), 261);
                KnoUtil.putString(bytes, "", 7);
                break;
            }
            case 5: {
                KnoDBFieldInfoAutomatic infoAuto = (KnoDBFieldInfoAutomatic)knoDBField.getInfo();
                KnoUtil.putString(bytes, infoAuto.getPrefix(), 65);
                KnoUtil.putString(bytes, infoAuto.getSuffix(), 65);
                bytes.putInt(infoAuto.getAutoType());
                KnoUtil.putString(bytes, infoAuto.getFormatView(), 65);
                bytes.putShort((short)infoAuto.getIntegerDigits());
                bytes.put((byte)infoAuto.getIntegerPadding());
                bytes.putInt(infoAuto.getCounter());
                bytes.putShort((short)infoAuto.getCounterInc());
                bytes.putInt(infoAuto.getAutoAsign());
                bytes.putInt(infoAuto.getInfAsignedVal() ? 1 : 0);
                bytes.putInt(infoAuto.getActUpdates() ? 1 : 0);
                KnoUtil.putString(bytes, "", 186);
                break;
            }
            case 6: {
                KnoDBFieldInfoURL infoURL = (KnoDBFieldInfoURL)knoDBField.getInfo();
                bytes.putInt(infoURL.getType());
                KnoUtil.putString(bytes, infoURL.getUrl(), 261);
                KnoUtil.putString(bytes, "", 141);
                break;
            }
            default: {
                KnoUtil.putString(bytes, "", 406);
            }
        }
        bytes.put(knoDBField.getLastCode());
        bytes.put(knoDBField.getReservedObj());
        bytes.putInt(knoDBField.getHTexto());
        bytes.putInt(knoDBField.getDwTamCmp());
        bytes.putShort(knoDBField.getChildNum());
        this.remote.out.writeBytes(new String(bytes.array()));
    }

    protected Vector getFieldsList() throws ExceptionKnoDataBase {
        Vector<String> fields = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getFiledsList.");
        }
        try {
            int orden = 342;
            int count = 0;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.getHandle());
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0) {
                int numCmps = remote.in.readInt();
                fields = new Vector<String>(numCmps);
                int n = 0;
                while (n < numCmps) {
                    count = remote.in.readInt();
                    if (count > 0) {
                        byte[] field = new byte[count];
                        remote.in.read(field);
                        fields.addElement(new String(field));
                    }
                    ++n;
                }
            }
        }
        catch (IOException e) {
            if (fields != null) {
                fields.removeAllElements();
            }
            fields = null;
            lastError = 2;
            throw new ExceptionKnoDataBase("Unavailable server (2) getFieldsList: " + e.getMessage());
        }
        catch (Exception e) {
            if (fields != null) {
                fields.removeAllElements();
            }
            fields = null;
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database (2) getFieldsList: " + e.getMessage());
        }
        return fields;
    }

    protected char getHandle() {
        return this.handle;
    }

    protected Vector<String> getIndexFieldsList() throws ExceptionKnoDataBase {
        Vector<String> fields = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getIndexFieldsList.");
        }
        try {
            int orden = 343;
            int count = 0;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.getHandle());
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0) {
                int numCmps = remote.in.readInt();
                fields = new Vector<String>(numCmps);
                int n = 0;
                while (n < numCmps) {
                    count = remote.in.readInt();
                    if (count > 0) {
                        byte[] field = new byte[count];
                        remote.in.read(field);
                        fields.addElement(new String(field));
                    }
                    ++n;
                }
            }
        }
        catch (IOException e) {
            if (fields != null) {
                fields.removeAllElements();
            }
            fields = null;
            lastError = 2;
            throw new ExceptionKnoDataBase("Unavailable server (2) getIndexFieldsList: " + e.getMessage());
        }
        catch (Exception e) {
            if (fields != null) {
                fields.removeAllElements();
            }
            fields = null;
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database (2) getIndexFieldsList: " + e.getMessage());
        }
        return fields;
    }

    protected static int getLastError() {
        return lastError;
    }

    protected byte[] getLinkedObject(String name, char page, byte typeTrans) throws ExceptionKnoDataBase {
        byte[] ba;
        block10: {
            ba = null;
            if (this.remote == null) {
                throw new ExceptionKnoDataBase("Unavailable server (1) getLinkedObject.");
            }
            if (this.handle == '\uffff') {
                throw new ExceptionKnoDataBase("Unavailable dataBase (1) getLinkedObject.");
            }
            try {
                int orden = 345;
                int count = 0;
                this.remote.out.writeChar(orden);
                this.remote.out.writeChar(this.getHandle());
                count = name.length();
                this.remote.out.writeInt(count);
                if (count > 0) {
                    this.remote.out.writeBytes(name);
                }
                this.remote.out.writeChar(page);
                this.remote.out.writeByte(typeTrans);
                this.remote.out.flush();
                lastError = this.remote.in.readChar();
                if (lastError != 0) break block10;
                int nLen = this.remote.in.readInt();
                if (nLen == 0) {
                    lastError = 32769;
                    break block10;
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int readBytes = KnoSupport.readInput(baos, this.remote.in, nLen);
                if (readBytes == -1 || readBytes < nLen) {
                    lastError = 8;
                    break block10;
                }
                return baos.toByteArray();
            }
            catch (IOException e) {
                ba = null;
                if (lastError == 0) {
                    lastError = 2;
                }
                throw new ExceptionKnoDataBase("Unavailable server (2) getLinkedObject: " + e.getMessage());
            }
            catch (Exception e) {
                ba = null;
                if (lastError == 0) {
                    lastError = 8;
                }
                throw new ExceptionKnoDataBase("Unavailable dataBase (2) getLinkedObject: " + e.getMessage());
            }
        }
        return ba;
    }

    protected void getLinkedObject(OutputStream out, String name, char page, byte typeTrans) throws ExceptionKnoDataBase {
        if (this.remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getLinkedObject.");
        }
        if (this.handle == '\uffff') {
            throw new ExceptionKnoDataBase("Unavailable dataBase (1) getLinkedObject.");
        }
        try {
            int orden = 345;
            int count = 0;
            this.remote.out.writeChar(orden);
            this.remote.out.writeChar(this.getHandle());
            count = name.length();
            this.remote.out.writeInt(count);
            if (count > 0) {
                this.remote.out.writeBytes(name);
            }
            this.remote.out.writeChar(page);
            this.remote.out.writeByte(typeTrans);
            this.remote.out.flush();
            lastError = this.remote.in.readChar();
            if (lastError == 0) {
                int nLen = this.remote.in.readInt();
                if (nLen == 0) {
                    lastError = 32769;
                    throw new ExceptionKnoDataBase("Unavailable linked object: size " + nLen + " bytes");
                }
                int readBytes = KnoSupport.readInput(out, this.remote.in, nLen);
                if (readBytes == -1 || readBytes < nLen) {
                    lastError = 32881;
                    throw new ExceptionKnoDataBase("Unavailable linked object: read " + readBytes + " bytes of " + nLen);
                }
            }
        }
        catch (IOException e) {
            if (lastError == 0) {
                lastError = 2;
            }
            throw new ExceptionKnoDataBase("Unavailable server (2) getLinkedObject: " + e.getMessage());
        }
        catch (Exception e) {
            if (lastError == 0) {
                lastError = 8;
            }
            throw new ExceptionKnoDataBase("Unavailable dataBase (2) getLinkedObject: " + e.getMessage());
        }
    }

    protected byte[] getLinkedObject2(String name, char page, byte typeTrans) throws ExceptionKnoDataBase {
        byte[] ba;
        block10: {
            ba = null;
            if (this.remote == null) {
                throw new ExceptionKnoDataBase("Unavailable server (1) getLinkedObject.");
            }
            if (this.handle == '\uffff') {
                throw new ExceptionKnoDataBase("Unavailable dataBase (1) getLinkedObject.");
            }
            try {
                int orden = 378;
                int count = 0;
                this.remote.out.writeChar(orden);
                this.remote.out.writeChar(this.getHandle());
                count = name.length();
                this.remote.out.writeInt(count);
                if (count > 0) {
                    this.remote.out.writeBytes(name);
                }
                this.remote.out.writeChar(page);
                this.remote.out.writeByte(typeTrans);
                this.remote.out.flush();
                lastError = this.remote.in.readChar();
                if (lastError != 0) break block10;
                int nLen = this.remote.in.readInt();
                if (nLen == 0) {
                    lastError = 32769;
                    break block10;
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int readBytes = KnoSupport.readInput2(baos, this.remote.in, nLen);
                if (readBytes == -1 || readBytes < nLen) {
                    lastError = 8;
                    break block10;
                }
                return baos.toByteArray();
            }
            catch (IOException e) {
                ba = null;
                if (lastError == 0) {
                    lastError = 2;
                }
                throw new ExceptionKnoDataBase("Unavailable server (2) getLinkedObject: " + e.getMessage());
            }
            catch (Exception e) {
                ba = null;
                if (lastError == 0) {
                    lastError = 8;
                }
                throw new ExceptionKnoDataBase("Unavailable dataBase (2) getLinkedObject: " + e.getMessage());
            }
        }
        return ba;
    }

    protected int getLinkedObject3(String name, char page, byte typeTrans) throws ExceptionKnoDataBase {
        int tam = 0;
        if (this.remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getLinkedObject.");
        }
        if (this.handle == '\uffff') {
            throw new ExceptionKnoDataBase("Unavailable dataBase (1) getLinkedObject.");
        }
        try {
            int orden = 382;
            int count = 0;
            this.remote.out.writeChar(orden);
            this.remote.out.writeChar(this.getHandle());
            count = name.length();
            this.remote.out.writeInt(count);
            if (count > 0) {
                this.remote.out.writeBytes(name);
            }
            this.remote.out.writeChar(page);
            this.remote.out.writeByte(typeTrans);
            this.remote.out.flush();
            lastError = this.remote.in.readChar();
            if (lastError == 0) {
                tam = this.remote.in.readInt();
            }
        }
        catch (IOException e) {
            if (lastError == 0) {
                lastError = 2;
            }
            throw new ExceptionKnoDataBase("Unavailable server (2) getLinkedObject: " + e.getMessage());
        }
        catch (Exception e) {
            if (lastError == 0) {
                lastError = 8;
            }
            throw new ExceptionKnoDataBase("Unavailable dataBase (2) getLinkedObject: " + e.getMessage());
        }
        return tam;
    }

    protected byte[] getLinkedObjectPar(String name, int iPos, int iTam) throws ExceptionKnoDataBase {
        byte[] ba = null;
        if (this.remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getLinkedObject.");
        }
        if (this.handle == '\uffff') {
            throw new ExceptionKnoDataBase("Unavailable dataBase (1) getLinkedObject.");
        }
        try {
            int orden = 383;
            int count = 0;
            this.remote.out.writeChar(orden);
            this.remote.out.writeChar(this.getHandle());
            count = name.length();
            this.remote.out.writeInt(count);
            if (count > 0) {
                this.remote.out.writeBytes(name);
            }
            this.remote.out.writeInt(iPos);
            this.remote.out.writeInt(iTam);
            this.remote.out.flush();
            lastError = this.remote.in.readChar();
            if (lastError == 0) {
                this.remote.in.readInt();
                iTam = this.remote.in.readInt();
                if (iTam > 0) {
                    ba = new byte[iTam];
                    this.remote.in.read(ba, false);
                }
            }
        }
        catch (IOException e) {
            ba = null;
            if (lastError == 0) {
                lastError = 2;
            }
            throw new ExceptionKnoDataBase("Unavailable server (2) getLinkedObject: " + e.getMessage());
        }
        catch (Exception e) {
            ba = null;
            if (lastError == 0) {
                lastError = 8;
            }
            throw new ExceptionKnoDataBase("Unavailable dataBase (2) getLinkedObject: " + e.getMessage());
        }
        return ba;
    }

    protected byte[] getObjectContent(String name, byte typeTrans) throws ExceptionKnoDataBase {
        byte[] ba = null;
        if (this.remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getObjectContent.");
        }
        if (this.handle == '\uffff') {
            throw new ExceptionKnoDataBase("Unavailable dataBase (1) getObjectContent.");
        }
        try {
            int orden = 397;
            int count = 0;
            this.remote.out.writeChar(orden);
            this.remote.out.writeChar(this.getHandle());
            count = name.length();
            this.remote.out.writeInt(count);
            if (count > 0) {
                this.remote.out.writeBytes(name);
            }
            this.remote.out.writeByte(typeTrans);
            this.remote.out.flush();
            lastError = this.remote.in.readChar();
            if (lastError != 0) {
                ba = null;
            } else {
                int nLen = this.remote.in.readInt();
                ba = new byte[nLen];
                this.remote.in.read(ba, false);
                if (ba.length < nLen) {
                    ba = null;
                    lastError = 8;
                }
            }
        }
        catch (IOException e) {
            ba = null;
            if (lastError == 0) {
                lastError = 2;
            }
            throw new ExceptionKnoDataBase("Unavailable server (2) getObjectContent: " + e.getMessage());
        }
        catch (Exception e) {
            ba = null;
            if (lastError == 0) {
                lastError = 8;
            }
            throw new ExceptionKnoDataBase("Unavailable dataBase (2) getObjectContent: " + e.getMessage());
        }
        return ba;
    }

    protected int setLinkedObject(String name) throws ExceptionKnoDataBase {
        if (this.remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getLinkedObject.");
        }
        if (this.handle == '\uffff') {
            throw new ExceptionKnoDataBase("Unavailable dataBase (1) getLinkedObject.");
        }
        try {
            int orden = 346;
            int count = 0;
            int iTam = 0;
            this.remote.out.writeChar(orden);
            this.remote.out.writeChar(this.getHandle());
            count = name.length();
            this.remote.out.writeInt(count);
            if (count > 0) {
                this.remote.out.writeBytes(name);
            }
            this.remote.out.writeInt(iTam);
            this.remote.out.flush();
            lastError = this.remote.in.readChar();
        }
        catch (IOException e) {
            if (lastError == 0) {
                lastError = 2;
            }
            throw new ExceptionKnoDataBase("Unavailable server (2) getLinkedObject: " + e.getMessage());
        }
        catch (Exception e) {
            if (lastError == 0) {
                lastError = 8;
            }
            throw new ExceptionKnoDataBase("Unavailable dataBase (2) getLinkedObject: " + e.getMessage());
        }
        return lastError;
    }

    protected int setLinkedObjectPar(String name, int iPos, int iTam, byte[] ba) throws ExceptionKnoDataBase {
        if (this.remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getLinkedObject.");
        }
        if (this.handle == '\uffff') {
            throw new ExceptionKnoDataBase("Unavailable dataBase (1) getLinkedObject.");
        }
        try {
            int orden = 384;
            int count = 0;
            this.remote.out.writeChar(orden);
            this.remote.out.writeChar(this.getHandle());
            count = name.length();
            this.remote.out.writeInt(count);
            if (count > 0) {
                this.remote.out.writeBytes(name);
            }
            this.remote.out.writeInt(iPos);
            this.remote.out.writeInt(iTam);
            if (iTam > 0) {
                this.remote.out.write(ba, 0, iTam);
            }
            this.remote.out.flush();
            lastError = this.remote.in.readChar();
            if (lastError == 0) {
                iTam = this.remote.in.readInt();
            }
        }
        catch (IOException e) {
            ba = null;
            if (lastError == 0) {
                lastError = 2;
            }
            throw new ExceptionKnoDataBase("Unavailable server (2) getLinkedObject: " + e.getMessage());
        }
        catch (Exception e) {
            ba = null;
            if (lastError == 0) {
                lastError = 8;
            }
            throw new ExceptionKnoDataBase("Unavailable dataBase (2) getLinkedObject: " + e.getMessage());
        }
        return iTam;
    }

    protected int removeObject(String name) throws ExceptionKnoDataBase {
        if (this.remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) removeObject.");
        }
        if (this.handle == '\uffff') {
            throw new ExceptionKnoDataBase("Unavailable dataBase (1) removeObject.");
        }
        try {
            int orden = 1300;
            int count = 0;
            this.remote.out.writeChar(orden);
            this.remote.out.writeChar(this.getHandle());
            count = name.length();
            this.remote.out.writeInt(count);
            if (count > 0) {
                this.remote.out.writeBytes(name);
            }
            this.remote.out.flush();
            lastError = this.remote.in.readChar();
        }
        catch (IOException e) {
            if (lastError == 0) {
                lastError = 2;
            }
            throw new ExceptionKnoDataBase("Unavailable server (2) removeObject: " + e.getMessage());
        }
        catch (Exception e) {
            if (lastError == 0) {
                lastError = 8;
            }
            throw new ExceptionKnoDataBase("Unavailable dataBase (2) removeObject: " + e.getMessage());
        }
        return lastError;
    }

    protected int removeUnlinkedObject(String name) throws ExceptionKnoDataBase {
        if (this.remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) removeObject.");
        }
        if (this.handle == '\uffff') {
            throw new ExceptionKnoDataBase("Unavailable dataBase (1) removeObject.");
        }
        try {
            int orden = 1332;
            int count = 0;
            this.remote.out.writeChar(orden);
            this.remote.out.writeChar(this.getHandle());
            count = name.length();
            this.remote.out.writeInt(count);
            if (count > 0) {
                this.remote.out.writeBytes(name);
            }
            this.remote.out.flush();
            lastError = this.remote.in.readChar();
        }
        catch (IOException e) {
            if (lastError == 0) {
                lastError = 2;
            }
            throw new ExceptionKnoDataBase("Unavailable server (2) removeObject: " + e.getMessage());
        }
        catch (Exception e) {
            if (lastError == 0) {
                lastError = 8;
            }
            throw new ExceptionKnoDataBase("Unavailable dataBase (2) removeObject: " + e.getMessage());
        }
        return lastError;
    }

    protected int removeUnlinkedObjectsDoc(int numdoc, int isLog) throws ExceptionKnoDataBase {
        if (this.remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) removeObject.");
        }
        if (this.handle == '\uffff') {
            throw new ExceptionKnoDataBase("Unavailable dataBase (1) removeObject.");
        }
        try {
            int orden = 1333;
            boolean count = false;
            this.remote.out.writeChar(orden);
            this.remote.out.writeChar(this.getHandle());
            this.remote.out.writeInt(numdoc);
            this.remote.out.writeInt(isLog);
            this.remote.out.flush();
            lastError = this.remote.in.readChar();
        }
        catch (IOException e) {
            if (lastError == 0) {
                lastError = 2;
            }
            throw new ExceptionKnoDataBase("Unavailable server (2) removeObject: " + e.getMessage());
        }
        catch (Exception e) {
            if (lastError == 0) {
                lastError = 8;
            }
            throw new ExceptionKnoDataBase("Unavailable dataBase (2) removeObject: " + e.getMessage());
        }
        return lastError;
    }

    public byte[] getBuffer(int nTam) throws ExceptionKnoDataBase {
        byte[] ba = null;
        if (this.remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getBuffer.");
        }
        if (this.handle == '\uffff') {
            throw new ExceptionKnoDataBase("Unavailable dataBase (1) getBuffer.");
        }
        try {
            if (nTam > 0) {
                ba = new byte[nTam];
                this.remote.in.read(ba, false);
            }
        }
        catch (Exception e) {
            ba = null;
            if (lastError == 0) {
                lastError = 8;
            }
            throw new ExceptionKnoDataBase("Unavailable dataBase (2) getBuffer: " + e.getMessage());
        }
        return ba;
    }

    protected byte[] getFullNameObject(String dbName, String path, String name) throws ExceptionKnoDataBase {
        byte[] fullpath = null;
        if (this.remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getFullNameObject.");
        }
        if (this.handle == '\uffff') {
            throw new ExceptionKnoDataBase("Unavailable dataBase (1) getFullNameObject.");
        }
        try {
            int orden = 377;
            int count = 0;
            this.remote.out.writeChar(orden);
            this.remote.out.writeChar(this.getHandle());
            count = path.length();
            this.remote.out.writeInt(count);
            if (count > 0) {
                this.remote.out.writeBytes(path);
            }
            count = name.length();
            this.remote.out.writeChar((char)count);
            if (count > 0) {
                this.remote.out.writeBytes(name);
            }
            this.remote.out.flush();
            lastError = this.remote.in.readChar();
            if (lastError != 0) {
                fullpath = null;
            } else {
                count = this.remote.in.readInt();
                if (count > 0) {
                    fullpath = new byte[count];
                    this.remote.in.read(fullpath);
                } else {
                    fullpath = null;
                    lastError = 8;
                }
            }
        }
        catch (IOException e) {
            fullpath = null;
            if (lastError == 0) {
                lastError = 2;
            }
            throw new ExceptionKnoDataBase("Unavailable server (2) getFullNameObject: " + e.getMessage());
        }
        catch (Exception e) {
            fullpath = null;
            if (lastError == 0) {
                lastError = 8;
            }
            throw new ExceptionKnoDataBase("Unavailable dataBase (2) getFullNameObject: " + e.getMessage());
        }
        return fullpath;
    }

    protected Integer newXmlDocument(String xml, int iForzar) throws ExceptionKnoDataBase, ExceptionKnoRemote {
        Integer numDoc = null;
        if (this.remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) newXmlDocument.");
        }
        if (this.handle == '\uffffffff') {
            throw new ExceptionKnoDataBase("Unavailable database (1) newXmlDocument.");
        }
        try {
            if (xml != null) {
                int orden = 355;
                this.remote.out.writeChar(orden);
                this.remote.out.writeChar(this.handle);
                int count = xml.length();
                this.remote.out.writeInt(count);
                if (count > 0) {
                    this.remote.out.writeBytes(xml);
                }
                this.remote.out.writeInt(iForzar);
                this.remote.out.flush();
                lastError = this.remote.in.readChar();
                if (lastError == 0) {
                    numDoc = new Integer(this.remote.in.readInt());
                }
            }
        }
        catch (IOException e) {
            numDoc = null;
            if (lastError == 0) {
                lastError = 2;
            }
            throw new ExceptionKnoDataBase("Unavailable server (2) newXmlDocument: " + e.getMessage());
        }
        catch (Exception e) {
            numDoc = null;
            if (lastError == 0) {
                lastError = 8;
            }
            throw new ExceptionKnoDataBase("Unavailable database (2) newXmlDocument: " + e.getMessage());
        }
        return numDoc;
    }

    protected Integer newXmlDocument2(byte[] xml, int iForzar) throws ExceptionKnoDataBase, ExceptionKnoRemote {
        Integer numDoc = null;
        if (this.remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) newXmlDocument2.");
        }
        if (this.handle == '\uffffffff') {
            throw new ExceptionKnoDataBase("Unavailable database (1) newXmlDocument2.");
        }
        try {
            if (xml != null) {
                int orden = 355;
                this.remote.out.writeChar(orden);
                this.remote.out.writeChar(this.handle);
                int count = xml.length;
                this.remote.out.writeInt(count);
                if (count > 0) {
                    this.remote.out.write(xml);
                }
                this.remote.out.flush();
                this.remote.out.writeInt(iForzar);
                this.remote.out.flush();
                lastError = this.remote.in.readChar();
                if (lastError == 0) {
                    numDoc = new Integer(this.remote.in.readInt());
                }
            }
        }
        catch (IOException e) {
            numDoc = null;
            if (lastError == 0) {
                lastError = 2;
            }
            throw new ExceptionKnoDataBase("Unavailable server (2) newXmlDocument2: " + e.getMessage());
        }
        catch (Exception e) {
            numDoc = null;
            if (lastError == 0) {
                lastError = 8;
            }
            throw new ExceptionKnoDataBase("Unavailable database (2) newXmlDocument2: " + e.getMessage());
        }
        return numDoc;
    }

    protected Vector getFieldsError() throws ExceptionKnoDataBase, ExceptionKnoRemote {
        Vector<KnoFieldError> fieldsError = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getFieldsError.");
        }
        try {
            KnoFieldError fieldError;
            int numError = remote.in.readInt();
            fieldsError = new Vector<KnoFieldError>(numError);
            int n = 0;
            while (n < numError) {
                fieldError = new KnoFieldError();
                fieldError.bHashCode = remote.in.readByte();
                fieldError.iError = remote.in.readChar();
                fieldError.FieldInfo = null;
                int count = remote.in.readInt();
                if (count > 0) {
                    byte[] field = new byte[count];
                    remote.in.read(field);
                    fieldError.FieldInfo = new String(field);
                }
                fieldsError.addElement(fieldError);
                ++n;
            }
            n = 0;
            while (n < numError) {
                fieldError = (KnoFieldError)fieldsError.get(n);
                KnoFieldInfo fieldInfo = this.getDBFieldInfo(fieldError.getHashCode());
                fieldError.setFieldName(fieldInfo.getFieldName());
                fieldError.setFieldTag(fieldInfo.getFieldTag());
                System.out.println("Campo: " + fieldInfo.getFieldName() + ". Error: " + fieldError.getFieldError());
                ++n;
            }
        }
        catch (IOException e) {
            if (fieldsError != null) {
                fieldsError.removeAllElements();
            }
            fieldsError = null;
            lastError = 2;
            throw new ExceptionKnoDataBase("Unavailable server (2) getFieldsError: " + e.getMessage());
        }
        catch (Exception e) {
            if (fieldsError != null) {
                fieldsError.removeAllElements();
            }
            fieldsError = null;
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database (2) getFieldsError: " + e.getMessage());
        }
        return fieldsError;
    }

    protected int getNumDocByID(String id) throws ExceptionKnoDataBase, ExceptionKnoRemote {
        int numDoc = -1;
        if (this.remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getNumDocByID.");
        }
        if (this.handle == '\uffffffff') {
            throw new ExceptionKnoDataBase("Unavailable database (1) getNumDocByID.");
        }
        try {
            int orden = 324;
            this.remote.out.writeChar(orden);
            this.remote.out.writeChar(this.handle);
            int count = id.length();
            this.remote.out.writeChar((char)count);
            if (count > 0) {
                this.remote.out.writeBytes(id);
            }
            this.remote.out.flush();
            lastError = this.remote.in.readChar();
            if (lastError == 0) {
                numDoc = this.remote.in.readInt();
            }
        }
        catch (IOException e) {
            numDoc = -1;
            if (lastError == 0) {
                lastError = 2;
            }
            throw new ExceptionKnoDataBase("Unavailable server (2) getNumDocByID: " + e.getMessage());
        }
        catch (Exception e) {
            numDoc = -1;
            if (lastError == 0) {
                lastError = 8;
            }
            throw new ExceptionKnoDataBase("Unavailable database (2) getNumDocByID: " + e.getMessage());
        }
        return numDoc;
    }

    protected String getIdByNumDoc(int numDoc) throws ExceptionKnoDataBase, ExceptionKnoRemote {
        String id = null;
        if (this.remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server getIdByNumDoc.");
        }
        if (this.handle == '\uffffffff') {
            throw new ExceptionKnoDataBase("Unavailable database getIdByNumDoc.");
        }
        try {
            char count;
            int orden = 1310;
            this.remote.out.writeChar(orden);
            this.remote.out.writeChar(this.handle);
            this.remote.out.writeInt(numDoc);
            this.remote.out.flush();
            lastError = this.remote.in.readChar();
            if (lastError == 0 && (count = this.remote.in.readChar()) > '\u0000') {
                byte[] b = new byte[count];
                this.remote.in.read(b);
                id = new String(b).trim();
            }
        }
        catch (IOException e) {
            numDoc = -1;
            if (lastError == 0) {
                lastError = 2;
            }
            throw new ExceptionKnoDataBase("Unavailable server (2) getNumDocByID: " + e.getMessage());
        }
        catch (Exception e) {
            numDoc = -1;
            if (lastError == 0) {
                lastError = 8;
            }
            throw new ExceptionKnoDataBase("Unavailable database (2) getNumDocByID: " + e.getMessage());
        }
        return id;
    }

    protected int getNumDocs() throws ExceptionKnoRemote, ExceptionKnoDataBase {
        int numDocs = 0;
        if (this.remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getNumDocs.");
        }
        if (this.handle == '\uffffffff') {
            throw new ExceptionKnoDataBase("Unavailable database (1) getNumDocs.");
        }
        try {
            int orden = 271;
            this.remote.out.writeChar(orden);
            this.remote.out.writeChar(this.handle);
            this.remote.out.flush();
            lastError = this.remote.in.readChar();
            if (lastError == 0) {
                numDocs = this.remote.in.readInt();
            }
        }
        catch (IOException e) {
            numDocs = 0;
            if (lastError == 0) {
                lastError = 2;
            }
            throw new ExceptionKnoDataBase("Unavailable server (2) getNumDocs: " + e.getMessage());
        }
        catch (Exception e) {
            numDocs = 0;
            if (lastError == 0) {
                lastError = 8;
            }
            throw new ExceptionKnoDataBase("Unavailable database (2) getNumDocs: " + e.getMessage());
        }
        return numDocs;
    }

    protected void removeDocument(int numDoc) throws ExceptionKnoRemote, ExceptionKnoDataBase {
        if (this.remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) removeDocument.");
        }
        if (this.handle == '\uffffffff') {
            throw new ExceptionKnoDataBase("Unavailable database (1) removeDocument.");
        }
        try {
            int orden = 254;
            this.remote.out.writeChar(orden);
            this.remote.out.writeChar(this.handle);
            this.remote.out.writeInt(numDoc);
            this.remote.out.writeInt(1);
            this.remote.out.flush();
            lastError = this.remote.in.readChar();
        }
        catch (IOException e) {
            if (lastError == 0) {
                lastError = 2;
            }
            throw new ExceptionKnoDataBase("Unavailable server (2) removeDocument: " + e.getMessage());
        }
        catch (Exception e) {
            if (lastError == 0) {
                lastError = 8;
            }
            throw new ExceptionKnoDataBase("Unavailable database (2) removeDocument: " + e.getMessage());
        }
    }

    protected void undeleteDocument(int numDoc) throws ExceptionKnoRemote, ExceptionKnoDataBase {
        this.undeleteDocument(numDoc, false);
    }

    protected void undeleteDocument(int numDoc, boolean physicalId) throws ExceptionKnoRemote, ExceptionKnoDataBase {
        if (this.remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) undeleteDocument.");
        }
        if (this.handle == '\uffffffff') {
            throw new ExceptionKnoDataBase("Unavailable database (1) undeleteDocument.");
        }
        try {
            if (physicalId) {
                this.remote.out.writeChar(359);
            } else {
                this.remote.out.writeChar(321);
            }
            this.remote.out.writeChar(this.handle);
            this.remote.out.writeInt(numDoc);
            if (physicalId) {
                this.remote.out.writeInt(1);
            } else {
                this.remote.out.writeInt(2);
            }
            this.remote.out.flush();
            lastError = this.remote.in.readChar();
        }
        catch (IOException e) {
            if (lastError == 0) {
                lastError = 2;
            }
            throw new ExceptionKnoDataBase("Unavailable server (2) undeleteDocument: " + e.getMessage());
        }
        catch (Exception e) {
            if (lastError == 0) {
                lastError = 8;
            }
            throw new ExceptionKnoDataBase("Unavailable database (2) undeleteDocument: " + e.getMessage());
        }
    }

    protected boolean isDocumentDeleted(int numDoc, boolean physicalId) throws ExceptionKnoRemote, ExceptionKnoDataBase {
        if (this.remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) undeleteDocument.");
        }
        if (this.handle == '\uffffffff') {
            throw new ExceptionKnoDataBase("Unavailable database (1) undeleteDocument.");
        }
        boolean deleted = false;
        try {
            if (physicalId) {
                this.remote.out.writeChar(358);
            } else {
                this.remote.out.writeChar(317);
            }
            this.remote.out.writeChar(this.handle);
            this.remote.out.writeInt(numDoc);
            this.remote.out.flush();
            lastError = this.remote.in.readChar();
            if (lastError == 0) {
                int value = this.remote.in.readInt();
                deleted = value != 0;
            }
        }
        catch (IOException e) {
            if (lastError == 0) {
                lastError = 2;
            }
            throw new ExceptionKnoDataBase("Unavailable server (2) undeleteDocument: " + e.getMessage());
        }
        catch (Exception e) {
            if (lastError == 0) {
                lastError = 8;
            }
            throw new ExceptionKnoDataBase("Unavailable database (2) undeleteDocument: " + e.getMessage());
        }
        return deleted;
    }

    protected Vector getQueryFieldsList() throws ExceptionKnoDataBase {
        Vector<KnoFieldInfo> fields = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getQueryFieldsList.");
        }
        try {
            int orden = 350;
            int count = 0;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.getHandle());
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0) {
                int numCmps = remote.in.readInt();
                fields = new Vector<KnoFieldInfo>(numCmps);
                int n = 0;
                while (n < numCmps) {
                    int type;
                    byte adm;
                    KnoFieldInfo fieldInfo = new KnoFieldInfo();
                    fieldInfo.type = 0;
                    fieldInfo.hasDescriptors = false;
                    count = remote.in.readInt();
                    if (count > 0) {
                        byte[] field = new byte[count];
                        remote.in.read(field);
                        fieldInfo.fieldName = new String(field, "ISO-8859-1");
                    } else {
                        fieldInfo.fieldName = "";
                    }
                    count = remote.in.readInt();
                    if (count > 0) {
                        byte[] tag = new byte[count];
                        remote.in.read(tag);
                        fieldInfo.fieldTag = new String(tag);
                    } else {
                        fieldInfo.fieldTag = "";
                    }
                    count = remote.in.readInt();
                    if (count > 0) {
                        byte[] description = new byte[count];
                        remote.in.read(description);
                        fieldInfo.fieldDescription = new String(description, "ISO-8859-1");
                    } else {
                        fieldInfo.fieldDescription = "";
                    }
                    fieldInfo.admTerms = adm = remote.in.readByte();
                    fieldInfo.type = type = remote.in.readInt();
                    fields.addElement(fieldInfo);
                    ++n;
                }
            }
        }
        catch (IOException e) {
            if (fields != null) {
                fields.removeAllElements();
            }
            fields = null;
            lastError = 2;
            throw new ExceptionKnoDataBase("Unavailable server (2) getIndexFieldsList: " + e.getMessage());
        }
        catch (Exception e) {
            if (fields != null) {
                fields.removeAllElements();
            }
            fields = null;
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database (2) getIndexFieldsList: " + e.getMessage());
        }
        return fields;
    }

    protected KnoFieldInfo getDBFieldInfo(byte bHashCode) throws ExceptionKnoDataBase {
        KnoFieldInfo fieldInfo = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getDBFieldsList.");
        }
        try {
            int orden = 385;
            int count = 0;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.getHandle());
            remote.out.writeByte(bHashCode);
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0) {
                byte adm;
                fieldInfo = new KnoFieldInfo();
                fieldInfo.type = 0;
                fieldInfo.hasDescriptors = false;
                count = remote.in.readInt();
                if (count > 0) {
                    byte[] field = new byte[count];
                    remote.in.read(field);
                    fieldInfo.fieldName = new String(field);
                } else {
                    fieldInfo.fieldName = "";
                }
                count = remote.in.readInt();
                if (count > 0) {
                    byte[] tag = new byte[count];
                    remote.in.read(tag);
                    fieldInfo.fieldTag = new String(tag);
                } else {
                    fieldInfo.fieldTag = "";
                }
                count = remote.in.readInt();
                if (count > 0) {
                    byte[] description = new byte[count];
                    remote.in.read(description);
                    fieldInfo.fieldDescription = new String(description);
                } else {
                    fieldInfo.fieldDescription = "";
                }
                fieldInfo.admTerms = adm = remote.in.readByte();
            }
        }
        catch (IOException e) {
            lastError = 2;
            throw new ExceptionKnoDataBase("Unavailable server (2) getDBFieldsList: " + e.getMessage());
        }
        catch (Exception e) {
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database (2) getDBFieldsList: " + e.getMessage());
        }
        return fieldInfo;
    }

    protected Vector getDBFieldsList(String fmtName) throws ExceptionKnoDataBase {
        Vector<KnoFieldInfo> fields = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getDBFieldsList.");
        }
        try {
            int orden = 387;
            int count = 0;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.getHandle());
            count = fmtName.length();
            remote.out.writeInt(count);
            if (count > 0) {
                remote.out.writeBytes(fmtName);
            }
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0) {
                int numCmps = remote.in.readInt();
                fields = new Vector<KnoFieldInfo>(numCmps);
                int n = 0;
                while (n < numCmps) {
                    byte adm;
                    KnoFieldInfo fieldInfo = new KnoFieldInfo();
                    fieldInfo.type = 0;
                    fieldInfo.hasDescriptors = false;
                    count = remote.in.readInt();
                    if (count > 0) {
                        byte[] field = new byte[count];
                        remote.in.read(field);
                        fieldInfo.fieldName = new String(field);
                    } else {
                        fieldInfo.fieldName = "";
                    }
                    count = remote.in.readInt();
                    if (count > 0) {
                        byte[] tag = new byte[count];
                        remote.in.read(tag);
                        fieldInfo.fieldTag = new String(tag);
                    } else {
                        fieldInfo.fieldTag = "";
                    }
                    count = remote.in.readInt();
                    if (count > 0) {
                        byte[] description = new byte[count];
                        remote.in.read(description);
                        fieldInfo.fieldDescription = new String(description);
                    } else {
                        fieldInfo.fieldDescription = "";
                    }
                    fieldInfo.admTerms = adm = remote.in.readByte();
                    fields.addElement(fieldInfo);
                    ++n;
                }
            }
        }
        catch (IOException e) {
            if (fields != null) {
                fields.removeAllElements();
            }
            fields = null;
            lastError = 2;
            throw new ExceptionKnoDataBase("Unavailable server (2) getDBFieldsList: " + e.getMessage());
        }
        catch (Exception e) {
            if (fields != null) {
                fields.removeAllElements();
            }
            fields = null;
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database (2) getDBFieldsList: " + e.getMessage());
        }
        return fields;
    }

    protected Vector getDBIdxFieldsList() throws ExceptionKnoDataBase {
        Vector<KnoFieldInfo> fields = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getDBIdxFieldsList.");
        }
        try {
            int orden = 368;
            int count = 0;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.getHandle());
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0) {
                int numCmps = remote.in.readInt();
                fields = new Vector<KnoFieldInfo>(numCmps);
                int n = 0;
                while (n < numCmps) {
                    byte adm;
                    KnoFieldInfo fieldInfo = new KnoFieldInfo();
                    fieldInfo.type = 0;
                    fieldInfo.hasDescriptors = false;
                    count = remote.in.readInt();
                    if (count > 0) {
                        byte[] field = new byte[count];
                        remote.in.read(field);
                        fieldInfo.fieldName = new String(field);
                    } else {
                        fieldInfo.fieldName = "";
                    }
                    count = remote.in.readInt();
                    if (count > 0) {
                        byte[] tag = new byte[count];
                        remote.in.read(tag);
                        fieldInfo.fieldTag = new String(tag);
                    } else {
                        fieldInfo.fieldTag = "";
                    }
                    count = remote.in.readInt();
                    if (count > 0) {
                        byte[] description = new byte[count];
                        remote.in.read(description);
                        fieldInfo.fieldDescription = new String(description);
                    } else {
                        fieldInfo.fieldDescription = "";
                    }
                    fieldInfo.admTerms = adm = remote.in.readByte();
                    fields.addElement(fieldInfo);
                    ++n;
                }
            }
        }
        catch (IOException e) {
            if (fields != null) {
                fields.removeAllElements();
            }
            fields = null;
            lastError = 2;
            throw new ExceptionKnoDataBase("Unavailable server (2) getDBIdxFieldsList: " + e.getMessage());
        }
        catch (Exception e) {
            if (fields != null) {
                fields.removeAllElements();
            }
            fields = null;
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database (2) getDBIdxFieldsList: " + e.getMessage());
        }
        return fields;
    }

    protected Vector getQryVwFieldsList() throws ExceptionKnoDataBase {
        Vector<KnoFieldInfo> fields = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getQryVwFieldsList.");
        }
        try {
            int orden = 369;
            int count = 0;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.getHandle());
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0) {
                int numCmps = remote.in.readInt();
                fields = new Vector<KnoFieldInfo>(numCmps);
                int n = 0;
                while (n < numCmps) {
                    byte adm;
                    KnoFieldInfo fieldInfo = new KnoFieldInfo();
                    fieldInfo.type = 0;
                    fieldInfo.hasDescriptors = false;
                    count = remote.in.readInt();
                    if (count > 0) {
                        byte[] field = new byte[count];
                        remote.in.read(field);
                        fieldInfo.fieldName = new String(field);
                    } else {
                        fieldInfo.fieldName = "";
                    }
                    count = remote.in.readInt();
                    if (count > 0) {
                        byte[] tag = new byte[count];
                        remote.in.read(tag);
                        fieldInfo.fieldTag = new String(tag);
                    } else {
                        fieldInfo.fieldTag = "";
                    }
                    count = remote.in.readInt();
                    if (count > 0) {
                        byte[] description = new byte[count];
                        remote.in.read(description);
                        fieldInfo.fieldDescription = new String(description);
                    } else {
                        fieldInfo.fieldDescription = "";
                    }
                    fieldInfo.admTerms = adm = remote.in.readByte();
                    fields.addElement(fieldInfo);
                    ++n;
                }
            }
        }
        catch (IOException e) {
            if (fields != null) {
                fields.removeAllElements();
            }
            fields = null;
            lastError = 2;
            throw new ExceptionKnoDataBase("Unavailable server (2) getQryVwFieldsList: " + e.getMessage());
        }
        catch (Exception e) {
            if (fields != null) {
                fields.removeAllElements();
            }
            fields = null;
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database (2) getQryVwFieldsList: " + e.getMessage());
        }
        return fields;
    }

    protected Vector getDocVwFieldsList() throws ExceptionKnoDataBase {
        Vector<KnoFieldInfo> fields = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getDocVwFieldsList.");
        }
        try {
            int orden = 370;
            int count = 0;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.getHandle());
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0) {
                int numCmps = remote.in.readInt();
                fields = new Vector<KnoFieldInfo>(numCmps);
                int n = 0;
                while (n < numCmps) {
                    byte adm;
                    KnoFieldInfo fieldInfo = new KnoFieldInfo();
                    fieldInfo.type = 0;
                    fieldInfo.hasDescriptors = false;
                    count = remote.in.readInt();
                    if (count > 0) {
                        byte[] field = new byte[count];
                        remote.in.read(field);
                        fieldInfo.fieldName = new String(field);
                    } else {
                        fieldInfo.fieldName = "";
                    }
                    count = remote.in.readInt();
                    if (count > 0) {
                        byte[] tag = new byte[count];
                        remote.in.read(tag);
                        fieldInfo.fieldTag = new String(tag);
                    } else {
                        fieldInfo.fieldTag = "";
                    }
                    count = remote.in.readInt();
                    if (count > 0) {
                        byte[] description = new byte[count];
                        remote.in.read(description);
                        fieldInfo.fieldDescription = new String(description);
                    } else {
                        fieldInfo.fieldDescription = "";
                    }
                    fieldInfo.admTerms = adm = remote.in.readByte();
                    fields.addElement(fieldInfo);
                    ++n;
                }
            }
        }
        catch (IOException e) {
            if (fields != null) {
                fields.removeAllElements();
            }
            fields = null;
            lastError = 2;
            throw new ExceptionKnoDataBase("Unavailable server (2) getDocVwFieldsList: " + e.getMessage());
        }
        catch (Exception e) {
            if (fields != null) {
                fields.removeAllElements();
            }
            fields = null;
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database (2) getDocVwFieldsList: " + e.getMessage());
        }
        return fields;
    }

    protected Vector<String> getFormatsList(String name) throws ExceptionKnoDataBase {
        int NUM_FMTS = 5;
        Vector<String> formats = new Vector<String>();
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getFormatsList.");
        }
        try {
            int orden = 257;
            int numFormats = 5;
            while (numFormats == 5) {
                remote.out.writeChar(orden);
                remote.out.writeChar(this.getHandle());
                remote.out.writeInt(5);
                remote.out.writeInt(1);
                remote.out.flush();
                numFormats = remote.in.readChar();
                int n = 0;
                while (n < numFormats) {
                    int count = remote.in.readInt();
                    if (count > 0) {
                        byte[] format = new byte[count];
                        remote.in.read(format);
                        formats.addElement(new String(format));
                    }
                    ++n;
                }
                orden = 258;
            }
        }
        catch (IOException e) {
            formats = null;
            if (lastError == 0) {
                lastError = 2;
            }
            throw new ExceptionKnoDataBase("Unavailable server (2) getFormatsList: " + e.getMessage());
        }
        catch (Exception e) {
            formats = null;
            if (lastError == 0) {
                lastError = 8;
            }
            throw new ExceptionKnoDataBase("Unavailable database (2) getFormatsList: " + e.getMessage());
        }
        return formats;
    }

    protected KnoRemote getRemote() {
        return this.remote;
    }

    protected byte[] getViewFormat() throws ExceptionKnoRemote, ExceptionKnoDataBase {
        byte[] viewFormat = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getViewformat.");
        }
        try {
            remote.out.writeChar(259);
            remote.out.writeChar(this.getHandle());
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0) {
                int count = remote.in.readInt();
                viewFormat = new byte[count];
                remote.in.read(viewFormat);
            }
        }
        catch (IOException e) {
            viewFormat = null;
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server (2) getViewformat: " + e.getMessage());
        }
        catch (Exception e) {
            viewFormat = null;
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database getViewformat: " + e.getMessage());
        }
        return viewFormat;
    }

    protected void setViewFormat(String format) throws ExceptionKnoRemote, ExceptionKnoDataBase {
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) setViewFormat.");
        }
        try {
            remote.out.writeChar(265);
            remote.out.writeChar(this.getHandle());
            remote.sendString(format);
            remote.out.flush();
            lastError = remote.in.readChar();
        }
        catch (IOException e) {
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server (2) setViewFormat: " + e.getMessage());
        }
        catch (Exception e) {
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database setViewFormat: " + e.getMessage());
        }
    }

    protected byte[] getCreateFormat() throws ExceptionKnoRemote, ExceptionKnoDataBase {
        byte[] createFormat = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getModifyformat.");
        }
        try {
            remote.out.writeChar(260);
            remote.out.writeChar(this.getHandle());
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0) {
                int count = remote.in.readInt();
                createFormat = new byte[count];
                remote.in.read(createFormat);
            }
        }
        catch (IOException e) {
            createFormat = null;
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server (2) getCreateFormat: " + e.getMessage());
        }
        catch (Exception e) {
            createFormat = null;
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database getCreateFormat: " + e.getMessage());
        }
        return createFormat;
    }

    protected void setCreateFormat(String format) throws ExceptionKnoRemote, ExceptionKnoDataBase {
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) setCreateFormat.");
        }
        try {
            remote.out.writeChar(266);
            remote.out.writeChar(this.getHandle());
            remote.sendString(format);
            remote.out.flush();
            lastError = remote.in.readChar();
        }
        catch (IOException e) {
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server (2) setCreateFormat: " + e.getMessage());
        }
        catch (Exception e) {
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database setCreateFormat: " + e.getMessage());
        }
    }

    protected byte[] getModifyFormat() throws ExceptionKnoRemote, ExceptionKnoDataBase {
        byte[] modifyFormat = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getModifyformat.");
        }
        try {
            remote.out.writeChar(261);
            remote.out.writeChar(this.getHandle());
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0) {
                int count = remote.in.readInt();
                modifyFormat = new byte[count];
                remote.in.read(modifyFormat);
            }
        }
        catch (IOException e) {
            modifyFormat = null;
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server (2) getModifyformat: " + e.getMessage());
        }
        catch (Exception e) {
            modifyFormat = null;
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database getModifyformat: " + e.getMessage());
        }
        return modifyFormat;
    }

    protected void setModifyFormat(String format) throws ExceptionKnoRemote, ExceptionKnoDataBase {
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) setModifyFormat.");
        }
        try {
            remote.out.writeChar(267);
            remote.out.writeChar(this.getHandle());
            remote.sendString(format);
            remote.out.flush();
            lastError = remote.in.readChar();
        }
        catch (IOException e) {
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server (2) setModifyFormat: " + e.getMessage());
        }
        catch (Exception e) {
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database setModifyFormat: " + e.getMessage());
        }
    }

    protected byte[] getQueryFormat() throws ExceptionKnoRemote, ExceptionKnoDataBase {
        byte[] queryFormat = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getQueryFormat.");
        }
        try {
            remote.out.writeChar(262);
            remote.out.writeChar(this.getHandle());
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0) {
                int count = remote.in.readInt();
                queryFormat = new byte[count];
                remote.in.read(queryFormat);
            }
        }
        catch (IOException e) {
            queryFormat = null;
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server (2) getQueryFormat: " + e.getMessage());
        }
        catch (Exception e) {
            queryFormat = null;
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database (2) getQueryFormat: " + e.getMessage());
        }
        return queryFormat;
    }

    protected void setQueryFormat(String format) throws ExceptionKnoRemote, ExceptionKnoDataBase {
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) setQueryFormat.");
        }
        try {
            remote.out.writeChar(268);
            remote.out.writeChar(this.getHandle());
            remote.sendString(format);
            remote.out.flush();
            lastError = remote.in.readChar();
        }
        catch (IOException e) {
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server (2) setQueryFormat: " + e.getMessage());
        }
        catch (Exception e) {
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database setQueryFormat: " + e.getMessage());
        }
    }

    protected byte[] getQueryVwFormat() throws ExceptionKnoRemote, ExceptionKnoDataBase {
        byte[] queryVwFormat = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getQueryVwFormat.");
        }
        try {
            remote.out.writeChar(263);
            remote.out.writeChar(this.getHandle());
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0) {
                int count = remote.in.readInt();
                queryVwFormat = new byte[count];
                remote.in.read(queryVwFormat);
            }
        }
        catch (IOException e) {
            queryVwFormat = null;
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server (2) getQueryVwFormat: " + e.getMessage());
        }
        catch (Exception e) {
            queryVwFormat = null;
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database (2) getQueryVwFormat: " + e.getMessage());
        }
        return queryVwFormat;
    }

    protected void setQueryVwFormat(String format) throws ExceptionKnoRemote, ExceptionKnoDataBase {
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) setQueryVwFormat.");
        }
        try {
            remote.out.writeChar(269);
            remote.out.writeChar(this.getHandle());
            remote.sendString(format);
            remote.out.flush();
            lastError = remote.in.readChar();
        }
        catch (IOException e) {
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server (2) setQueryVwFormat: " + e.getMessage());
        }
        catch (Exception e) {
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database setQueryVwFormat: " + e.getMessage());
        }
    }

    protected byte[] getNewFmtFormat() throws ExceptionKnoRemote, ExceptionKnoDataBase {
        byte[] queryVwFormat = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getQueryVwFormat.");
        }
        try {
            remote.out.writeChar(264);
            remote.out.writeChar(this.getHandle());
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0) {
                int count = remote.in.readInt();
                queryVwFormat = new byte[count];
                remote.in.read(queryVwFormat);
            }
        }
        catch (IOException e) {
            queryVwFormat = null;
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server (2) getQueryVwFormat: " + e.getMessage());
        }
        catch (Exception e) {
            queryVwFormat = null;
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database (2) getQueryVwFormat: " + e.getMessage());
        }
        return queryVwFormat;
    }

    protected void setNewFmtFormat(String format) throws ExceptionKnoRemote, ExceptionKnoDataBase {
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) setNewFmtFormat.");
        }
        try {
            remote.out.writeChar(270);
            remote.out.writeChar(this.getHandle());
            remote.sendString(format);
            remote.out.flush();
            lastError = remote.in.readChar();
        }
        catch (IOException e) {
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server (2) setNewFmtFormat: " + e.getMessage());
        }
        catch (Exception e) {
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database setNewFmtFormat: " + e.getMessage());
        }
    }

    protected void insertFormat(KnoDBFormat format) throws ExceptionKnoRemote, ExceptionKnoDataBase {
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) insertFormat.");
        }
        try {
            remote.out.writeChar(255);
            remote.out.writeChar(this.getHandle());
            KnoFormat.sendFormat(remote, format);
            remote.out.flush();
            lastError = remote.in.readChar();
        }
        catch (IOException e) {
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server (2) insertFormat: " + e.getMessage());
        }
        catch (Exception e) {
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database insertFormat: " + e.getMessage());
        }
    }

    protected void deleteFormat(String format) throws ExceptionKnoRemote, ExceptionKnoDataBase {
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) deleteFormat.");
        }
        try {
            remote.out.writeChar(256);
            remote.out.writeChar(this.getHandle());
            remote.sendString(format);
            remote.out.writeInt(1);
            remote.out.flush();
            lastError = remote.in.readChar();
        }
        catch (IOException e) {
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server (2) deleteFormat: " + e.getMessage());
        }
        catch (Exception e) {
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database deleteFormat: " + e.getMessage());
        }
    }

    protected byte getFieldHash(String cmpName) throws ExceptionKnoDataBase, ExceptionKnoRemote, ExceptionKnoQuery {
        byte bHashCode = 0;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getViewformat.");
        }
        try {
            int orden = 379;
            int count = 0;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.getHandle());
            count = cmpName.length();
            remote.out.writeInt(count);
            if (count > 0) {
                remote.out.writeBytes(cmpName);
            }
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0) {
                bHashCode = remote.in.readByte();
            }
        }
        catch (IOException e) {
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server (2) getViewformat: " + e.getMessage());
        }
        catch (Exception e) {
            lastError = 8;
            throw new ExceptionKnoQuery("Unavailable database getViewformat: " + e.getMessage());
        }
        return bHashCode;
    }

    protected byte[] exploreXMLDir(String dir, short page, short files) throws ExceptionKnoDataBase, ExceptionKnoRemote, ExceptionKnoQuery {
        byte[] xmlDir = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getViewformat.");
        }
        try {
            int orden = 381;
            int count = 0;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.getHandle());
            count = dir.length();
            remote.out.writeInt(count);
            if (count > 0) {
                remote.out.writeBytes(dir);
            }
            remote.out.writeChar(page);
            remote.out.writeChar(files);
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0) {
                files = (byte)remote.in.readChar();
                count = remote.in.readInt();
                xmlDir = new byte[count];
                remote.in.read(xmlDir);
            }
        }
        catch (IOException e) {
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server (2) getViewformat: " + e.getMessage());
        }
        catch (Exception e) {
            lastError = 8;
            throw new ExceptionKnoQuery("Unavailable database getViewformat: " + e.getMessage());
        }
        return xmlDir;
    }

    protected byte[] getFieldValue(String Field) throws ExceptionKnoRemote, ExceptionKnoDataBase {
        byte[] content = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getViewformat.");
        }
        try {
            int orden = 386;
            int count = 0;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.getHandle());
            count = Field.length();
            remote.out.writeInt(count);
            if (count > 0) {
                remote.out.writeBytes(Field);
            }
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0) {
                count = remote.in.readInt();
                content = new byte[count];
                remote.in.read(content);
            }
        }
        catch (IOException e) {
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server (2) getXmlFieldValue: " + e.getMessage());
        }
        catch (Exception e) {
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database getXmlFieldValue: " + e.getMessage());
        }
        return content;
    }

    protected byte[] getFieldMask(String Field) throws ExceptionKnoRemote, ExceptionKnoDataBase {
        byte[] content = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getViewformat.");
        }
        try {
            int orden = 391;
            int count = 0;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.getHandle());
            count = Field.length();
            remote.out.writeInt(count);
            if (count > 0) {
                remote.out.writeBytes(Field);
            }
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0) {
                count = remote.in.readInt();
                content = new byte[count];
                remote.in.read(content);
            }
        }
        catch (IOException e) {
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server (2) getXmlFieldValue: " + e.getMessage());
        }
        catch (Exception e) {
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database getXmlFieldValue: " + e.getMessage());
        }
        return content;
    }

    protected static KnoDataBase openDataBase(KnoRemote rem, String alias) throws ExceptionKnoDataBase {
        KnoDataBase dataBase = null;
        if (rem == null) {
            throw new ExceptionKnoDataBase("Unspecified server openDataBase.");
        }
        if (alias == null || alias.compareTo("") == 0) {
            throw new ExceptionKnoDataBase("Unspecified database name openDataBase.");
        }
        try {
            dataBase = new KnoDataBase();
            if (dataBase.abreBase(rem, alias) != 0 || dataBase.getHandle() == '\uffff') {
                dataBase = null;
            }
        }
        catch (Exception e) {
            dataBase = null;
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable server openDataBase: " + e.getMessage());
        }
        return dataBase;
    }

    protected byte[] getXmlKeyList(char keys, String value, String field, boolean ddx, boolean asc) throws ExceptionKnoDataBase, ExceptionKnoRemote {
        byte[] content = null;
        if (this.remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getXmlKeyList.");
        }
        if (this.handle == '\uffffffff') {
            throw new ExceptionKnoDataBase("Unavailable database (1) getXmlKeyList.");
        }
        try {
            int nLen;
            int orden = 398;
            this.remote.out.writeChar(orden);
            this.remote.out.writeChar(this.handle);
            this.remote.out.writeChar(keys);
            int nTam = value.length();
            this.remote.out.writeInt(nTam);
            if (nTam > 0) {
                this.remote.out.writeBytes(value);
            }
            nTam = field.length();
            this.remote.out.writeInt(nTam);
            if (nTam > 0) {
                this.remote.out.writeBytes(field);
            }
            this.remote.out.writeInt(ddx ? 1 : 0);
            this.remote.out.writeInt(asc ? 1 : 0);
            this.remote.out.flush();
            lastError = this.remote.in.readChar();
            if (lastError == 0 && (nLen = this.remote.in.readInt()) > 0) {
                content = new byte[nLen];
                this.remote.in.read(content);
            }
        }
        catch (IOException e) {
            if (lastError == 0) {
                lastError = 2;
            }
            throw new ExceptionKnoDataBase("Unavailable server (2) getNumDocByID: " + e.getMessage());
        }
        catch (Exception e) {
            if (lastError == 0) {
                lastError = 8;
            }
            throw new ExceptionKnoDataBase("Unavailable database (2) getNumDocByID: " + e.getMessage());
        }
        return content;
    }

    protected byte[] getAutoCmp(String fieldname, int updatevalue) throws ExceptionKnoDataBase {
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getAutoCmp.");
        }
        byte[] number = null;
        try {
            try {
                int orden = 373;
                remote.out.writeChar(orden);
                remote.out.writeChar(this.getHandle());
                int count = fieldname.length();
                remote.out.writeInt(count);
                if (count > 0) {
                    remote.out.writeBytes(fieldname);
                }
                remote.out.flush();
                lastError = remote.in.readChar();
                if (lastError == 0) {
                    count = remote.in.readInt();
                    number = new byte[count];
                    remote.in.read(number);
                }
            }
            catch (IOException e) {
                number = null;
                lastError = 2;
                throw new ExceptionKnoRemote("Unavailable server (2) getAutoCmp: " + e.getMessage());
            }
            catch (Exception e) {
                number = null;
                lastError = 8;
                throw new ExceptionKnoQuery("Unavailable database getAutoCmp: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        return number;
    }

    protected KnoDBLastDocFis getLastDocFis(String dbName) throws ExceptionKnoRemote, ExceptionKnoDataBase {
        KnoDBLastDocFis knoDBLastDocFis = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getLastDocFis.");
        }
        try {
            int orden = 1304;
            int count = 0;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.getHandle());
            count = dbName.length();
            remote.out.writeInt(count);
            if (count > 0) {
                remote.out.writeBytes(dbName);
            }
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0) {
                int num = remote.in.readInt();
                count = remote.in.readInt();
                byte[] content = new byte[count];
                remote.in.read(content);
                knoDBLastDocFis = new KnoDBLastDocFis();
                knoDBLastDocFis.setNumDocFis(num);
                knoDBLastDocFis.setUpdatedDate(new String(content));
            }
        }
        catch (IOException e) {
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server (2) getXmlFieldValue: " + e.getMessage());
        }
        catch (Exception e) {
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database getXmlFieldValue: " + e.getMessage());
        }
        return knoDBLastDocFis;
    }

    private int setDBSession(int iOrder, String dbClient) throws ExceptionKnoRemote, ExceptionKnoDataBase {
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getLastDocFis.");
        }
        lastError = 0;
        try {
            int orden = 0;
            int count = 0;
            switch (iOrder) {
                case 1: {
                    orden = 8;
                    break;
                }
                case 2: {
                    orden = 9;
                }
            }
            if (orden > 0) {
                remote.out.writeChar(orden);
                count = dbClient.length();
                remote.out.writeInt(count);
                if (count > 0) {
                    remote.out.writeBytes(dbClient);
                }
                remote.out.writeChar(this.getHandle());
                remote.out.flush();
                lastError = remote.in.readChar();
            }
        }
        catch (IOException e) {
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server (2) writeLogFile: " + e.getMessage());
        }
        catch (Exception e) {
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database (2) writelogFile: " + e.getMessage());
        }
        return lastError;
    }

    private int writeLogFile(String dbAction, String dbClient, Integer numDoc, int iRes, Integer iLevel) throws ExceptionKnoRemote, ExceptionKnoDataBase {
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getLastDocFis.");
        }
        lastError = 0;
        try {
            int orden = numDoc > 0 ? 348 : 347;
            int count = 0;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.getHandle());
            if (dbClient != null && dbClient != "") {
                count = dbClient.length();
            }
            remote.out.writeInt(count);
            if (count > 0) {
                remote.out.writeBytes(dbClient);
            }
            count = dbAction.length();
            remote.out.writeInt(count);
            if (count > 0) {
                remote.out.writeBytes(dbAction);
            }
            if (numDoc > 0) {
                remote.out.writeInt(numDoc);
            }
            remote.out.writeChar(iRes);
            remote.out.writeInt(iLevel);
            remote.out.flush();
            lastError = remote.in.readChar();
        }
        catch (IOException e) {
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server (2) writeLogFile: " + e.getMessage());
        }
        catch (Exception e) {
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database (2) writelogFile: " + e.getMessage());
        }
        return lastError;
    }

    public void InfoDBLog(int iOrder, String dbClient, String Data, Integer numDoc, int iRes) throws ExceptionKnoRemote, ExceptionKnoDataBase {
        try {
            switch (iOrder) {
                case 1: 
                case 2: {
                    this.setDBSession(iOrder, dbClient);
                    break;
                }
                case 3: {
                    String csText = MESSAGE.getString("message.database.log.query");
                    csText = MessageFormat.format(csText, Data, numDoc);
                    this.writeLogFile(csText, dbClient, 0, iRes, 16);
                    break;
                }
                case 4: {
                    String csText = MESSAGE.getString("message.database.log.viewdoc");
                    this.writeLogFile(csText, dbClient, numDoc, iRes, 16);
                    break;
                }
                case 7: {
                    String csText = MESSAGE.getString("message.database.log.insertdoc");
                    this.writeLogFile(csText, dbClient, numDoc, iRes, 16);
                    break;
                }
                case 8: {
                    String csText = MESSAGE.getString("message.database.log.modifdoc");
                    this.writeLogFile(csText, dbClient, numDoc, iRes, 16);
                    break;
                }
                case 9: {
                    String csText = MESSAGE.getString("message.database.log.deletedoc");
                    this.writeLogFile(csText, dbClient, numDoc, iRes, 16);
                    break;
                }
                case 10: {
                    String csText = MESSAGE.getString("message.database.log.undeletedoc");
                    this.writeLogFile(csText, dbClient, numDoc, iRes, 16);
                    break;
                }
                case 5: {
                    this.writeLogFile(Data, dbClient, numDoc, iRes, 2);
                    break;
                }
                case 6: {
                    this.writeLogFile(Data, dbClient, numDoc, iRes, 8);
                    break;
                }
            }
        }
        catch (ExceptionKnoDataBase e) {
            if (lastError == 0) {
                lastError = 8;
            }
            throw new ExceptionKnoDataBase("Error de base de datos: " + lastError + ". " + e.getMessage());
        }
    }

    public String getNameObject(String objectName, String searchPath) throws ExceptionKnoRemote, ExceptionKnoDataBase {
        return this.getNameObjectOrder('\u0516', objectName, searchPath);
    }

    public String getNameObject2(String objectName, String searchPath) throws ExceptionKnoRemote, ExceptionKnoDataBase {
        return this.getNameObjectOrder('\u0533', objectName, searchPath);
    }

    private String getNameObjectOrder(char orden, String objectName, String searchPath) throws ExceptionKnoRemote, ExceptionKnoDataBase {
        String path = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getNameObject.");
        }
        int count = 0;
        char leng = '\u0000';
        byte[] name = objectName.getBytes();
        leng = (char)name.length;
        if (leng == '\u0000') {
            return path;
        }
        try {
            remote.out.writeChar(orden);
            remote.out.writeChar(this.getHandle());
            count = searchPath != null ? searchPath.length() : 0;
            remote.out.writeInt(count);
            if (count > 0) {
                remote.out.writeBytes(searchPath);
            }
            remote.out.writeChar(leng);
            remote.out.write(name);
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0 && (count = remote.in.readInt()) > 0) {
                byte[] b = new byte[count];
                remote.in.read(b);
                path = new String(b);
            }
        }
        catch (IOException e) {
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server (2) getXmlFieldValue: " + e.getMessage());
        }
        catch (Exception e) {
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database getXmlFieldValue: " + e.getMessage());
        }
        return path;
    }

    public List<KnoDBObject> findDocObjects(int numDoc, byte bHashCode) throws ExceptionKnoRemote, ExceptionKnoDataBase {
        ArrayList<KnoDBObject> knoDBObjects = new ArrayList<KnoDBObject>();
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getNameObject.");
        }
        try {
            int orden = 402;
            int objects = 0;
            int ocurs = 0;
            int count = 0;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.getHandle());
            remote.out.writeInt(numDoc);
            remote.out.writeInt(0);
            remote.out.writeByte(bHashCode);
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0) {
                objects = remote.in.readInt();
                int i = 0;
                while (i < objects) {
                    KnoDBObject knoDBObject = new KnoDBObject();
                    count = remote.in.readInt();
                    if (count > 0) {
                        byte[] name = new byte[count];
                        remote.in.read(name);
                        knoDBObject.setObjName(new String(name));
                    }
                    ocurs = remote.in.readInt();
                    knoDBObject.setNumOcurs(ocurs);
                    int j = 0;
                    while (j < ocurs) {
                        KnoDBObject.KnoDBOcur KnoOcur = new KnoDBObject().new KnoDBObject.KnoDBOcur();
                        byte[] occurrence = new byte[8];
                        remote.in.read(occurrence);
                        KnoOcur.setField(occurrence[3]);
                        KnoOcur.setPar((short)(occurrence[4] << 8 | occurrence[5]));
                        KnoOcur.setPos((short)(occurrence[6] << 8 | occurrence[7]));
                        knoDBObject.addOcur(KnoOcur);
                        ++j;
                    }
                    knoDBObjects.add(knoDBObject);
                    ++i;
                }
            }
        }
        catch (IOException e) {
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server (2) getXmlFieldValue: " + e.getMessage());
        }
        catch (Exception e) {
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database getXmlFieldValue: " + e.getMessage());
        }
        return knoDBObjects;
    }

    public List<KnoDBObject> findDocObjects(int numDoc, byte bHashCode, boolean fullPath) throws ExceptionKnoRemote, ExceptionKnoDataBase {
        ArrayList<KnoDBObject> knoDBObjects = new ArrayList<KnoDBObject>();
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getNameObject.");
        }
        try {
            int orden = 403;
            int objects = 0;
            int ocurs = 0;
            int count = 0;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.getHandle());
            remote.out.writeInt(numDoc);
            remote.out.writeInt(0);
            remote.out.writeInt(fullPath ? 1 : 0);
            remote.out.writeByte(bHashCode);
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0) {
                objects = remote.in.readInt();
                int i = 0;
                while (i < objects) {
                    KnoDBObject knoDBObject = new KnoDBObject();
                    count = remote.in.readInt();
                    if (count > 0) {
                        byte[] name = new byte[count];
                        remote.in.read(name);
                        knoDBObject.setObjName(new String(name));
                    }
                    ocurs = remote.in.readInt();
                    knoDBObject.setNumOcurs(ocurs);
                    int j = 0;
                    while (j < ocurs) {
                        KnoDBObject.KnoDBOcur KnoOcur = new KnoDBObject().new KnoDBObject.KnoDBOcur();
                        byte[] occurrence = new byte[8];
                        remote.in.read(occurrence);
                        KnoOcur.setField(occurrence[3]);
                        KnoOcur.setPar((short)(occurrence[4] << 8 | occurrence[5]));
                        KnoOcur.setPos((short)(occurrence[6] << 8 | occurrence[7]));
                        knoDBObject.addOcur(KnoOcur);
                        ++j;
                    }
                    knoDBObjects.add(knoDBObject);
                    ++i;
                }
            }
        }
        catch (IOException e) {
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server (2) getXmlFieldValue: " + e.getMessage());
        }
        catch (Exception e) {
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database getXmlFieldValue: " + e.getMessage());
        }
        return knoDBObjects;
    }

    public Vector<String> findDocObjects(int numDoc, boolean fullPath) throws ExceptionKnoRemote, ExceptionKnoDataBase {
        Vector<String> knoDBObjects = new Vector<String>();
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoDataBase("Unavailable server (1) getNameObject.");
        }
        try {
            int orden = 396;
            int objects = 0;
            boolean ocurs = false;
            int count = 0;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.getHandle());
            remote.out.writeInt(numDoc);
            remote.out.writeInt(fullPath ? 1 : 0);
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0) {
                objects = remote.in.readInt();
                int i = 0;
                while (i < objects) {
                    count = remote.in.readInt();
                    if (count > 0) {
                        byte[] term = new byte[count];
                        remote.in.read(term);
                        knoDBObjects.addElement(new String(term));
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            lastError = 2;
            throw new ExceptionKnoRemote("Unavailable server (2) getXmlFieldValue: " + e.getMessage());
        }
        catch (Exception e) {
            lastError = 8;
            throw new ExceptionKnoDataBase("Unavailable database getXmlFieldValue: " + e.getMessage());
        }
        return knoDBObjects;
    }
}

