/*
 * Decompiled with CFR 0.152.
 */
package es.knosys.tools;

import es.knosys.tools.KnoDBField;
import es.knosys.tools.KnoDBTag;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class KnoDBStruct {
    private static int PDB_ONLY_STYLES = 1;
    private static int MIN_HASH_CODE_TAG = 256;
    private static int MAX_HASH_CODE_TAG = 512;
    private String version = "";
    private String dbId = "";
    private int dbType = 0;
    private byte[] dbPass = null;
    private int maxDBDocs = 0;
    private int indexType = 0;
    private int indexMode = 0;
    private int minutes = 0;
    private int numDocs = 0;
    private int properties = 0;
    private int numTags = 0;
    private List<KnoDBTag> tags = new ArrayList<KnoDBTag>();
    private List<KnoDBField> fields = new ArrayList<KnoDBField>();

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDBId() {
        return this.dbId;
    }

    public void setDBId(String dbId) {
        this.dbId = dbId;
    }

    public int getDBType() {
        return this.dbType;
    }

    public void setDBType(int dbType) {
        this.dbType = dbType;
    }

    public byte[] getDBPass() {
        return this.dbPass;
    }

    public void setDBPass(byte[] dbPass) {
        this.dbPass = dbPass;
    }

    public int getMaxDBDocs() {
        return this.maxDBDocs;
    }

    public void setMaxDBDocs(int maxDBDocs) {
        this.maxDBDocs = maxDBDocs;
    }

    public int getIndexType() {
        return this.indexType;
    }

    public void setIndexType(int indexType) {
        this.indexType = indexType;
    }

    public int getIndexMode() {
        return this.indexMode;
    }

    public void setIndexMode(int indexMode) {
        this.indexMode = indexMode;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public void setMinutes(int minutes) {
        this.minutes = minutes;
    }

    public int getNumDocs() {
        return this.numDocs;
    }

    public void setNumDocs(int numDocs) {
        this.numDocs = numDocs;
    }

    public int getProperties() {
        return this.properties;
    }

    public void setProperties(int properties) {
        this.properties = properties;
    }

    public boolean getUseOnlyStyles() {
        return (this.properties & PDB_ONLY_STYLES) > 0;
    }

    public int getNumTags() {
        return this.numTags;
    }

    public void setNumTags(int numTags) {
        this.numTags = numTags;
    }

    public List<KnoDBTag> getTags() {
        return this.tags;
    }

    public void addTag(KnoDBTag tag) {
        this.tags.add(tag);
    }

    public KnoDBTag getTag(int hashCode) {
        for (KnoDBTag tag : this.tags) {
            if (tag.getHashCode() != hashCode) continue;
            return tag;
        }
        return null;
    }

    public int getNextHashCode() {
        KnoDBTag lastTag = this.tags.get(this.tags.size() - 1);
        Hashtable<Integer, Integer> hashCodes = new Hashtable<Integer, Integer>();
        for (KnoDBTag tag : this.tags) {
            hashCodes.put(tag.getHashCode(), tag.getHashCode());
        }
        int i = lastTag.getHashCode() + 1;
        while (i <= MAX_HASH_CODE_TAG) {
            if (!hashCodes.contains(i)) {
                return i;
            }
            ++i;
        }
        i = MIN_HASH_CODE_TAG + 1;
        while (i < lastTag.getHashCode()) {
            if (!hashCodes.contains(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void removeTag(int hashCode) {
        Iterator<KnoDBTag> iterator = this.tags.iterator();
        while (iterator.hasNext()) {
            KnoDBTag tag = iterator.next();
            if (tag.getHashCode() != hashCode) continue;
            iterator.remove();
            break;
        }
    }

    public void updateNumTags() {
        this.numTags = this.tags.size();
    }

    public KnoDBField getRootField() {
        return this.fields.get(0);
    }

    public List<KnoDBField> getFields() {
        return this.fields.subList(1, this.fields.size());
    }

    public List<KnoDBField> getAllFields() {
        return this.fields;
    }

    public void addField(KnoDBField field) {
        this.fields.add(field);
    }

    public String toString() {
        String trace = "";
        trace = String.valueOf(trace) + "version: " + this.version + "\n";
        trace = String.valueOf(trace) + "dbId: " + this.dbId + "\n";
        trace = String.valueOf(trace) + "dbType: " + this.dbType + "\n";
        trace = String.valueOf(trace) + "dbPass: " + this.dbPass + "\n";
        trace = String.valueOf(trace) + "maxDBDocs: " + this.maxDBDocs + "\n";
        trace = String.valueOf(trace) + "indexType: " + this.indexType + "\n";
        trace = String.valueOf(trace) + "indexMode: " + this.indexMode + "\n";
        trace = String.valueOf(trace) + "minutes: " + this.minutes + "\n";
        trace = String.valueOf(trace) + "numDocs: " + this.numDocs + "\n";
        trace = String.valueOf(trace) + "properties: " + this.properties + "\n";
        trace = String.valueOf(trace) + "numTags: " + this.numTags + "\n";
        for (KnoDBTag tag : this.tags) {
            trace = String.valueOf(trace) + tag.toString();
        }
        for (KnoDBField field : this.fields) {
            trace = String.valueOf(trace) + field.toString();
        }
        return trace;
    }
}

