/*
 * Decompiled with CFR 0.152.
 */
package es.knosys.tools;

import es.knosys.tools.KnoDBField;
import es.knosys.tools.KnoDBTag;
import es.knosys.tools.KnoUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class KnoDBFormat {
    private String name;
    private int mode;
    private int numFields;
    private int numTags;
    private List<KnoDBField> fields;
    private List<KnoDBTag> tags;
    private ListConfig listConfig;
    private DesignConfig designConfig;

    public KnoDBFormat() {
        this("");
    }

    public KnoDBFormat(String name) {
        this.name = name;
        this.mode = 0;
        this.numFields = 0;
        this.numTags = 0;
        this.fields = new ArrayList<KnoDBField>();
        this.tags = new ArrayList<KnoDBTag>();
        this.listConfig = new ListConfig();
        this.designConfig = new DesignConfig();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getNumFields() {
        return this.numFields;
    }

    public void setNumFields(int numFields) {
        this.numFields = numFields;
    }

    public int getNumTags() {
        return this.numTags;
    }

    public void setNumTags(int numTags) {
        this.numTags = numTags;
    }

    public List<KnoDBField> getFields() {
        return this.fields;
    }

    public void addField(KnoDBField field) {
        this.fields.add(field);
    }

    public List<KnoDBTag> getTags() {
        return this.tags;
    }

    public void addTag(KnoDBTag tag) {
        this.tags.add(tag);
    }

    public ListConfig getListConfig() {
        return this.listConfig;
    }

    public void setListConfig(ListConfig listConfig) {
        this.listConfig = listConfig;
    }

    public DesignConfig getDesignConfig() {
        return this.designConfig;
    }

    public void setDesignConfig(DesignConfig designConfig) {
        this.designConfig = designConfig;
    }

    public boolean isNew() {
        return this.name.equals("");
    }

    public String toString() {
        String trace = "";
        trace = String.valueOf(trace) + "name: " + this.name + "\n";
        trace = String.valueOf(trace) + "mode: " + this.mode + "\n";
        trace = String.valueOf(trace) + "numFields: " + this.numFields + "\n";
        trace = String.valueOf(trace) + "numTags: " + this.numTags + "\n";
        for (KnoDBField field : this.fields) {
            trace = String.valueOf(trace) + field.toString();
        }
        for (KnoDBTag tag : this.tags) {
            trace = String.valueOf(trace) + tag.toString();
        }
        trace = String.valueOf(trace) + this.listConfig.toString();
        return trace;
    }

    public class DesignConfig {
        private int mode = 0;
        private String fontName = "Arial";
        private int size = 11;
        private int attrib = 0;
        private Color backColor = new Color(255, 255, 255);
        private Color foreColor = new Color(0, 0, 0);
        private int align = 1;
        private Color backColorBack = new Color(255, 255, 255);
        private int adjustPict = 0;
        private int pictWidth = 0;
        private int pictHeight = 0;

        public int getMode() {
            return this.mode;
        }

        public void setMode(int mode) {
            this.mode = mode;
        }

        public String getFontName() {
            return this.fontName;
        }

        public void setFontName(String fontName) {
            this.fontName = fontName;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public int getAttrib() {
            return this.attrib;
        }

        public void setAttrib(int attrib) {
            this.attrib = attrib;
        }

        public Color getBackColor() {
            return this.backColor;
        }

        public String getBackColorHex() {
            return KnoUtil.color2Hex(this.backColor);
        }

        public void setBackColor(Color backColor) {
            this.backColor = backColor;
        }

        public void setBackColorHex(String color) {
            this.backColor = KnoUtil.hex2Color(color);
        }

        public Color getForeColor() {
            return this.foreColor;
        }

        public String getForeColorHex() {
            return KnoUtil.color2Hex(this.foreColor);
        }

        public void setForeColor(Color foreColor) {
            this.foreColor = foreColor;
        }

        public void setForeColorHex(String color) {
            this.foreColor = KnoUtil.hex2Color(color);
        }

        public int getAlign() {
            return this.align;
        }

        public void setAlign(int align) {
            this.align = align;
        }

        public Color getBackColorBack() {
            return this.backColorBack;
        }

        public String getBackColorBackHex() {
            return KnoUtil.color2Hex(this.backColorBack);
        }

        public void setBackColorBack(Color backColorBack) {
            this.backColorBack = backColorBack;
        }

        public void setBackColorBackHex(String color) {
            this.backColorBack = KnoUtil.hex2Color(color);
        }

        public int getAdjustPict() {
            return this.adjustPict;
        }

        public void setAdjustPict(int adjustPict) {
            this.adjustPict = adjustPict;
        }

        public int getPictWidth() {
            return this.pictWidth;
        }

        public void setPictWidth(int pictWidth) {
            this.pictWidth = pictWidth;
        }

        public int getPictHeight() {
            return this.pictHeight;
        }

        public void setPictHeight(int pictHeight) {
            this.pictHeight = pictHeight;
        }

        public boolean getIsAlignBold() {
            return (this.attrib & 1) > 0;
        }

        public boolean getIsAlignItalic() {
            return (this.attrib & 2) > 0;
        }

        public boolean getIsAlignUnderline() {
            return (this.attrib & 4) > 0;
        }

        public boolean getIsAdjustPictOriginal() {
            return this.adjustPict == 1 && this.pictWidth == -1 && this.pictHeight == -1;
        }

        public boolean getIsAdjustPictIcon() {
            return this.adjustPict == 2;
        }

        public boolean getIsAdjustPictSize() {
            return this.adjustPict == 1 && this.pictWidth > 0 && this.pictHeight > 0;
        }

        public String toString() {
            String trace = "";
            trace = String.valueOf(trace) + "mode: " + this.mode + "\n";
            trace = String.valueOf(trace) + "fontName: " + this.fontName + "\n";
            trace = String.valueOf(trace) + "size: " + this.size + "\n";
            trace = String.valueOf(trace) + "attrib: " + this.attrib + "\n";
            trace = String.valueOf(trace) + "backColor: " + this.backColor + "\n";
            trace = String.valueOf(trace) + "foreColor: " + this.foreColor + "\n";
            trace = String.valueOf(trace) + "align: " + this.align + "\n";
            trace = String.valueOf(trace) + "backColorBack: " + this.backColorBack + "\n";
            trace = String.valueOf(trace) + "adjustPict: " + this.adjustPict + "\n";
            trace = String.valueOf(trace) + "pictWidth: " + this.pictWidth + "\n";
            trace = String.valueOf(trace) + "pictHeight: " + this.pictHeight + "\n";
            return trace;
        }
    }

    public class FieldOrder {
        private int hashCode = 0;
        private int numChars = 0;
        private int direction = 0;

        public int getHashCode() {
            return this.hashCode;
        }

        public void setHashCode(int hashCode) {
            this.hashCode = hashCode;
        }

        public int getNumChars() {
            return this.numChars;
        }

        public void setNumChars(int numChars) {
            this.numChars = numChars;
        }

        public int getDirection() {
            return this.direction;
        }

        public void setDirection(int direction) {
            this.direction = direction;
        }

        public String toString() {
            String trace = "";
            trace = String.valueOf(trace) + "hashCode: " + this.hashCode + "\n";
            trace = String.valueOf(trace) + "numChars: " + this.numChars + "\n";
            trace = String.valueOf(trace) + "direction: " + this.direction + "\n";
            return trace;
        }
    }

    public class ListConfig {
        private int numDoc = 0;
        private int docSize = 0;
        private int cDate = 0;
        private int mDate = 0;
        private int numOrdFields = 0;
        private int numColWidth = 0;
        private List<FieldOrder> fieldOrderList = new ArrayList<FieldOrder>();
        private List<Integer> colWidthList = new ArrayList<Integer>();
        private int status = 0;
        private int workflow = 0;

        public int getNumDoc() {
            return this.numDoc;
        }

        public void setNumDoc(int numDoc) {
            this.numDoc = numDoc;
        }

        public int getDocSize() {
            return this.docSize;
        }

        public void setDocSize(int docSize) {
            this.docSize = docSize;
        }

        public int getCDate() {
            return this.cDate;
        }

        public void setCDate(int date) {
            this.cDate = date;
        }

        public int getMDate() {
            return this.mDate;
        }

        public void setMDate(int date) {
            this.mDate = date;
        }

        public int getNumOrdFields() {
            return this.numOrdFields;
        }

        public void setNumOrdFields(int numOrdFields) {
            this.numOrdFields = numOrdFields;
        }

        public int getNumColWidth() {
            return this.numColWidth;
        }

        public void setNumColWidth(int numColWidth) {
            this.numColWidth = numColWidth;
        }

        public List<FieldOrder> getOrdFieldsList() {
            return this.fieldOrderList;
        }

        public void addFieldOrder(FieldOrder fieldOrder) {
            this.fieldOrderList.add(fieldOrder);
        }

        public List<Integer> getColWidthList() {
            return this.colWidthList;
        }

        public void addColWidth(Integer colWidth) {
            this.colWidthList.add(colWidth);
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public int getWorkflow() {
            return this.workflow;
        }

        public void setWorkflow(int workflow) {
            this.workflow = workflow;
        }

        public String toString() {
            String trace = "";
            trace = String.valueOf(trace) + "numDoc: " + this.numDoc + "\n";
            trace = String.valueOf(trace) + "docSize: " + this.docSize + "\n";
            trace = String.valueOf(trace) + "cDate: " + this.cDate + "\n";
            trace = String.valueOf(trace) + "mDate: " + this.mDate + "\n";
            trace = String.valueOf(trace) + "numOrdFields: " + this.numOrdFields + "\n";
            for (FieldOrder field : this.fieldOrderList) {
                trace = String.valueOf(trace) + field.toString();
            }
            trace = String.valueOf(trace) + "numColWidth: " + this.numColWidth + "\n";
            for (Integer width : this.colWidthList) {
                trace = String.valueOf(trace) + width.toString() + "\n";
            }
            trace = String.valueOf(trace) + "status: " + this.status + "\n";
            trace = String.valueOf(trace) + "workflow: " + this.workflow + "\n";
            return trace;
        }
    }
}

