/*
 * Decompiled with CFR 0.152.
 */
package es.knosys.tools;

import es.knosys.tools.ExceptionKnoCatalog;
import es.knosys.tools.ExceptionKnoRemote;
import es.knosys.tools.KnoDBInfo;
import es.knosys.tools.KnoRemote;
import java.io.IOException;
import java.util.Vector;

public class KnoCatalog {
    private KnoRemote remote = null;
    private char handle = (char)65535;
    private static int lastError = 0;

    private KnoCatalog() {
    }

    private int abreCatalogo(KnoRemote rem) throws ExceptionKnoCatalog, ExceptionKnoRemote {
        if (rem == null) {
            throw new ExceptionKnoCatalog("Unspecified server (1) abreCatalog.");
        }
        this.remote = rem;
        try {
            int orden = 150;
            int count = 0;
            this.remote.out.writeChar(orden);
            count = this.remote.getUserName().length();
            this.remote.out.writeInt(count);
            if (count > 0) {
                this.remote.out.writeBytes(this.remote.getUserName());
            }
            count = this.remote.getPassword().length();
            this.remote.out.writeInt(count);
            if (count > 0) {
                this.remote.out.writeBytes(this.remote.getPassword());
            }
            this.remote.out.flush();
            lastError = this.remote.in.readChar();
            if (lastError == 0) {
                this.handle = this.remote.in.readChar();
            } else {
                this.remote = null;
                this.handle = (char)65535;
            }
        }
        catch (IOException e) {
            this.remote = null;
            lastError = 2;
            throw new ExceptionKnoCatalog("Unavailable server (2) abreCatalog: " + e.getMessage());
        }
        catch (Exception e) {
            this.remote = null;
            lastError = 7;
            throw new ExceptionKnoCatalog("Unavailable catalog (2) abreCatalog: " + e.getMessage());
        }
        return lastError;
    }

    protected void closeCatalog() throws ExceptionKnoCatalog {
        if (this.remote == null) {
            throw new ExceptionKnoCatalog("Unavailable server (1) closeCatalog.");
        }
        if (this.handle == '\uffff') {
            throw new ExceptionKnoCatalog("Unavailable catalog (1) closeCatalog.");
        }
        try {
            int orden = 151;
            this.remote.out.writeChar(orden);
            this.remote.out.writeChar(this.handle);
            this.remote.out.flush();
            lastError = this.remote.in.readChar();
        }
        catch (IOException e) {
            lastError = 2;
            throw new ExceptionKnoCatalog("Unavailable server (2) closeCatalog: " + e.getMessage());
        }
        catch (Exception e) {
            lastError = 7;
            throw new ExceptionKnoCatalog("Unavailable catalog (2) closeCatalog: " + e.getMessage());
        }
    }

    protected KnoDBInfo getDBInfo(String dbAlias) throws ExceptionKnoCatalog {
        KnoDBInfo dbInfo = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoCatalog("Unavailable server (1) getDBInfo.");
        }
        try {
            int orden = 169;
            int count = 0;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.getHandle());
            count = dbAlias.length();
            remote.out.writeInt(count);
            if (count > 0) {
                remote.out.writeBytes(dbAlias);
            }
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0) {
                dbInfo = new KnoDBInfo();
                dbInfo.icon = remote.in.readByte();
                dbInfo.isLocal = remote.in.readInt();
                dbInfo.dbType = remote.in.readInt();
                dbInfo.port = remote.in.readInt();
                count = remote.in.readInt();
                byte[] description = new byte[count];
                remote.in.read(description);
                dbInfo.description = new String(description, "ISO-8859-1");
                count = remote.in.readInt();
                byte[] dirIP = new byte[count];
                remote.in.read(dirIP);
                dbInfo.dirIP = new String(dirIP);
                dbInfo.localAlias = dbAlias;
                count = remote.in.readInt();
                byte[] localFile = new byte[count];
                remote.in.read(localFile);
                dbInfo.localFile = new String(localFile);
                count = remote.in.readInt();
                byte[] remoteAlias = new byte[count];
                remote.in.read(remoteAlias);
                dbInfo.remoteAlias = new String(remoteAlias);
                count = remote.in.readInt();
                byte[] serverAlias = new byte[count];
                remote.in.read(serverAlias);
                dbInfo.serverAlias = new String(serverAlias);
            }
        }
        catch (IOException e) {
            dbInfo = null;
            if (lastError == 0) {
                lastError = 2;
            }
            throw new ExceptionKnoCatalog("Unavailable server (2) getDBInfo: " + e.getMessage());
        }
        catch (Exception e) {
            dbInfo = null;
            if (lastError == 0) {
                lastError = 7;
            }
            throw new ExceptionKnoCatalog("Unavailable catalog getDBInfo: " + e.getMessage());
        }
        return dbInfo;
    }

    protected Vector getDDBBList() throws ExceptionKnoCatalog {
        Vector<String> dbNames = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoCatalog("Unavailable server (1) getDDBBList.");
        }
        try {
            char numDB;
            int orden = 164;
            int dbType = 0;
            int count = 0;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.getHandle());
            remote.out.writeInt(dbType);
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0 && (numDB = remote.in.readChar()) != '\u0000') {
                dbNames = new Vector<String>(numDB);
                char n = '\u0000';
                while (n < numDB) {
                    count = remote.in.readInt();
                    if (count > 0) {
                        byte[] name = new byte[count];
                        remote.in.read(name);
                        dbNames.addElement(new String(name));
                    }
                    n = (char)(n + '\u0001');
                }
            }
        }
        catch (IOException e) {
            if (dbNames != null) {
                dbNames.removeAllElements();
            }
            dbNames = null;
            lastError = 2;
            throw new ExceptionKnoCatalog("Unavailable server (2) getDDBBList: " + e.getMessage());
        }
        catch (Exception e) {
            if (dbNames != null) {
                dbNames.removeAllElements();
            }
            dbNames = null;
            lastError = 7;
            throw new ExceptionKnoCatalog("Unavailable catalog getDDBBList: " + e.getMessage());
        }
        return dbNames;
    }

    protected Vector getObjColList() throws ExceptionKnoCatalog {
        Vector<String> dbNames = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoCatalog("Unavailable server (1) getObjColList.");
        }
        try {
            char numDB;
            int orden = 164;
            int dbType = 2;
            int count = 0;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.getHandle());
            remote.out.writeInt(dbType);
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0 && (numDB = remote.in.readChar()) != '\u0000') {
                dbNames = new Vector<String>(numDB);
                char n = '\u0000';
                while (n < numDB) {
                    count = remote.in.readInt();
                    if (count > 0) {
                        byte[] name = new byte[count];
                        remote.in.read(name);
                        dbNames.addElement(new String(name));
                    }
                    n = (char)(n + '\u0001');
                }
            }
        }
        catch (IOException e) {
            if (dbNames != null) {
                dbNames.removeAllElements();
            }
            dbNames = null;
            lastError = 2;
            throw new ExceptionKnoCatalog("Unavailable server (2) getObjColList: " + e.getMessage());
        }
        catch (Exception e) {
            if (dbNames != null) {
                dbNames.removeAllElements();
            }
            dbNames = null;
            lastError = 7;
            throw new ExceptionKnoCatalog("Unavailable catalog getObjColList: " + e.getMessage());
        }
        return dbNames;
    }

    protected char getHandle() {
        return this.handle;
    }

    protected static int getLastError() {
        return lastError;
    }

    protected KnoRemote getRemote() {
        return this.remote;
    }

    protected static KnoCatalog openCatalog(KnoRemote rem) throws ExceptionKnoCatalog {
        KnoCatalog catalog;
        block4: {
            catalog = null;
            if (rem == null) {
                throw new ExceptionKnoCatalog("Unspecified server openCatalog.");
            }
            try {
                catalog = new KnoCatalog();
                if (catalog.abreCatalogo(rem) != 0 || catalog.getHandle() == '\uffff') {
                    catalog = null;
                }
            }
            catch (Exception e) {
                catalog = null;
                if (lastError != 0) break block4;
                lastError = 7;
            }
        }
        return catalog;
    }

    protected String getAliasId() throws ExceptionKnoCatalog {
        String alias = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoCatalog("Unavailable server (1) getAliasId.");
        }
        try {
            int orden = 173;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.getHandle());
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0) {
                int count = remote.in.readInt();
                byte[] aliasId = new byte[count];
                remote.in.read(aliasId);
                alias = new String(aliasId);
            }
        }
        catch (IOException e) {
            if (lastError == 0) {
                lastError = 2;
            }
            throw new ExceptionKnoCatalog("Unavailable server (2) getAliasId: " + e.getMessage());
        }
        catch (Exception e) {
            if (lastError == 0) {
                lastError = 7;
            }
            throw new ExceptionKnoCatalog("Unavailable catalog getAliasId: " + e.getMessage());
        }
        return alias;
    }

    protected String getAliasByDBName(String dbName) throws ExceptionKnoCatalog {
        String alias = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoCatalog("Unavailable server (1) getAliasByDBName.");
        }
        try {
            int orden = 190;
            int count = 0;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.getHandle());
            count = dbName.length();
            remote.out.writeInt(count);
            if (count > 0) {
                remote.out.writeBytes(dbName);
            }
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0) {
                count = remote.in.readInt();
                byte[] aliasId = new byte[count];
                remote.in.read(aliasId);
                alias = new String(aliasId);
            }
        }
        catch (IOException e) {
            if (lastError == 0) {
                lastError = 2;
            }
            throw new ExceptionKnoCatalog("Unavailable server (2) getAliasByDBName: " + e.getMessage());
        }
        catch (Exception e) {
            if (lastError == 0) {
                lastError = 7;
            }
            throw new ExceptionKnoCatalog("Unavailable catalog getAliasByDBName: " + e.getMessage());
        }
        return alias;
    }

    protected String getAliasByDBId(String dbID) throws ExceptionKnoCatalog {
        String alias = null;
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoCatalog("Unavailable server (1) getAliasByDBId.");
        }
        try {
            int orden = 191;
            int count = 0;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.getHandle());
            count = dbID.length();
            remote.out.writeInt(count);
            if (count > 0) {
                remote.out.writeBytes(dbID);
            }
            remote.out.flush();
            lastError = remote.in.readChar();
            if (lastError == 0) {
                count = remote.in.readInt();
                byte[] aliasId = new byte[count];
                remote.in.read(aliasId);
                alias = new String(aliasId);
            }
        }
        catch (IOException e) {
            if (lastError == 0) {
                lastError = 2;
            }
            throw new ExceptionKnoCatalog("Unavailable server (2) getAliasByDBId: " + e.getMessage());
        }
        catch (Exception e) {
            if (lastError == 0) {
                lastError = 7;
            }
            throw new ExceptionKnoCatalog("Unavailable catalog getAliasByDBId: " + e.getMessage());
        }
        return alias;
    }

    protected void insertEntry2(String dbAlias, String dbName, String dbFile) throws ExceptionKnoCatalog {
        KnoRemote remote = this.getRemote();
        if (remote == null) {
            throw new ExceptionKnoCatalog("Unavailable server (1) insertEntry2.");
        }
        try {
            int orden = 160;
            int dbType = 0;
            int count = 0;
            remote.out.writeChar(orden);
            remote.out.writeChar(this.getHandle());
            remote.out.writeInt(dbType);
            count = dbAlias.length();
            remote.out.writeInt(count);
            if (count > 0) {
                remote.out.writeBytes(dbAlias);
            }
            count = dbFile.length();
            remote.out.writeInt(count);
            if (count > 0) {
                remote.out.writeBytes(dbFile);
            }
            count = dbName.length();
            remote.out.writeInt(count);
            if (count > 0) {
                remote.out.writeBytes(dbName);
            }
            remote.out.writeByte(1);
            remote.out.writeByte(0);
            String csClave = "";
            String mcsUserID = "SYSADM";
            count = csClave.length();
            remote.out.writeInt(count);
            if (count > 0) {
                remote.out.writeBytes(csClave);
            }
            count = mcsUserID.length();
            remote.out.writeInt(count);
            if (count > 0) {
                remote.out.writeBytes(mcsUserID);
            }
            remote.out.flush();
            lastError = remote.in.readChar();
        }
        catch (IOException e) {
            if (lastError == 0) {
                lastError = 2;
            }
            throw new ExceptionKnoCatalog("Unavailable server (2) insertEntry2: " + e.getMessage());
        }
        catch (Exception e) {
            if (lastError == 0) {
                lastError = 7;
            }
            throw new ExceptionKnoCatalog("Unavailable catalog insertEntry2: " + e.getMessage());
        }
    }
}

